package com.kidoz.sdk.api.ui_views.panel_view;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Looper;
import android.view.View;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.custom_drawables.DefaultPanelDrawable;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;

public class PanelHandle extends RelativeLayout
{
    public enum PANEL_HANDLE_VIEW_STATE
    {
        OPENED, CLOSED
    }

    private static final float DEFAULT_HANDLE_SCALE_SIZE = 0.15f;
    private AssetView mOpenAssetBgView;
    private AssetView mOpenAssetFrgView;
    private AssetView mCloseAssetBgView;
    private AssetView mCloseAssetFrgView;

    private RelativeLayout.LayoutParams mInnerOpenBtnLayParams;
    private RelativeLayout.LayoutParams mInnerCloseBtnLayParams;

    private DefaultPanelDrawable mLegacyOpenDefaultDrawable;
    private DefaultPanelDrawable mLegacyCloseDefaultDrawable;

    private DefaultPanelDrawable mOpenDefaultDrawable;
    private DefaultPanelDrawable mCloseDefaultDrawable;

    private int mHandleSize = 0;
    private PANEL_TYPE mPanelType;

    private int mColor = Color.WHITE;

    private IOnPanelHandleClickListener mClickListener;
    private Utils.StaticHandler mHandler;

    private boolean mIsLegacyAssets = true;

    public PanelHandle(Context context, PANEL_TYPE panelType, int size, IOnPanelHandleClickListener handleClickListener)
    {
        super(context);
        mHandler = new Utils.StaticHandler(Looper.getMainLooper());
        mHandleSize = size;
        mPanelType = panelType;
        mClickListener = handleClickListener;
        initHandle();
    }

    private void initHandle()
    {
        if (mHandleSize == 0)
        {
            Point point = Utils.getScreenSize(getContext());
            mHandleSize = (int) (Math.min(point.x, point.y) * DEFAULT_HANDLE_SCALE_SIZE);
        }

        mInnerOpenBtnLayParams = new RelativeLayout.LayoutParams(mHandleSize, mHandleSize);
        mInnerOpenBtnLayParams.addRule(RelativeLayout.CENTER_IN_PARENT);
        mInnerCloseBtnLayParams = new RelativeLayout.LayoutParams(mHandleSize, mHandleSize);
        mInnerCloseBtnLayParams.addRule(RelativeLayout.CENTER_IN_PARENT);

        mOpenAssetBgView = new AssetView(getContext());
        mOpenAssetBgView.setVisibility(View.INVISIBLE);

        mOpenAssetFrgView = new AssetView(getContext());
        mOpenAssetFrgView.setVisibility(View.INVISIBLE);

        mCloseAssetBgView = new AssetView(getContext());
        mCloseAssetBgView.setVisibility(View.INVISIBLE);

        mCloseAssetFrgView = new AssetView(getContext());
        mCloseAssetFrgView.setVisibility(View.INVISIBLE);


        addView(mCloseAssetBgView, mInnerCloseBtnLayParams);
        addView(mCloseAssetFrgView, mInnerCloseBtnLayParams);
        addView(mOpenAssetBgView, mInnerOpenBtnLayParams);
        addView(mOpenAssetFrgView, mInnerOpenBtnLayParams);

        setOnClickListener(new OnClickListener()
        {
            @Override
            public void onClick(final View v)
            {
                mHandler.postDelayed(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        playHandleClickAnimation(v);
                    }
                }, 180);
            }
        });
    }

    /**
     * @param helper   asset helper
     * @param listener prepared listener
     */
    public void loadAssets(LocalAssetHelper helper, final IonPanelHandlePreparedListener listener)
    {
        mIsLegacyAssets = helper.isLegacyParams();
        if (mIsLegacyAssets)
        {
            loadHandleLegacyAssets(helper, listener);
        } else
        {
            loadHandleAssets(helper, listener);
        }

        // Set correct layer rotation depending on version and usage
        setCorrectRotation();
    }

    private void loadHandleLegacyAssets(final LocalAssetHelper helper, final IonPanelHandlePreparedListener listener)
    {
        mLegacyOpenDefaultDrawable = new DefaultPanelDrawable(getContext(), mPanelType, DefaultPanelDrawable.PanelDrawableType.OPEN_VIEW);
        mLegacyOpenDefaultDrawable.setBaseColor(mColor);
        mLegacyCloseDefaultDrawable = new DefaultPanelDrawable(getContext(), mPanelType, DefaultPanelDrawable.PanelDrawableType.CLOSE_VIEW);
        mLegacyCloseDefaultDrawable.setBaseColor(mColor);

        mOpenAssetBgView.setVisibility(View.GONE);
        mCloseAssetBgView.setVisibility(View.INVISIBLE);
        mOpenAssetFrgView.setVisibility(View.INVISIBLE);
        mCloseAssetFrgView.setVisibility(View.INVISIBLE);

        mOpenAssetBgView.loadAsset(helper.legacyBtnOpenAsset, mLegacyOpenDefaultDrawable, new AssetView.IOnAssetLoadedListener()
        {
            @Override
            public void onAssetLoaded(boolean successfull)
            {
                if (successfull == false)
                {
                    mOpenAssetFrgView.loadAsset(helper.legacyBtnDefaultOpenSponsoredAsset, null, new AssetView.IOnAssetLoadedListener()
                    {
                        @Override
                        public void onAssetLoaded(boolean successfull)
                        {
                            if (successfull)
                            {
                                mLegacyOpenDefaultDrawable.setDrawSign(false);
                            } else
                            {
                                //mOpenDefaultDrawable.setDrawSign(true);
                                mOpenAssetFrgView.setVisibility(View.INVISIBLE);
                            }

                            mCloseAssetFrgView.loadAsset(helper.legacyBtnCloseAsset, mLegacyCloseDefaultDrawable, new AssetView.IOnAssetLoadedListener()
                            {
                                @Override
                                public void onAssetLoaded(boolean successfull)
                                {
                                    if (listener != null)
                                    {
                                        listener.onPanelPrepared();
                                    }
                                }
                            });
                        }
                    });
                } else
                {
                    mCloseAssetFrgView.loadAsset(helper.legacyBtnCloseAsset, mLegacyCloseDefaultDrawable, new AssetView.IOnAssetLoadedListener()
                    {
                        @Override
                        public void onAssetLoaded(boolean successfull)
                        {
                            if (listener != null)
                            {
                                listener.onPanelPrepared();
                            }
                        }
                    });
                }
            }
        });
    }

    private void loadHandleAssets(final LocalAssetHelper helper, final IonPanelHandlePreparedListener listener)
    {
        mOpenDefaultDrawable = new DefaultPanelDrawable(getContext(), PANEL_TYPE.BOTTOM, DefaultPanelDrawable.PanelDrawableType.OPEN_VIEW);
        mOpenDefaultDrawable.setBaseColor(mColor);
        mOpenDefaultDrawable.setDrawSign(false);

        mCloseDefaultDrawable = new DefaultPanelDrawable(getContext(), PANEL_TYPE.BOTTOM, DefaultPanelDrawable.PanelDrawableType.CLOSE_VIEW);
        mCloseDefaultDrawable.setBaseColor(mColor);
        mCloseDefaultDrawable.setDrawSign(false);

        mOpenAssetFrgView.loadAsset(helper.openBtnAssetFrg, null, new AssetView.IOnAssetLoadedListener()
        {
            @Override
            public void onAssetLoaded(boolean successfull)
            {
                if (successfull == false)
                {
                    mOpenDefaultDrawable.setDrawSign(true);
                } else
                {
                    mOpenDefaultDrawable.setDrawSign(false);
                }

                mOpenAssetBgView.loadAsset(helper.openBtnAssetBg, mOpenDefaultDrawable, new AssetView.IOnAssetLoadedListener()
                {
                    @Override
                    public void onAssetLoaded(boolean successfull)
                    {
                        mCloseAssetFrgView.loadAsset(helper.closeBtnAssetFrg, null, new AssetView.IOnAssetLoadedListener()
                        {
                            @Override
                            public void onAssetLoaded(boolean successfull)
                            {
                                if (successfull == false)
                                {
                                    mCloseDefaultDrawable.setDrawSign(true);
                                } else
                                {
                                    mCloseDefaultDrawable.setDrawSign(false);
                                }

                                mCloseAssetBgView.loadAsset(helper.closeBtnAssetBg, mCloseDefaultDrawable, new AssetView.IOnAssetLoadedListener()
                                {
                                    @Override
                                    public void onAssetLoaded(boolean successfull)
                                    {
                                        if (listener != null)
                                        {
                                            listener.onPanelPrepared();
                                        }
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    public void setBaseColor(int baseColor)
    {
        mColor = baseColor;
        if (mOpenDefaultDrawable != null && mCloseDefaultDrawable != null)
        {
            mOpenDefaultDrawable.setBaseColor(baseColor);
            mCloseDefaultDrawable.setBaseColor(baseColor);
        }

        if (mLegacyCloseDefaultDrawable != null && mLegacyOpenDefaultDrawable != null)
        {
            mLegacyCloseDefaultDrawable.setBaseColor(baseColor);
            mLegacyOpenDefaultDrawable.setBaseColor(baseColor);
        }

        postInvalidate();
    }

    public void setPanelType(PANEL_TYPE panelType)
    {
        mPanelType = panelType;
        if (mLegacyOpenDefaultDrawable != null && mLegacyCloseDefaultDrawable != null)
        {
            mLegacyCloseDefaultDrawable.setPanelType(mPanelType);
            mLegacyOpenDefaultDrawable.setPanelType(mPanelType);
        }

        // Set correct layer rotation depending on version and usage
        setCorrectRotation();
    }

    private void setCorrectRotation() {
        if (mIsLegacyAssets == false)
        {
            switch (mPanelType)
            {
                case BOTTOM:
                {
                    mOpenAssetBgView.setRotation(0f);
                    mCloseAssetBgView.setRotation(0f);
                    break;
                }
                case TOP:
                {
                    mOpenAssetBgView.setRotation(180f);
                    mCloseAssetBgView.setRotation(180f);
                    break;
                }
            }
        }
        postInvalidate();
    }


    private void postInvalidateLayers() {
        mOpenAssetBgView.postInvalidate();
        mOpenAssetFrgView.postInvalidate();
        mCloseAssetBgView.postInvalidate();
        mCloseAssetFrgView.postInvalidate();
    }


    public interface IOnPanelHandleClickListener
    {
        void onHandleClick();
    }

    public void setPanelButtonState(PANEL_HANDLE_VIEW_STATE panelHandleState)
    {
        switch (panelHandleState)
        {
            case CLOSED:
            {
                if (mIsLegacyAssets)
                {
                    mOpenAssetBgView.setVisibility(View.VISIBLE);
                    mOpenAssetFrgView.setVisibility(View.VISIBLE);
                    mCloseAssetFrgView.setVisibility(View.INVISIBLE);
                } else
                {
                    mOpenAssetBgView.setVisibility(View.VISIBLE);
                    mOpenAssetFrgView.setVisibility(View.VISIBLE);
                    mCloseAssetBgView.setVisibility(View.INVISIBLE);
                    mCloseAssetFrgView.setVisibility(View.INVISIBLE);
                }
                break;
            }

            case OPENED:
            {
                if (mIsLegacyAssets)
                {
                    mOpenAssetBgView.setVisibility(View.INVISIBLE);
                    mOpenAssetFrgView.setVisibility(View.INVISIBLE);
                    mCloseAssetFrgView.setVisibility(View.VISIBLE);
                } else
                {
                    mOpenAssetBgView.setVisibility(View.INVISIBLE);
                    mOpenAssetFrgView.setVisibility(View.INVISIBLE);
                    mCloseAssetBgView.setVisibility(View.VISIBLE);
                    mCloseAssetFrgView.setVisibility(View.VISIBLE);
                }
                break;
            }
        }
        postInvalidate();
    }

    private void playHandleClickAnimation(View v)
    {
        GenAnimator.playPanelButtonClickAnimation(v, mPanelType, new Animator.AnimatorListener()
        {
            @Override
            public void onAnimationStart(Animator animation)
            {
            }

            @Override
            public void onAnimationEnd(Animator animation)
            {
                if (mClickListener != null)
                {
                    mClickListener.onHandleClick();
                }
            }

            @Override
            public void onAnimationCancel(Animator animation)
            {
            }

            @Override
            public void onAnimationRepeat(Animator animation)
            {
            }
        });
    }

    public interface IonPanelHandlePreparedListener
    {
        void onPanelPrepared();
    }
}


/* if (helper.openBtnAssetFrg != null)
        {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(helper.openBtnAssetFrg.getAbsolutePath(), options);
            if (options.outHeight != 0 && options.outWidth != 0)
            {
                float ratio = options.outHeight / ((float) options.outWidth);
                int size = (int) (mHandleSize * ratio);
                if (size != 0)
                {
                    mInnerOpenBtnLayParams.height = size;
                }
            }
        }

        if (helper.closeBtnAssetBg != null)
        {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(helper.closeBtnAssetBg.getAbsolutePath(), options);
            if (options.outHeight != 0 && options.outWidth != 0)
            {
                float ratio = options.outHeight / ((float) options.outWidth);
                int size = (int) (mHandleSize * ratio);
                if (size != 0)
                {
                    mInnerCloseBtnLayParams.height = size;
                }
            }
        }*/