package com.kidoz.sdk.api.ui_views.panel_view;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.assets_handling.StyleParser;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;

import org.json.JSONObject;

import java.io.File;

public class OneContentItemView extends LinearLayout
{
    private RelativeLayout mContainer;
    private TextView mItemName;
    private ImageView mItemThumbnail;
    private ImageView mItemTypeIcon;
    private ImageView mPromotedIndication;
    private LinearLayout mNameContainerLay;
    private RelativeLayout.LayoutParams mPromotedIndicationParams;
    private File mImageFile;

    public int mWidth = 0;
    public int mHeight = 0;

    private ContentItem mContentItem;
    private FrameLayout mWebViewContainerLayout;

    private FrameLayout.LayoutParams webViewParams;
    private JSONObject mProperties;

    public OneContentItemView(JSONObject properties, Context context, int w, int h)
    {
        super(context);
        mWidth = w;
        mHeight = h;
        mProperties = properties;
        initView();
    }

    private void initView()
    {
        //  initRootView(mPanelType);
        initContainer();
        initItemThumbnail();
        initItemName();
        initItemTypeIcon();
        initPromotedIndication();

        mWebViewContainerLayout = new FrameLayout(getContext());
        mContainer.addView(mWebViewContainerLayout, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT));
    }

    private void initContainer()
    {
        mContainer = new RelativeLayout(getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        addView(mContainer, params);
    }

    private void initItemThumbnail()
    {
        mItemThumbnail = new ImageView(getContext());
        mItemThumbnail.setId(Utils.generateViewId());
        mItemThumbnail.setScaleType(ImageView.ScaleType.FIT_XY);

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(mWidth, mHeight);
        mContainer.addView(mItemThumbnail, params);
    }

    private void initPromotedIndication()
    {
        mPromotedIndication = new ImageView(getContext());
        mPromotedIndication.setId(Utils.generateViewId());
        mPromotedIndication.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        mPromotedIndicationParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);

        mPromotedIndicationParams.width = (int) (mWidth * (float) mProperties.optDouble(StyleParser.PROMOTED_INDICATOR_SIZE, 0.20f));
        mPromotedIndicationParams.height = (int) (mPromotedIndicationParams.width * (float) mProperties.optDouble(StyleParser.PROMOTED_INDICATOR_RATIO, 0.25f));
        mPromotedIndicationParams.addRule(RelativeLayout.ALIGN_LEFT, mItemThumbnail.getId());
        mPromotedIndicationParams.addRule(RelativeLayout.ALIGN_TOP, mItemThumbnail.getId());
        mContainer.addView(mPromotedIndication, mPromotedIndicationParams);
    }

    private void initItemTypeIcon()
    {
        RelativeLayout.LayoutParams anchorParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        RelativeLayout anchor = new RelativeLayout(getContext());
        anchorParams.addRule(RelativeLayout.ABOVE, mNameContainerLay.getId());
        mContainer.addView(anchor, anchorParams);

        //float MARGIN_RIGHT = 50f / ITEM_WIDTH;
        mItemTypeIcon = new ImageView(getContext());
        mItemTypeIcon.setId(Utils.generateViewId());
        mItemTypeIcon.setScaleType(ImageView.ScaleType.FIT_CENTER);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        params.width = (int) (mWidth * 0.4f);
        params.height = (int) (mHeight * 0.4f);
        params.addRule(RelativeLayout.CENTER_IN_PARENT);
        //        int margin = (int) (mHeight * 0.20f);
        //        params.setMargins(0, margin, 0, margin);
        anchor.addView(mItemTypeIcon, params);
    }

    private void initItemName()
    {
        mItemName = new TextView(getContext());
        mItemName.setMaxLines(1);
        mItemName.setEllipsize(TextUtils.TruncateAt.END);
        mItemName.setTextColor(Color.parseColor("#d7dee0"));
        mItemName.setGravity(Gravity.CENTER_VERTICAL);

        mNameContainerLay = new LinearLayout(getContext());
        mNameContainerLay.setId(Utils.generateViewId());
        mNameContainerLay.setBackgroundColor(Color.parseColor("#cb3b3a37"));

        LinearLayout.LayoutParams linParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        mNameContainerLay.addView(mItemName, linParams);

        int textSize = (int) (mWidth * 0.048f);
        int margin = (int) (mWidth * 0.025f);
        mItemName.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
        linParams.setMargins(Utils.dpTOpx(getContext(), 5), margin, Utils.dpTOpx(getContext(), 5), margin);

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        mContainer.addView(mNameContainerLay, params);
    }

    private void loadBackgroundColor()
    {
        setBackgroundColor(Color.WHITE);
        if (mContentItem != null)
        {
            setBackgroundColor(mContentItem.getPaliteBgColor());
        }
    }

    private void loadThumbnail()
    {
        mItemThumbnail.setImageBitmap(null);
        if (mContentItem != null)
        {
            if (mContentItem.getThumb() != null && !mContentItem.getThumb().equals("") && mWidth > 0 && mHeight > 0)
            {
                PicassoOk.getPicasso(getContext()).load(mContentItem.getThumb()).resize(mWidth, mHeight).centerCrop().into(mItemThumbnail);
            }
        }
    }

    private void loadItemTypeIcon()
    {
        mItemTypeIcon.setImageBitmap(null);
        if (mContentItem != null && mItemTypeIcon != null)
        {
            if (mContentItem.getSecThumb() != null && !mContentItem.getSecThumb().equals(""))
            {
                PicassoOk.getPicasso(getContext()).load(mContentItem.getSecThumb()).into(mItemTypeIcon);
            }
        }
    }

    private void loadIteNameAndSetTextColor()
    {
        if (mContentItem != null)
        {
            mItemName.setText(mContentItem.getName());
        }
    }

    private void setPromotedIndication()
    {
        if (mProperties != null)
        {
            mImageFile = AssetUtil.getAssetFile(getContext(), mProperties.optString(StyleParser.PROMOTED_INDICATOR_URL, null));
        }

        mPromotedIndication.setImageBitmap(null);
        if (mContentItem != null && mContentItem.isPromoted() == true)
        {
            if (mImageFile != null && mImageFile.exists() == true)
            {
                if (mPromotedIndicationParams.width > 0 && mPromotedIndicationParams.height > 0)
                {
                    PicassoOk.getPicasso(getContext()).load(mImageFile).resize(mPromotedIndicationParams.width, mPromotedIndicationParams.height).centerInside().into(mPromotedIndication);
                }
            }
        }
    }

    public void setData(ContentItem contentItem)
    {
        mContentItem = contentItem;

        loadBackgroundColor();
        loadThumbnail();
        loadItemTypeIcon();
        setPromotedIndication();

        if (mContentItem != null)
        {
            if (mContentItem.getIsHideTextOverlay())
            {
                mNameContainerLay.setVisibility(View.GONE);
            } else
            {
                loadIteNameAndSetTextColor();
                mNameContainerLay.setVisibility(View.VISIBLE);
            }
        }
    }

    public void setActiveWebView(HtmlViewWrapper webview)
    {
        mWebViewContainerLayout.removeAllViews();
        ViewGroup group = (ViewGroup) webview.getParent();
        if (group != null)
        {
            group.removeAllViews();
        }

        if (webViewParams == null)
        {
            webViewParams = new FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.MATCH_PARENT);
        }

        mWebViewContainerLayout.addView(webview, webViewParams);
    }

    public void clearActiveWebView()
    {
        mWebViewContainerLayout.removeAllViews();
    }

    public void applyViewSettingsByContentType(ContentType contentType)
    {
        if (contentType != null && contentType == ContentType.HTML)
        {
            mNameContainerLay.setVisibility(View.INVISIBLE);
            mItemTypeIcon.setVisibility(View.INVISIBLE);
        } else
        {
            mNameContainerLay.setVisibility(View.VISIBLE);
            mItemTypeIcon.setVisibility(View.VISIBLE);
        }
    }
}