package com.kidoz.sdk.api.ui_views.custom_drawables;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;


public class XViewDrawable extends Drawable {

    private Paint mXPaint = new Paint(Paint.ANTI_ALIAS_FLAG);

    private int mWidth;
    private int mHeight;
    private int mDefaultColor = Color.WHITE;

    public XViewDrawable(Context context,int color) {
        mDefaultColor = color;
        init(context);
    }

    private void init(Context context) {
        mXPaint.setDither(true);
        mXPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mXPaint.setColor(mDefaultColor);
        mXPaint.setStrokeWidth(getStrokeSizeByScreenLayout(context));
        mXPaint.setStrokeCap(Paint.Cap.ROUND);
        mXPaint.setDither(true);
    }

    @Override
    public void draw(Canvas canvas) {
        canvas.drawLine(0, mHeight, mWidth, 0, mXPaint);
        canvas.drawLine(0, 0, mWidth, mHeight, mXPaint);
    }

    @Override
    public void setAlpha(int alpha) {
        mXPaint.setAlpha(alpha);
    }

    @Override
    public void setColorFilter(ColorFilter cf) {
        mXPaint.setColorFilter(cf);
    }

    @Override
    public int getOpacity() {
        return PixelFormat.TRANSLUCENT;
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);

        mWidth = bounds.width();
        mHeight = bounds.height();
    }

    private static int getStrokeSizeByScreenLayout(Context context) {
        int size = 9;
        int screenLayout = context.getResources().getConfiguration().screenLayout;
        screenLayout &= Configuration.SCREENLAYOUT_SIZE_MASK;

        switch (screenLayout) {
            case Configuration.SCREENLAYOUT_SIZE_SMALL: {
                size = 5;
                break;
            }

            case Configuration.SCREENLAYOUT_SIZE_NORMAL: {
                size = 8;
                break;
            }

            case Configuration.SCREENLAYOUT_SIZE_LARGE: {
                size = 5;
                break;
            }

            case Configuration.SCREENLAYOUT_SIZE_XLARGE: {
                size = 5;
                break;
            }
        }
        return size;
    }
}
