package com.kidoz.sdk.api.ui_views.custom_drawables;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;

public class VideoUnitDrawable extends Drawable
{
    private Paint mPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
    private RectF mRectF = new RectF();
    private Path mPath = new Path();

    private int mWidth;
    private int mHeight;

    private float mDefaultBgRadius;

    public VideoUnitDrawable()
    {
        mPaint.setDither(true);
    }

    @Override
    public void draw(Canvas canvas)
    {
        mPaint.setColor(Color.parseColor("#7297A3"));
        mPaint.setShader(null);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP)
        {
            canvas.drawRoundRect(0, 0, mWidth, mHeight, mDefaultBgRadius, mDefaultBgRadius, mPaint);

            mPaint.setColor(Color.parseColor("#90C3D4"));
            canvas.drawRoundRect(0, 0, mWidth, mHeight - (0.05f * mHeight), mDefaultBgRadius, mDefaultBgRadius, mPaint);
        }
        else
        {
            canvas.drawRoundRect(mRectF, mDefaultBgRadius, mDefaultBgRadius, mPaint);

            mPaint.setColor(Color.parseColor("#90C3D4"));
            mRectF.set(0, 0, mWidth, mHeight - (0.05f * mHeight));
            canvas.drawRoundRect(mRectF, mDefaultBgRadius, mDefaultBgRadius, mPaint);
            mRectF = new RectF(0, 0, mWidth, mHeight);
            mRectF.set(0, 0, mWidth, mHeight);
        }

        mPaint.setShader(new LinearGradient(0, 0, 0, mHeight, Color.parseColor("#614C45"), Color.parseColor("#FAC7B6"), Shader.TileMode.CLAMP));
        canvas.drawPath(mPath, mPaint);

        mPaint.setShader(null);
        mPaint.setColor(Color.parseColor("#362A25"));
        mPaint.setTextSize(0.12f * mWidth);
        mPaint.setTextAlign(Paint.Align.CENTER);
        mPaint.setTypeface(Typeface.create(Typeface.DEFAULT, Typeface.BOLD));
        canvas.drawText("KIDOZ TV", mWidth / 2f, mHeight - (0.1f * mHeight), mPaint);
    }

    @Override
    public void setAlpha(int alpha)
    {
        mPaint.setAlpha(alpha);
    }

    @Override
    public void setColorFilter(ColorFilter cf)
    {
        mPaint.setColorFilter(cf);
    }

    @Override
    public int getOpacity()
    {
        return PixelFormat.TRANSLUCENT;
    }

    @Override
    protected void onBoundsChange(Rect bounds)
    {
        super.onBoundsChange(bounds);

        mWidth = bounds.width();
        mHeight = bounds.height();

        mRectF = new RectF(0, 0, mWidth, mHeight);
        mDefaultBgRadius = 0.10f * mWidth;

        mPath = new Path();
        mPath.setFillType(Path.FillType.EVEN_ODD);
        mPath.moveTo(mWidth / 4f, (mHeight - (0.05f * mHeight)) / 4f);
        mPath.lineTo(mWidth / 4f, mHeight - (mHeight / 4f));
        mPath.lineTo(mWidth - (mWidth / 4f), mHeight / 2f);
        mPath.close();
    }
}
