package com.kidoz.sdk.api.players.video_player;


public class VideoJavaScriptInterface
{
    private JavascriptListener mJavascriptListener;
    private IOnReadyLocalListener mReadyLocalListener;

    public void setJavascriptListener(JavascriptListener javascriptListener)
    {
        mJavascriptListener = javascriptListener;
    }

    @android.webkit.JavascriptInterface public void onVideoReady()
    {
        mJavascriptListener.onVideoReady();
    }

    @android.webkit.JavascriptInterface public void onError(final int errorCode)
    {
        mJavascriptListener.onError(errorCode);
    }

    @android.webkit.JavascriptInterface public void onStateChange(final int state)
    {
        mJavascriptListener.onStateChange(state);
    }

    @android.webkit.JavascriptInterface public void setVideoCurrentTime(final int currentTimeInSeconds)
    {

    }

    @android.webkit.JavascriptInterface public void setVideoTotalTime(final int totalTimeInSeconds)
    {

    }

    @android.webkit.JavascriptInterface public void onQualityChanged(final String quality)
    {
    }

    public interface JavascriptListener
    {
         void onVideoReady();

         void onError(final int errorCode);

         void onStateChange(final int state);

         void onViewReady();
    }

    @android.webkit.JavascriptInterface
    public void onViewReady()
    {
        if (mReadyLocalListener != null)
        {
            mReadyLocalListener.onLocalReady();
        }

        if (mJavascriptListener != null)
        {
            mJavascriptListener.onViewReady();
        }
    }

    public interface IOnReadyLocalListener
    {
        void onLocalReady();
    }

    public void setLocalReadyListener(IOnReadyLocalListener listener)
    {
        mReadyLocalListener = listener;
    }
}
