package com.kidoz.sdk.api.platforms;

import android.app.Activity;

import com.kidoz.sdk.api.general.utils.ConstantDef;

public class YoYoGmsBridge extends BasePlatformsBridge
{
    private IOnGmsEventListener mGmsEventListener;

    public YoYoGmsBridge(Activity context, IOnGmsEventListener eventListener)
    {
        super(context);
        mGmsEventListener = eventListener;
        ConstantDef.SDK_EXTENSION_TYPE = ConstantDef.EXTENSION_TYPE_GMS;
    }

    @Override
    public void onClbkFeedDismissView()
    {
        mGmsEventListener.onFeedDismissEvent();
    }

    @Override
    public void onClbkFeedReadyToShow()
    {
        mGmsEventListener.onFeedReadyToShowEvent();
    }

    @Override
    public void onClbkFeedViewReady()
    {
        mGmsEventListener.onFeedReadyEvent();
    }

    @Override
    public void onClbkPanelViewCollapsed()
    {
        mGmsEventListener.onPanelCollapseEvent();
    }

    @Override
    public void onClbkPanelViewReady()
    {
        mGmsEventListener.onPanelReadyEvent();
    }

    @Override
    public void onClbkPanelViewExpanded()
    {
        mGmsEventListener.onPanelExpandEvent();
    }

    @Override
    public void onClbkFlexiViewReady()
    {
        mGmsEventListener.onFlexiViewReadyEvent();
    }

    @Override
    public void onClbkFlexiViewHidden()
    {
        mGmsEventListener.onFlexiViewHideEvent();
    }

    @Override
    public void onClbkFlexiViewVisible()
    {
        mGmsEventListener.onFlexiViewVisibleEvent();
    }

    @Override
    public void onClbkPlayerOpened()
    {
        mGmsEventListener.onPlayerOpenEvent();
    }

    @Override
    public void onClbkPlayerClosed()
    {
        mGmsEventListener.onPlayerCloseEvent();
    }

    @Override
    public void onClbkInterstitialOpened()
    {
        mGmsEventListener.onInterstitialOpenEvent();
    }

    @Override
    public void onClbkInterstitialClosed()
    {
        mGmsEventListener.onInterstitialCloseEvent();
    }

    @Override
    public void onClbkInterstitialReady()
    {
        mGmsEventListener.onInterstitialReadyEvent();
    }

    @Override
    public void onClbkInterstitialLoadFailed()
    {
        mGmsEventListener.onInterstitialLoadFailedEvent();
    }

    @Override
    public void onClbkRewarded()
    {
        mGmsEventListener.onRewardedEvent();
    }

    @Override
    public void onClbkRewardedVideoStarted()
    {
        mGmsEventListener.onRewardedVideoStartedEvent();
    }

    @Override
    public void onClbkVideoUnitReady()
    {
        mGmsEventListener.onVideoUnitReadyEvent();
    }

    @Override
    public void onClbkVideoUnitOpen()
    {
        mGmsEventListener.onVideoUnitOpenEvent();
    }

    @Override
    public void onClbkVideoUnitClose()
    {
        mGmsEventListener.onVideoUnitCloseEvent();
    }



    public interface IOnGmsEventListener
    {
        void onFeedDismissEvent();

        void onFeedReadyToShowEvent();

        void onFeedReadyEvent();

        void onPanelCollapseEvent();

        void onPanelExpandEvent();

        void onPanelReadyEvent();

        void onFlexiViewReadyEvent();

        void onFlexiViewHideEvent();

        void onFlexiViewVisibleEvent();

        void onPlayerOpenEvent();

        void onPlayerCloseEvent();

        void onInterstitialOpenEvent();

        void onInterstitialCloseEvent();

        void onInterstitialReadyEvent();

        void onInterstitialLoadFailedEvent();

        void onRewardedEvent();

        void onRewardedVideoStartedEvent();

        void onVideoUnitReadyEvent();

        void onVideoUnitOpenEvent();

        void onVideoUnitCloseEvent();
    }
}
