package com.kidoz.sdk.api.platforms;

import android.content.Context;

import com.adobe.fre.FREContext;
import com.adobe.fre.FREExtension;
import com.adobe.fre.FREFunction;
import com.adobe.fre.FREObject;
import com.adobe.fre.FREWrongThreadException;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.utils.SDKLogger;

import java.util.HashMap;
import java.util.Map;

public class KidozAirBridgeExtension implements FREExtension
{
    public static final String TAG = "KidozAdobeAirBridge";

    public static FREContext extensionContext;
    public static Context appContext;
    public static AdobeAirUiManager mAdobeAirUiManager;

    @Override
    public FREContext createContext(String arg0)
    {
        return new KidozAdobeAirBridgeContext();
    }

    @Override
    public void dispose()
    {
        appContext = null;
        extensionContext = null;
        mAdobeAirUiManager = null;
    }

    @Override
    public void initialize()
    {
        SDKLogger.printDebbugLog(TAG, "Extension initialized.");
    }

    /**
     * Send event to Action script using the extension
     */
    public static void sendEventToActionScript(String code, String level)
    {
        extensionContext.dispatchStatusEventAsync(code, level);
    }
}

class KidozAdobeAirBridgeContext extends FREContext
{
    public static final String TAG = "VolumeExtensionContext";

    private static final String FK_INIT_SDK = "initSdk";
    private static final String FK_ADD_FEED_BUTTON = "addFeedButton";
    private static final String FK_ADD_FEED_BUTTON_WITH_SIZE = "addFeedButtonWithSize";
    private static final String FK_SHOW_FEED_VIEW = "showFeedView";
    private static final String FK_DISMISS_FEED_VIEW = "dismissFeedView";
    private static final String FK_ADD_PANEL = "addPanelView";
    private static final String FK_CHANGE_FEED_VISIBILITY = "changeFeedButtonVisibility";
    private static final String FK_CHANGE_PANEL_VISIBILITY = "changePanelVisibility";
    private static final String FK_COLLAPSE_PANEL = "collapsePanelView";
    private static final String FK_EXPAND_PANEL = "expandPanelView";
    private static final String FK_IS_PANEL_EXPANDED = "isPanelExpanded";
    private static final String FK_ADD_FLEXI_VIEW = "addFlexiView";
    private static final String FK_SHOW_FLEXI_VIEW = "showFlexiView";
    private static final String FK_HIDE_FLEXI_VIEW = "hideFlexiView";
    private static final String FK_GET_IS_FLEXI_VIEW_VISIBLE = "getIsFlexiViewVisible";
    private static final String FK_SHOW_INTERSTITIAL = "showInterstitial";
    private static final String FK_LOAD_INTERSTITIAL = "loadInterstitial";
    private static final String FK_IS_INTERSTITIAL_LOADED = "isInterstitialLoaded";
    private static final String FK_SHOW_VIDEO_UNIT = "showVideoUnit";
    private static final String FK_PRINT_TOAST_LOG = "printToastLog";

    @Override
    public void dispose()
    {
        SDKLogger.printDebbugLog(TAG, "Context disposed.");
    }

    @Override
    public Map<String, FREFunction> getFunctions()
    {
        Map<String, FREFunction> functions = new HashMap<String, FREFunction>();

        functions.put(FK_INIT_SDK, new initSdk());

        // Button and feed functions
        functions.put(FK_ADD_FEED_BUTTON, new addFeedButton());
        functions.put(FK_ADD_FEED_BUTTON_WITH_SIZE, new addFeedButtonWithSize());
        functions.put(FK_SHOW_FEED_VIEW, new showFeedView());
        functions.put(FK_DISMISS_FEED_VIEW, new dismissFeedView());

        // Panel functions
        functions.put(FK_ADD_PANEL, new addPanelView());
        functions.put(FK_CHANGE_FEED_VISIBILITY, new changeFeedButtonVisibility());
        functions.put(FK_CHANGE_PANEL_VISIBILITY, new changePanelVisibility());
        functions.put(FK_COLLAPSE_PANEL, new collapsePanelView());
        functions.put(FK_EXPAND_PANEL, new expandPanelView());
        functions.put(FK_IS_PANEL_EXPANDED, new getPanelState());

        // Flexi view functions
        functions.put(FK_ADD_FLEXI_VIEW, new addFlexiView());
        functions.put(FK_SHOW_FLEXI_VIEW, new showFlexiView());
        functions.put(FK_HIDE_FLEXI_VIEW, new hideFlexiView());
        functions.put(FK_GET_IS_FLEXI_VIEW_VISIBLE, new getIsFlexiViewVisible());

        // Interstitial
        functions.put(FK_SHOW_INTERSTITIAL, new showInterstitial());
        functions.put(FK_LOAD_INTERSTITIAL, new loadInterstitial());
        functions.put(FK_IS_INTERSTITIAL_LOADED, new isInterstitialLoaded());

        // Video Unit
        functions.put(FK_SHOW_VIDEO_UNIT, new showVideoUnit());

        functions.put(FK_PRINT_TOAST_LOG, new printToastLog());

        return functions;
    }
}

class initSdk implements FREFunction
{
    public static final String TAG = initSdk.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {
        // Assign extension context
        KidozAirBridgeExtension.extensionContext = context;
        // Assign main application context
        Context appContext = context.getActivity();
        KidozAirBridgeExtension.appContext = appContext;
        // Initiate UI manager
        KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(appContext);

        try
        {
            KidozSDK.initialize(appContext, arg1[0].getAsString(), arg1[1].getAsString());
        } catch (Exception e)
        {
        }
        return null;
    }
}

class addFeedButton implements FREFunction
{
    public static final String TAG = addFeedButton.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {
        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            KidozAirBridgeExtension.mAdobeAirUiManager.addFeedButton(arg1[0].getAsInt(), arg1[1].getAsInt(), -1);
        } catch (Exception e)
        {
        }
        return null;
    }
}

@Deprecated
/** Deprecated from version >= 0.7.0 */
class addFeedButtonWithSize implements FREFunction
{
    public static final String TAG = addFeedButtonWithSize.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {
        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            KidozAirBridgeExtension.mAdobeAirUiManager.addFeedButton(arg1[0].getAsInt(), arg1[1].getAsInt(), arg1[2].getAsInt());
        } catch (Exception e)
        {
        }
        return null;
    }
}

class showFeedView implements FREFunction
{
    public static final String TAG = showFeedView.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {
        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            KidozAirBridgeExtension.mAdobeAirUiManager.showFeedView();
        } catch (Exception e)
        {
        }
        return null;
    }
}

class dismissFeedView implements FREFunction
{
    public static final String TAG = dismissFeedView.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {
        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            KidozAirBridgeExtension.mAdobeAirUiManager.dismissFeedView();
        } catch (Exception e)
        {
        }
        return null;
    }
}

class changeFeedButtonVisibility implements FREFunction
{
    public static final String TAG = changeFeedButtonVisibility.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {
        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            KidozAirBridgeExtension.mAdobeAirUiManager.changeFeedButtonVisibility(arg1[0].getAsBool());
        } catch (Exception e)
        {
        }
        return null;
    }
}

class addPanelView implements FREFunction
{
    public static final String TAG = addPanelView.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {
        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            KidozAirBridgeExtension.mAdobeAirUiManager.addPanelToView(arg1[0].getAsInt(), arg1[1].getAsInt(), arg1[2].getAsBool(), (float) arg1[3].getAsDouble(), (float) arg1[4].getAsDouble());
        } catch (Exception e)
        {
        }
        return null;
    }
}

class changePanelVisibility implements FREFunction
{
    public static final String TAG = changePanelVisibility.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {

        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            KidozAirBridgeExtension.mAdobeAirUiManager.changePanelVisibility(arg1[0].getAsBool());
        } catch (Exception e)
        {
        }
        return null;
    }
}

class expandPanelView implements FREFunction
{
    public static final String TAG = expandPanelView.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {

        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            KidozAirBridgeExtension.mAdobeAirUiManager.expandPanelView();
        } catch (Exception e)
        {
        }
        return null;
    }
}

class collapsePanelView implements FREFunction
{
    public static final String TAG = collapsePanelView.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {

        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            KidozAirBridgeExtension.mAdobeAirUiManager.collapsePanelView();
        } catch (Exception e)
        {
        }
        return null;
    }
}

class getPanelState implements FREFunction
{
    public static final String TAG = getPanelState.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {
        boolean expanded = false;
        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            expanded = KidozAirBridgeExtension.mAdobeAirUiManager.getIsPanelExpanded();
        } catch (Exception e)
        {
        }

        FREObject freObject = null;
        try
        {
            freObject = FREObject.newObject(expanded);
        } catch (FREWrongThreadException e)
        {
        }
        return freObject;
    }
}


class addFlexiView implements FREFunction
{
    public static final String TAG = addFlexiView.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {

        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            KidozAirBridgeExtension.mAdobeAirUiManager.addFlexiView(arg1[0].getAsBool(), arg1[1].getAsInt());
        } catch (Exception e)
        {
        }
        return null;
    }
}

class showFlexiView implements FREFunction
{
    public static final String TAG = showFlexiView.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {
        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            KidozAirBridgeExtension.mAdobeAirUiManager.showFlexiView();
        } catch (Exception e)
        {
        }
        return null;
    }
}

class hideFlexiView implements FREFunction
{
    public static final String TAG = hideFlexiView.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {

        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            KidozAirBridgeExtension.mAdobeAirUiManager.hideFlexiView();
        } catch (Exception e)
        {
        }
        return null;
    }
}

class getIsFlexiViewVisible implements FREFunction
{
    public static final String TAG = getIsFlexiViewVisible.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {
        boolean visible = false;
        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            visible = KidozAirBridgeExtension.mAdobeAirUiManager.getIsFlexiViewVisible();
        } catch (Exception e)
        {
        }

        FREObject freObject = null;
        try
        {
            freObject = FREObject.newObject(visible);
        } catch (FREWrongThreadException e)
        {
        }
        return freObject;
    }
}





class showInterstitial implements FREFunction
{
    public static final String TAG = showInterstitial.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {
        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            KidozAirBridgeExtension.mAdobeAirUiManager.showInterstitial();
        } catch (Exception e)
        {
        }
        return null;
    }
}

class loadInterstitial implements FREFunction
{
    public static final String TAG = showInterstitial.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {
        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            KidozAirBridgeExtension.mAdobeAirUiManager.loadInterstitialAd(arg1[0].getAsBool(),arg1[1].getAsInt());
        } catch (Exception e)
        {
        }
        return null;
    }
}

class isInterstitialLoaded implements FREFunction
{
    public static final String TAG = showInterstitial.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {
        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }
        } catch (Exception e)
        {
        }

        FREObject freObject = null;
        try
        {
            freObject = FREObject.newObject(KidozAirBridgeExtension.mAdobeAirUiManager.getIsInterstitialLoaded());
        } catch (FREWrongThreadException e)
        {
        }
        return freObject;
    }
}



class showVideoUnit implements FREFunction
{
    public static final String TAG = showVideoUnit.class.getSimpleName();

    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {
        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            KidozAirBridgeExtension.mAdobeAirUiManager.showVideoUnit();
        } catch (Exception e)
        {
        }
        return null;
    }
}


class printToastLog implements FREFunction
{
    @Override
    public FREObject call(FREContext context, FREObject[] arg1)
    {
        try
        {
            if (KidozAirBridgeExtension.mAdobeAirUiManager == null)
            {
                KidozAirBridgeExtension.mAdobeAirUiManager = new AdobeAirUiManager(context.getActivity());
            }

            KidozAirBridgeExtension.mAdobeAirUiManager.printToastLog(arg1[0].getAsString());
        } catch (Exception e)
        {
        }
        return null;
    }
}
