package com.kidoz.sdk.api.platforms;

import android.content.Context;

import com.kidoz.sdk.api.general.utils.ConstantDef;

public class AdobeAirUiManager extends BasePlatformsBridge
{
    // Panel Events
    public static String PANEL_VIEW_EVENT = "PANEL_VIEW_EVENT";
    public static String PANEL_VIEW_EVENT_EXPANDED = "PANEL_VIEW_EVENT_EXPANDED";
    public static String PANEL_VIEW_EVENT_COLLAPSED = "PANEL_VIEW_EVENT_COLLAPSED";
    public static String PANEL_VIEW_EVENT_PANEL_READY = "PANEL_VIEW_EVENT_PANEL_READY";

    // Feed view Events
    public static String FEED_VIEW_EVENT = "FEED_VIEW_EVENT";
    public static String FEED_VIEW_EVENT_READY_TOSHOW = "FEED_VIEW_EVENT_READY_TOSHOW";
    public static String FEED_VIEW_EVENT_DISMISS = "FEED_VIEW_EVENT_DISMISS";
    public static String FEED_VIEW_EVENT_OBJECT_READY = "FEED_VIEW_EVENT_OBJECT_READY";

    // Flexi view Events
    public static String FLEXI_VIEW_EVENT = "FLEXI_VIEW_EVENT";
    public static String FLEXI_VIEW_EVENT_READY = "FLEXI_VIEW_EVENT_READY";
    public static String FLEXI_VIEW_EVENT_VISIBLE = "FLEXI_VIEW_EVENT_VISIBLE";
    public static String FLEXI_VIEW_EVENT_HIDDEN = "FLEXI_VIEW_EVENT_HIDDEN";

    // General view Events
    public static String GENERAL_VIEW_EVENT = "GENERAL_VIEW_EVENT";
    public static String PLAYER_EVENT_OPEN = "PLAYER_EVENT_OPEN";
    public static String PLAYER_EVENT_CLOSE = "PLAYER_EVENT_CLOSE";

    // Interstitial view Events
    public static String INTERSTITIAL_VIEW_EVENT = "INTERSTITIAL_VIEW_EVENT";
    public static String INTERSTITIAL_EVENT_OPENED = "INTERSTITIAL_EVENT_OPENED";
    public static String INTERSTITIAL_EVENT_CLOSED = "INTERSTITIAL_EVENT_CLOSED";
    public static String INTERSTITIAL_EVENT_READY = "INTERSTITIAL_EVENT_READY";
    public static String INTERSTITIAL_EVENT_LOAD_FAILED = "INTERSTITIAL_EVENT_LOAD_FAILED";
    public static String INTERSTITIAL_EVENT_REWARDED = "INTERSTITIAL_EVENT_REWARDED";
    public static String INTERSTITIAL_EVENT_REWARDED_VIDEO_STARTED = "INTERSTITIAL_EVENT_REWARDED_VIDEO_STARTED";

    // Video Unit Events
    public static String VIDEO_UNIT_EVENT = "VIDEO_UNIT_EVENT";
    public static String VIDEO_UNIT_EVENT_OPEN = "VIDEO_UNIT_EVENT_OPEN";
    public static String VIDEO_UNIT_EVENT_CLOSE = "VIDEO_UNIT_EVENT_CLOSE";
    public static String VIDEO_UNIT_EVENT_READY = "VIDEO_UNIT_EVENT_READY";

    public AdobeAirUiManager(Context context)
    {
        super(context);
        ConstantDef.SDK_EXTENSION_TYPE = ConstantDef.EXTENSION_TYPE_ADOBE_AIR;
    }

    @Override
    public void onClbkFeedDismissView()
    {
        KidozAirBridgeExtension.sendEventToActionScript(FEED_VIEW_EVENT, FEED_VIEW_EVENT_DISMISS);
    }

    @Override
    public void onClbkFeedReadyToShow()
    {
        KidozAirBridgeExtension.sendEventToActionScript(FEED_VIEW_EVENT, FEED_VIEW_EVENT_READY_TOSHOW);
    }

    @Override
    public void onClbkFeedViewReady()
    {
        KidozAirBridgeExtension.sendEventToActionScript(FEED_VIEW_EVENT, FEED_VIEW_EVENT_OBJECT_READY);
    }

    @Override
    public void onClbkPanelViewCollapsed()
    {
        KidozAirBridgeExtension.sendEventToActionScript(PANEL_VIEW_EVENT, PANEL_VIEW_EVENT_COLLAPSED);
    }

    @Override
    public void onClbkPanelViewReady()
    {
        KidozAirBridgeExtension.sendEventToActionScript(PANEL_VIEW_EVENT, PANEL_VIEW_EVENT_PANEL_READY);
    }

    @Override
    public void onClbkPanelViewExpanded()
    {
        KidozAirBridgeExtension.sendEventToActionScript(PANEL_VIEW_EVENT, PANEL_VIEW_EVENT_EXPANDED);
    }

    @Override
    public void onClbkFlexiViewReady()
    {
        KidozAirBridgeExtension.sendEventToActionScript(FLEXI_VIEW_EVENT, FLEXI_VIEW_EVENT_READY);
    }

    @Override
    public void onClbkFlexiViewHidden()
    {
        KidozAirBridgeExtension.sendEventToActionScript(FLEXI_VIEW_EVENT, FLEXI_VIEW_EVENT_HIDDEN);
    }

    @Override
    public void onClbkFlexiViewVisible()
    {
        KidozAirBridgeExtension.sendEventToActionScript(FLEXI_VIEW_EVENT, FLEXI_VIEW_EVENT_VISIBLE);
    }

    @Override
    public void onClbkPlayerOpened()
    {
        KidozAirBridgeExtension.sendEventToActionScript(GENERAL_VIEW_EVENT, PLAYER_EVENT_OPEN);
    }

    @Override
    public void onClbkPlayerClosed()
    {
        KidozAirBridgeExtension.sendEventToActionScript(GENERAL_VIEW_EVENT, PLAYER_EVENT_CLOSE);
    }

    @Override
    public void onClbkInterstitialOpened()
    {
        KidozAirBridgeExtension.sendEventToActionScript(INTERSTITIAL_VIEW_EVENT, INTERSTITIAL_EVENT_OPENED);
    }

    @Override
    public void onClbkInterstitialClosed()
    {
        KidozAirBridgeExtension.sendEventToActionScript(INTERSTITIAL_VIEW_EVENT, INTERSTITIAL_EVENT_CLOSED);
    }

    @Override
    public void onClbkInterstitialReady()
    {
        KidozAirBridgeExtension.sendEventToActionScript(INTERSTITIAL_VIEW_EVENT, INTERSTITIAL_EVENT_READY);
    }

    @Override
    public void onClbkInterstitialLoadFailed()
    {
        KidozAirBridgeExtension.sendEventToActionScript(INTERSTITIAL_VIEW_EVENT, INTERSTITIAL_EVENT_LOAD_FAILED);
    }

    @Override
    public void onClbkRewarded()
    {
        KidozAirBridgeExtension.sendEventToActionScript(INTERSTITIAL_VIEW_EVENT, INTERSTITIAL_EVENT_REWARDED);
    }

    @Override
    public void onClbkRewardedVideoStarted()
    {
        KidozAirBridgeExtension.sendEventToActionScript(INTERSTITIAL_VIEW_EVENT, INTERSTITIAL_EVENT_REWARDED_VIDEO_STARTED);
    }

    @Override
    public void onClbkVideoUnitReady()
    {
        KidozAirBridgeExtension.sendEventToActionScript(VIDEO_UNIT_EVENT, VIDEO_UNIT_EVENT_READY);
    }

    @Override
    public void onClbkVideoUnitOpen()
    {
        KidozAirBridgeExtension.sendEventToActionScript(VIDEO_UNIT_EVENT, VIDEO_UNIT_EVENT_OPEN);
    }

    @Override
    public void onClbkVideoUnitClose()
    {
        KidozAirBridgeExtension.sendEventToActionScript(VIDEO_UNIT_EVENT, VIDEO_UNIT_EVENT_CLOSE);
    }
}
