package com.kidoz.sdk.api.interfaces;

import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.enums.WidgetType;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;



public class KidozPlayerEventHelper
{
    private WidgetType mWidgetType;
    private IPlayerListener iPlayerListener;

    public KidozPlayerEventHelper(IPlayerListener listener, WidgetType widgetType)
    {
        iPlayerListener = listener;
        mWidgetType = widgetType;
    }

    public void register()
    {
        if (EventBus.getDefault().isRegistered(this) == false)
        {
            EventBus.getDefault().register(this);
        }
    }

    public void unRegister()
    {
        if (EventBus.getDefault().isRegistered(this))
        {
            EventBus.getDefault().unregister(this);
        }
    }

    @Subscribe
    public void onHandleEvent(WidgetEventMessage event)
    {
        if (event != null && event.getWidgetType() == mWidgetType && iPlayerListener != null)
        {
            switch (event.getMessageType())
            {
                case PLAYER_OPEN:
                {
                    iPlayerListener.onOpen(true);
                    break;
                }
                case PLAYER_CLOSE:
                {
                    iPlayerListener.onClose(true);
                    break;
                }

                case MAXIMIZED_PLAYER_OPEN:
                {
                    iPlayerListener.onOpen(false);
                    break;
                }
                case MAXIMIZED_PLAYER_CLOSE:
                {
                    iPlayerListener.onClose(false);
                    break;
                }
            }
        }
    }

    public interface IPlayerListener
    {
        void onOpen(boolean isMaximizedPlayer);

        void onClose(boolean isMaximizedPlayer);
    }
}
