package com.kidoz.sdk.api;

import android.content.Context;

import com.kidoz.sdk.api.ui_views.interstitial.BaseInterstitial;
import com.kidoz.sdk.api.ui_views.interstitial.IntrstWrapper;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

/**
 * KIDOZ Interstitial
 */
public class KidozInterstitial extends BaseInterstitial
{
    public static final String TAG = KidozInterstitial.class.getSimpleName();
    public static final EventSignObj mEventObj = new EventSignObj();

    public enum AD_TYPE
    {
        INTERSTITIAL(0),
        REWARDED_VIDEO(1);

        private int value;

        AD_TYPE(int Value)
        {
            this.value = Value;
        }

        public int getValue()
        {
            return value;
        }
    }

    /**
     * Initiate kidoz interstitial
     */
    public KidozInterstitial(Context context)
    {
        initInnerWrapper(context);
        setRequestType();
        if (EventBus.getDefault().isRegistered(mEventObj) == false)
        {
            EventBus.getDefault().register(mEventObj);
        }
    }

    /**
     * Initiate inner wrapper html view
     */
    protected void initInnerWrapper(Context context) {
        mInterstitialView = IntrstWrapper.initInstance(context);
    }

    protected void setRequestType()
    {
        mInterstitialView.setIsLocalRequest(false);
    }

    /**
     * Show interstitial view
     */
    public synchronized void show()
    {
        if (mInterstitialView != null)
        {
            mInterstitialView.show();
        }
    }

    /**
     * Load interstitial ad view
     * @deprecated use  {@link #loadAd(AD_TYPE ad_type)} instead
     */
    @Deprecated
    public synchronized void loadAd()
    {
        mInterstitialView.setIsLocalRequest(false);
        if (mInterstitialView != null)
        {
            mInterstitialView.load(AD_TYPE.INTERSTITIAL);
        }
    }

    /**
     * Load ad view for specific type
     */
    public synchronized void loadAd(AD_TYPE ad_type)
    {
        mInterstitialView.setIsLocalRequest(false);
        if (mInterstitialView != null)
        {
            mInterstitialView.load(ad_type);
        }
    }


    /**
     * Get is interstitial ad is loaded
     */
    public boolean isLoaded()
    {
        if (mInterstitialView != null)
        {
            return mInterstitialView.isInterstitialLoaded();
        } else
        {
            return false;
        }
    }

    /**
     * Set interstitial  view events listener
     *
     * @param listener event listener
     */
    public void setOnInterstitialEventListener(IOnInterstitialEventListener listener)
    {
        mEventObj.setOnListener(listener);
    }

    /**
     * Set interstitial rewarded video events listener
     *
     * @param listener event listener
     */
    public void setOnInterstitialRewardedEventListener(IOnInterstitialRewardedEventListener listener)
    {
        mEventObj.setOnRewardedListener(listener);
    }

    private static final class EventSignObj
    {
        protected IOnInterstitialEventListener eventListener;
        protected IOnInterstitialRewardedEventListener eventRewardedListener;

        @Subscribe
        public void onHandleEvent(IntrstWrapper.InterstitialEvents event)
        {
            if (eventListener != null)
            {
                switch (event)
                {
                    case CLOSED:
                    {
                        eventListener.onClosed();
                        break;
                    }

                    case OPENED:
                    {
                        eventListener.onOpened();
                        break;
                    }

                    case READY:
                    {
                        eventListener.onReady();
                        break;
                    }

                    case LOAD_FAILED:
                    {
                        eventListener.onLoadFailed();
                        break;
                    }
                }
            }

            if (eventRewardedListener != null)
            {
                switch (event)
                {
                    case REWARDED:
                    {
                        eventRewardedListener.onRewarded();
                        break;
                    }

                    case REWARDED_VIDEO_STARTED:
                    {
                        eventRewardedListener.onRewardedVideoStarted();
                        break;
                    }
                }
            }
        }

        public void setOnListener(IOnInterstitialEventListener listener)
        {
            eventListener = listener;
        }

        public void setOnRewardedListener(IOnInterstitialRewardedEventListener listener)
        {
            eventRewardedListener = listener;
        }
    }
}


