/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.animation.Animator;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Point;
import android.support.v4.content.LocalBroadcastManager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.custom_drawables.VideoUnitDrawable;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;
import java.io.File;
import org.json.JSONObject;

public class KidozButton
extends RelativeLayout {
    public static final String TAG = KidozButton.class.getSimpleName();
    private final float BUTTON_SIZE_RATIO = 0.2f;
    private AssetView mAssetView;
    private KidozButtonListener mKidozButtonListener;
    private WidgetType mWidgetType;

    public KidozButton(Context context) {
        super(context);
        this.initView();
    }

    public KidozButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public KidozButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public void setKidozButtonListener(KidozButtonListener kidozButtonListener) {
        this.mKidozButtonListener = kidozButtonListener;
    }

    public void setWidgetType(WidgetType widgetType) {
        this.mWidgetType = widgetType;
        this.loadAssetView();
    }

    private void initView() {
        this.setVisibility(4);
        Point point = Utils.getScreenSize(this.getContext());
        int size = (int)((float)Math.min(point.x, point.y) * 0.2f);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);
        this.initRootView(params);
        this.initAssetView(params);
        this.loadAssetView();
    }

    private void initRootView(RelativeLayout.LayoutParams params) {
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(final View view) {
                view.setClickable(false);
                GenAnimator.clickItemAnimation((View)KidozButton.this, 70, new GenAnimator.ViewAnimationListener(){

                    @Override
                    public void onAnimationEnd() {
                        view.setClickable(true);
                        KidozButton.this.mKidozButtonListener.onClick();
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });
    }

    private void initAssetView(RelativeLayout.LayoutParams params) {
        this.mAssetView = new AssetView(this.getContext());
        this.mAssetView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.addView((View)this.mAssetView, (ViewGroup.LayoutParams)params);
    }

    private void loadAssetView() {
        this.setVisibility(4);
        File assetFile = null;
        if (this.mWidgetType != null) {
            switch (this.mWidgetType) {
                case WIDGET_TYPE_VIDEO_UNIT: {
                    JSONObject jsonObject = DatabaseManager.getInstance(this.getContext()).getConfigTable().loadProperties("VIDEO_UNIT_ACTION_BUTTON_TAG");
                    if (jsonObject == null) break;
                    try {
                        assetFile = AssetUtil.getAssetFile2(this.getContext(), jsonObject.getString("VIDEO_UNIT_ACTION_BUTTON_TAG"));
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
        }
        if (assetFile != null) {
            this.mAssetView.loadAsset(assetFile, new VideoUnitDrawable(), new AssetView.IOnAssetLoadedListener(){

                @Override
                public void onAssetLoaded(boolean successful) {
                    GenAnimator.playGrowAnimation((View)KidozButton.this, 350L, 0L, null, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                            KidozButton.this.setVisibility(0);
                            KidozButton.this.requestFocus();
                            KidozButton.this.bringToFront();
                        }

                        public void onAnimationEnd(Animator animation) {
                            KidozButton.this.requestFocus();
                            KidozButton.this.bringToFront();
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                }
            });
        } else {
            LocalBroadcastManager.getInstance((Context)this.getContext()).registerReceiver(new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    if (intent.getAction().equals(EventMessage.MessageType.VIDEO_UNIT_BUTTON_READY.name())) {
                        KidozButton.this.loadAssetView();
                        LocalBroadcastManager.getInstance((Context)KidozButton.this.getContext()).unregisterReceiver((BroadcastReceiver)this);
                    }
                }
            }, new IntentFilter(EventMessage.MessageType.VIDEO_UNIT_BUTTON_READY.name()));
        }
    }

    public static interface KidozButtonListener {
        public void onClick();
    }
}

