/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import android.content.Context;
import android.content.SharedPreferences;

public class SharedPreferencesUtils {
    private static final String SDK_SHARED_PREFERENCES_FILE_NAME = "SDK_SHARED_PREFERENCES_FILE_NAME";

    public static void saveSharedPreferencesData(Context context, String key, String value) {
        if (context != null) {
            SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, 0);
            if (key != null) {
                SharedPreferences.Editor editor = settings.edit();
                editor.putString(key, value);
                editor.apply();
            }
        }
    }

    public static String loadSharedPreferencesData(Context context, String key) {
        String result = null;
        if (context != null && key != null) {
            SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, 0);
            result = settings.getString(key, null);
        }
        return result;
    }

    public static void removeSharedPreferencesData(Context context, String key) {
        if (context != null && key != null) {
            SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, 0);
            SharedPreferences.Editor editor = settings.edit();
            editor.remove(key);
            editor.apply();
        }
    }

    public static void saveBooleanSharedPreferencesData(Context context, String key, boolean value) {
        if (context != null) {
            SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, 0);
            if (key != null) {
                SharedPreferences.Editor editor = settings.edit();
                editor.putBoolean(key, value);
                editor.apply();
            }
        }
    }

    public static boolean loadBooleanSharedPreferencesData(Context context, String key) {
        boolean result = false;
        if (context != null && key != null) {
            SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, 0);
            result = settings.getBoolean(key, false);
        }
        return result;
    }

    public static boolean hasBooleanSharedPreferencesData(Context context, String key) {
        boolean result = false;
        if (context != null && key != null) {
            SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, 0);
            result = settings.contains(key);
        }
        return result;
    }
}

