/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import org.json.JSONObject;

public class PropertiesObj {
    public static final String DEFAULT_YOUTUBE_HTML_URL = "http://cdn.kidoz.net/video_player/video_player_sdk.html";
    public static final String VIDEO_UNIT_DEFAULT_URL = "http://d28lrrc51wcjkk.cloudfront.net/video_unit/html/default/v1.0.0/mergedVideoUnit.html";
    private static final String CONFIG_VERSION_KEY = "configuration_version";
    private static final String SDK_STYLE_VERSION_KEY = "style";
    private static final String HTML_LOADER_DEFAULT_URL_KEY = "htmlLoaderDefaultURL";
    private static final String YOUTUBE_PLAYER_DEFAULT_HTML_KEY = "defaultHTMLPlayerURL";
    private static final String INTERSTITIAL_DEFAULT_URL_KEY = "interstitialHTMLURL";
    private static final String TIME_TO_WAIT_FOR_INSTALL_EVENT_MINUTES = "timeToWaitForInstallEvent";
    private static final String PANEL_VIEW_STYLE = "panelStyle";
    private static final String FEED_VIEW_STYLE = "feedStyle";
    private static final String FLEXI_VIEW_STYLE = "flexiStyle";
    private static final String INTERSTITIAL_VIEW_STYLE = "interstitialStyle";
    private static final String GLOBAL_STYLE = "globalStyle";
    private static final String FEED_API_DOMAIN = "feedApiDomain";
    private static final String VIDEO_UNIT_URL = "video_unit_url";
    JSONObject mProperties = new JSONObject();

    public PropertiesObj(JSONObject data) {
        this.mProperties = data;
    }

    public JSONObject getData() {
        return this.mProperties;
    }

    public int getSdkStyleVersion() {
        int result = -1;
        if (this.mProperties != null) {
            result = this.mProperties.optInt(SDK_STYLE_VERSION_KEY, 0);
        }
        return result;
    }

    public JSONObject getProperties() {
        return this.mProperties;
    }

    public String getHtmlLoaderDefaultLink() {
        String result = "";
        if (this.mProperties != null) {
            result = this.mProperties.optString(HTML_LOADER_DEFAULT_URL_KEY, "");
        }
        return result;
    }

    public String getDefaultYouTubePlayerHtmlLink() {
        String result = DEFAULT_YOUTUBE_HTML_URL;
        if (this.mProperties != null) {
            result = this.mProperties.optString(YOUTUBE_PLAYER_DEFAULT_HTML_KEY, result);
        }
        return result;
    }

    public String getInterstitialHtmlLink() {
        String result = "";
        if (this.mProperties != null) {
            result = this.mProperties.optString(INTERSTITIAL_DEFAULT_URL_KEY, result);
        }
        return result;
    }

    public String getVideoUnitURL() {
        String result = this.parseVideoUnitURL();
        return result;
    }

    public String getPanelViewStyle() {
        String result = null;
        if (this.mProperties != null) {
            result = this.mProperties.optString(PANEL_VIEW_STYLE, result);
        }
        return result;
    }

    public String getFeedViewStyle() {
        String result = null;
        if (this.mProperties != null) {
            result = this.mProperties.optString(FEED_VIEW_STYLE, result);
        }
        return result;
    }

    public String getFlexiViewStyle() {
        String result = null;
        if (this.mProperties != null) {
            result = this.mProperties.optString(FLEXI_VIEW_STYLE, result);
        }
        return result;
    }

    public String getGlobalParamsStyle() {
        String result = null;
        if (this.mProperties != null) {
            result = this.mProperties.optString(GLOBAL_STYLE, result);
        }
        return result;
    }

    public String getInterstitialViewStyle() {
        String result = null;
        if (this.mProperties != null) {
            result = this.mProperties.optString(INTERSTITIAL_VIEW_STYLE, result);
        }
        return result;
    }

    public String getFeedApiDomain() {
        String result = null;
        if (this.mProperties != null) {
            result = this.mProperties.optString(FEED_API_DOMAIN, result);
        }
        return result;
    }

    public String parseVideoUnitURL() {
        String result = VIDEO_UNIT_DEFAULT_URL;
        if (this.mProperties != null) {
            try {
                String vus = this.mProperties.optString("videoUnitStyle");
                JSONObject videoUnitStyle = new JSONObject(vus);
                String vu = videoUnitStyle.optString("videoUnit");
                JSONObject videoUnit = new JSONObject(vu);
                result = videoUnit.optString(VIDEO_UNIT_URL, result);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public int getMaxTimeToWaitForInstall() {
        int result = 86400000;
        if (this.mProperties != null) {
            result = this.mProperties.optInt(TIME_TO_WAIT_FOR_INSTALL_EVENT_MINUTES);
        }
        return result;
    }
}

