/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.animations;

import android.graphics.Camera;
import android.graphics.Matrix;
import android.view.animation.Animation;
import android.view.animation.Transformation;

public class FlipAnimation
extends Animation {
    public static final int ROTATION_X = 0;
    public static final int ROTATION_Y = 1;
    private final float mFromDegrees;
    private final float mToDegrees;
    private final float mCenterX;
    private final float mCenterY;
    private Camera mCamera;
    private int mDirection;
    private final ScaleUpDownEnum scaleType;
    public static final float SCALE_DEFAULT = 0.75f;
    private float scale;

    public FlipAnimation(float fromDegrees, float toDegrees, float centerX, float centerY, float scale, ScaleUpDownEnum scaleType) {
        this.mFromDegrees = fromDegrees;
        this.mToDegrees = toDegrees;
        this.mCenterX = centerX;
        this.mCenterY = centerY;
        this.scale = scale <= 0.0f || scale >= 1.0f ? 0.75f : scale;
        this.scaleType = scaleType == null ? ScaleUpDownEnum.SCALE_CYCLE : scaleType;
        this.mDirection = 1;
    }

    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        this.mCamera = new Camera();
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        float fromDegrees = this.mFromDegrees;
        float degrees = fromDegrees + (this.mToDegrees - fromDegrees) * interpolatedTime;
        float centerX = this.mCenterX;
        float centerY = this.mCenterY;
        Camera camera = this.mCamera;
        Matrix matrix = t.getMatrix();
        camera.save();
        if (this.mDirection == 0) {
            camera.rotateX(degrees);
        } else {
            camera.rotateY(degrees);
        }
        camera.getMatrix(matrix);
        camera.restore();
        matrix.preTranslate(-centerX, -centerY);
        matrix.postTranslate(centerX, centerY);
        matrix.preScale(this.scaleType.getScale(this.scale, interpolatedTime), this.scaleType.getScale(this.scale, interpolatedTime), centerX, centerY);
    }

    public void setDirection(int direction) {
        this.mDirection = direction;
    }

    public static enum ScaleUpDownEnum {
        SCALE_UP,
        SCALE_DOWN,
        SCALE_CYCLE,
        SCALE_NONE;


        public float getScale(float max, float iter) {
            switch (this) {
                case SCALE_UP: {
                    return max + (1.0f - max) * iter;
                }
                case SCALE_DOWN: {
                    return 1.0f - (1.0f - max) * iter;
                }
                case SCALE_CYCLE: {
                    boolean halfWay;
                    boolean bl = halfWay = (double)iter > 0.5;
                    if (halfWay) {
                        return max + (1.0f - max) * (iter - 0.5f) * 2.0f;
                    }
                    return 1.0f - (1.0f - max) * (iter * 2.0f);
                }
            }
            return 1.0f;
        }
    }
}

