/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.dialogs.WebDialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import java.util.Map;

public class VideoEnabledWebView
extends WebView {
    private final String TAG = VideoEnabledWebView.class.getSimpleName();
    private ConfigurationChangeListener mConfigurationChangeListener;
    private WebChromeClient videoEnabledWebChromeClient;
    private boolean addedJavascriptInterface;

    public VideoEnabledWebView(Context context) {
        super(context);
        this.init();
        this.addedJavascriptInterface = false;
    }

    public VideoEnabledWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
        this.addedJavascriptInterface = false;
    }

    public VideoEnabledWebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
        this.addedJavascriptInterface = false;
    }

    private void init() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.getSettings().setMixedContentMode(0);
        }
        this.videoEnabledWebChromeClient = new WebChromeClient();
        this.setWebChromeClient(this.videoEnabledWebChromeClient);
    }

    public void loadData(String data, String mimeType, String encoding) {
        this.addJavascriptInterface();
        super.loadData(data, mimeType, encoding);
    }

    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        this.addJavascriptInterface();
        super.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
    }

    public void loadUrl(String url) {
        this.addJavascriptInterface();
        super.loadUrl(url);
    }

    public void invokeJS(String url) {
        this.addJavascriptInterface();
        try {
            if (Build.VERSION.SDK_INT >= 19) {
                super.evaluateJavascript(url, null);
            } else {
                super.loadUrl(url);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadUrl(String url, Map<String, String> additionalHttpHeaders) {
        this.addJavascriptInterface();
        super.loadUrl(url, additionalHttpHeaders);
    }

    @SuppressLint(value={"JavascriptInterface"})
    private void addJavascriptInterface() {
        if (!this.addedJavascriptInterface) {
            this.addJavascriptInterface(new VideoJavaScriptInterface(), "_VideoEnabledWebView");
            this.addedJavascriptInterface = true;
        }
    }

    public void seekTo(int progress) {
        SDKLogger.printDebbugLog(this.TAG, ">>>>VIDEO TIME: Seek to (in seconds) = " + String.valueOf(progress / 1000));
        this.invokeJS("javascript:seek(\"" + progress / 1000 + "\")");
    }

    public void loadVideo(String videoDomain, String videoURL) {
        SDKLogger.printDebbugLog(this.TAG, ">>>>loadVideo: Domain = " + videoDomain + "\nURL = " + videoURL);
        this.invokeJS("javascript:initVideoPlayer(\"" + videoDomain + "\"," + "\"" + videoURL + "\")");
    }

    public void requestCurrentVideoTime() {
        this.invokeJS("javascript:requestCurrentVideoTime()");
    }

    public void pauseVideo() {
        this.invokeJS("javascript:pause()");
    }

    public void stopVideo() {
        this.invokeJS("javascript:stop()");
    }

    public void resumeVideo() {
        this.invokeJS("javascript:resume()");
    }

    public void refreshVideo() {
        this.invokeJS("javascript:refresh()");
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mConfigurationChangeListener != null) {
            this.mConfigurationChangeListener.onConfigChange();
        }
    }

    public void setOnConfigurationChangeListener(ConfigurationChangeListener configurationChangeListener) {
        this.mConfigurationChangeListener = configurationChangeListener;
    }

    public static interface ConfigurationChangeListener {
        public void onConfigChange();
    }

    class VideoJavaScriptInterface {
        VideoJavaScriptInterface() {
        }

        @JavascriptInterface
        public void notifyVideoEnd() {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (VideoEnabledWebView.this.videoEnabledWebChromeClient != null) {
                        VideoEnabledWebView.this.videoEnabledWebChromeClient.onHideCustomView();
                    }
                }
            });
        }
    }
}

