package com.kidoz.sdk.api.ui_views.custom_drawables;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.View;

import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;


public class ShadowView extends View
{
    private Paint mPaint;
    private RectF mRectF;
    private float mCornerRadius;
    private PANEL_TYPE mPanelType;
    private HANDLE_POSITION mHandePosition;

    public ShadowView(Context context)
    {
        super(context);
        initView();
    }

    private void initView()
    {
        int blurValue = Utils.dpTOpx(getContext(), 3);
        mPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mPaint.setStyle(Paint.Style.FILL);
        mPaint.setColor(Color.parseColor("#000000"));
        mPaint.setMaskFilter(new BlurMaskFilter(blurValue, BlurMaskFilter.Blur.NORMAL));

        mCornerRadius = Utils.dpTOpx(getContext(), 4);

        setLayerType(LAYER_TYPE_SOFTWARE, mPaint);
    }

    private void prepareView()
    {
        int horizontalSpacing =  Utils.dpTOpx(getContext(), 13);
        int verticalSpacing =  Utils.dpTOpx(getContext(), 11);

        mRectF = new RectF();

        switch (mPanelType)
        {
            case TOP:
            {
                switch (mHandePosition)
                {
                    case CENTER:
                    {
                        mRectF.set(horizontalSpacing, -verticalSpacing, getWidth() - horizontalSpacing, getHeight() - verticalSpacing);
                        break;
                    }
                    case END:
                    {
                        mRectF.set(horizontalSpacing, -verticalSpacing, getWidth() + horizontalSpacing, getHeight() - verticalSpacing);
                        break;
                    }
                    default:
                    {
                        mRectF.set(-horizontalSpacing, -verticalSpacing, getWidth() - horizontalSpacing, getHeight() - verticalSpacing);
                        break;
                    }
                }
                break;
            }
            default:
            {
                switch (mHandePosition)
                {
                    case CENTER:
                    {
                        mRectF.set(horizontalSpacing, verticalSpacing, getWidth() - horizontalSpacing, getHeight() + verticalSpacing);
                        break;
                    }
                    case END:
                    {
                        mRectF.set(horizontalSpacing, verticalSpacing, getWidth() + horizontalSpacing, getHeight() + verticalSpacing);
                        break;
                    }
                    default:
                    {
                        mRectF.set(-horizontalSpacing, verticalSpacing, getWidth() - horizontalSpacing, getHeight() + verticalSpacing);
                        break;
                    }
                }
                break;
            }
        }
        invalidate();
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh)
    {
        super.onSizeChanged(w, h, oldw, oldh);
        prepareView();
    }

    @Override
    protected void onDraw(Canvas canvas)
    {
        canvas.drawRoundRect(mRectF, mCornerRadius, mCornerRadius, mPaint);
    }

    public void setConfiguration(PANEL_TYPE panelType, HANDLE_POSITION handePosition)
    {
        mPanelType = panelType;
        mHandePosition = handePosition;
        prepareView();
        postInvalidate();
    }
}
