package com.kidoz.sdk.api.ui_views;

import android.animation.Animator;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Point;
import android.support.v4.content.LocalBroadcastManager;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.custom_drawables.VideoUnitDrawable;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;
import com.kidoz.sdk.api.ui_views.video_unit.VideoUnitActivity;

import org.json.JSONObject;

import java.io.File;

/**
 * Created by RonyBrosh on 10/30/2016.
 */

public class KidozButton extends RelativeLayout
{
    public static final String TAG = KidozButton.class.getSimpleName();
    private final float BUTTON_SIZE_RATIO = 0.20f;
    private AssetView mAssetView;
    private KidozButtonListener mKidozButtonListener;
    private WidgetType mWidgetType;

    public KidozButton(Context context)
    {
        super(context);
        initView();
    }

    public KidozButton(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        initView();
    }

    public KidozButton(Context context, AttributeSet attrs, int defStyleAttr)
    {
        super(context, attrs, defStyleAttr);
        initView();
    }

    public void setKidozButtonListener(KidozButtonListener kidozButtonListener)
    {
        mKidozButtonListener = kidozButtonListener;
    }

    public void setWidgetType(WidgetType widgetType)
    {
        mWidgetType = widgetType;
        loadAssetView();
    }

    private void initView()
    {
        setVisibility(View.INVISIBLE);

        Point point = Utils.getScreenSize(getContext());
        int size = (int) (Math.min(point.x, point.y) * BUTTON_SIZE_RATIO);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);

        // 1. Init View.
        initRootView(params);

        // 2. Init asset view.
        initAssetView(params);

        // 3. Load asset view.
        loadAssetView();
    }

    private void initRootView(RelativeLayout.LayoutParams params)
    {
        setLayoutParams(params);
        setOnClickListener(new OnClickListener()
        {
            @Override
            public void onClick(final View view)
            {
                view.setClickable(false);
                GenAnimator.clickItemAnimation(KidozButton.this, 70, new GenAnimator.ViewAnimationListener()
                {
                    @Override
                    public void onAnimationEnd()
                    {
                        view.setClickable(true);
                        mKidozButtonListener.onClick();
                    }

                    @Override
                    public void onAnimationStart()
                    {

                    }
                });
            }
        });
    }


    private void initAssetView(RelativeLayout.LayoutParams params)
    {
        mAssetView = new AssetView(getContext());
        mAssetView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        addView(mAssetView, params);
    }

    private void loadAssetView()
    {
        setVisibility(View.INVISIBLE);
        File assetFile = null;
        if (mWidgetType != null)
        {
            switch (mWidgetType)
            {
                case WIDGET_TYPE_VIDEO_UNIT:
                {
                    JSONObject jsonObject = DatabaseManager.getInstance(getContext()).getConfigTable().loadProperties(VideoUnitActivity.VIDEO_UNIT_ACTION_BUTTON_TAG);
                    if (jsonObject != null)
                    {
                        try
                        {
                            assetFile = AssetUtil.getAssetFile2(getContext(), jsonObject.getString(VideoUnitActivity.VIDEO_UNIT_ACTION_BUTTON_TAG));
                        }
                        catch (Exception ex)
                        {
                        }
                    }
                    break;
                }
            }
        }

        if(assetFile != null)
        {
            mAssetView.loadAsset(assetFile, new VideoUnitDrawable(), new AssetView.IOnAssetLoadedListener()
            {
                @Override
                public void onAssetLoaded(boolean successful)
                {
                    GenAnimator.playGrowAnimation(KidozButton.this, 350, 0, null, new Animator.AnimatorListener()
                    {
                        @Override
                        public void onAnimationStart(Animator animation)
                        {
                            setVisibility(View.VISIBLE);
                            requestFocus();
                            bringToFront();
                        }

                        @Override
                        public void onAnimationEnd(Animator animation)
                        {
                            requestFocus();
                            bringToFront();
                        }

                        @Override
                        public void onAnimationCancel(Animator animation)
                        {
                        }

                        @Override
                        public void onAnimationRepeat(Animator animation)
                        {
                        }
                    });
                }
            });
        }
        else
        {
            LocalBroadcastManager.getInstance(getContext()).registerReceiver(new BroadcastReceiver()
            {
                @Override
                public void onReceive(Context context, Intent intent)
                {
                    if(intent.getAction().equals(EventMessage.MessageType.VIDEO_UNIT_BUTTON_READY.name()) == true)
                    {
                        loadAssetView();
                        LocalBroadcastManager.getInstance(getContext()).unregisterReceiver(this);
                    }
                }
            },new IntentFilter(EventMessage.MessageType.VIDEO_UNIT_BUTTON_READY.name()));
        }
    }

    public interface KidozButtonListener
    {
        void onClick();
    }
}
