package com.kidoz.sdk.api.players.video_player;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.WebSettings;

import com.kidoz.sdk.api.dialogs.WebDialog.VideoEnabledWebView;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.PropertiesObj;

import java.io.File;


public class VideoManager
{
    private static VideoManager sVideoManager = null;
    private boolean sIsLoaded = false;
    private VideoEnabledWebView mIFrameVideo;
    private VideoJavaScriptInterface mVideoJavaScriptInterface;

    private String mHtmlVideoUrl;

    protected VideoManager()
    {
    }

    private void initIFrameVideo(Context context, String url)
    {
        mHtmlVideoUrl = url;

        mIFrameVideo = new VideoEnabledWebView(context);
        mIFrameVideo.setVerticalScrollBarEnabled(false);
        mIFrameVideo.setHorizontalScrollBarEnabled(false);
        if (Build.VERSION.SDK_INT < 18)
        {
            mIFrameVideo.getSettings().setAppCacheMaxSize(Long.MAX_VALUE);
        }
        if (Build.VERSION.SDK_INT > 16)
        {
            mIFrameVideo.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        if (Build.VERSION.SDK_INT >= 11)
        {
            mIFrameVideo.setLayerType(View.LAYER_TYPE_HARDWARE, null);
        }

        String state = Environment.getExternalStorageState();
        if (Environment.MEDIA_MOUNTED.equals(state))
        {
            File path = context.getCacheDir();
            if (path != null)
            {
                mIFrameVideo.getSettings().setAppCachePath(path.toString() + "/VideoCache");
            }
        }

        mIFrameVideo.getSettings().setPluginState(WebSettings.PluginState.ON);
        mIFrameVideo.getSettings().setCacheMode(WebSettings.LOAD_DEFAULT);
        mIFrameVideo.getSettings().setLoadWithOverviewMode(true);
        mIFrameVideo.getSettings().setJavaScriptEnabled(true);
        mIFrameVideo.getSettings().setUseWideViewPort(true);
        mIFrameVideo.getSettings().setAppCacheEnabled(true);
        mIFrameVideo.getSettings().setSupportZoom(false);

        mVideoJavaScriptInterface = new VideoJavaScriptInterface();
        mVideoJavaScriptInterface.setLocalReadyListener(new VideoJavaScriptInterface.IOnReadyLocalListener()
        {
            @Override
            public void onLocalReady()
            {
                sIsLoaded = true;
            }
        });

        mIFrameVideo.addJavascriptInterface(mVideoJavaScriptInterface, "VideoJavaScriptInterface");
        mIFrameVideo.loadUrl(url);
    }

    public boolean isLoaded()
    {
        return sIsLoaded;
    }

    public void reloadHtml()
    {
        mIFrameVideo.loadUrl(mHtmlVideoUrl);
    }

    public static VideoManager getInstance(Context context)
    {
        if (sVideoManager == null)
        {
            sVideoManager = new VideoManager();

            PropertiesObj appConfig = DatabaseManager.getInstance(context).getConfigTable().loadAppProperties();
            if (appConfig != null && appConfig.getDefaultYouTubePlayerHtmlLink() != null && !appConfig.getDefaultYouTubePlayerHtmlLink().equals(""))
            {
                sVideoManager.initIFrameVideo(context, appConfig.getDefaultYouTubePlayerHtmlLink());
            } else
            {
                sVideoManager.initIFrameVideo(context, PropertiesObj.DEFAULT_YOUTUBE_HTML_URL);
            }
        }

        return sVideoManager;
    }

    public VideoEnabledWebView getIFrameVideo()
    {
        if (mIFrameVideo != null)
        {
            ViewParent parent = mIFrameVideo.getParent();
            if (parent != null)
            {
                ((ViewGroup) parent).removeView(mIFrameVideo);
            }
        }
        return mIFrameVideo;
    }

    public VideoJavaScriptInterface getVideoJavaScriptInterface()
    {
        return mVideoJavaScriptInterface;
    }

    public interface IOnFinishLoadingListener
    {
        void onFinishLoading();
    }
}
