package com.kidoz.sdk.api.general.assets_handling;

import android.content.Context;

import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.HashMap;


public class StringAssetsUtils
{

    private static final String TAG = StringAssetsUtils.class.getSimpleName();

    public static final String PLD_TITLE_ACTIVATE = "parentalLockDialogTitleActivate";
    public static final String PLD_TITLE_DEACTIVATE = "parentalLockDialogTitleDeActivate";
    public static final String PLD_TITLE_FOR_GOOGLE_PLAY = "parentalLockDialogTitleForGooglePlay";

    public static final String PLD_TITLE_WRONG_SELECTION = "parentalLockDialogWrongSelection";
    public static final String PLD_TITLE_WRONG_SELECTION_TRY_AGAIN = "parentalLockDialogWrongSelectionTryAgain";

    public static final String PLD_TITLE_LOCK_ACTIVATED = "parentalLockDialogLockActivatedTitle";
    public static final String PLD_TITLE_LOCK_DEACTIVATED = "parentalLockDialogLockDeactivatedTitle";

    public static final String PLD_TITLE_LOCK_ACTIVATION_NEW = "parentalLockDialogMessageParentalLockActivationNew";
    public static final String PLD_TITLE_LOCK_DEACTIVATION_NEW  = "parentalLockDialogMessageParentalLockDeactivationNew";
    public static final String PLD_TITLE_GOOGLE_PLAY_GATE_NEW  = "parentalLockDialogMessageGooglePlayGateNew";

    private static HashMap<String, String> mLang;

    public static String getLangString(Context context, String key)
    {
        initStrings(context);
        String val = "";
        if (mLang.containsKey(key))
        {
            val = mLang.get(key);
        }
        return val;
    }

    private static void initStrings(Context context)
    {
        if (mLang == null || mLang.isEmpty())
        {
            mLang = new HashMap<    >();

            // Init strings.
            JSONObject stringsJSONObject = StringAssetsUtils.loadStringsFile(context);
            if (stringsJSONObject == null)
            {
                stringsJSONObject = new JSONObject();
            }


            mLang.put(PLD_TITLE_ACTIVATE, stringsJSONObject.optString(PLD_TITLE_ACTIVATE, "Activate\nParental Lock?"));
            mLang.put(PLD_TITLE_DEACTIVATE, stringsJSONObject.optString(PLD_TITLE_DEACTIVATE, "Deactivate\nParental Lock?"));
            mLang.put(PLD_TITLE_FOR_GOOGLE_PLAY, stringsJSONObject.optString(PLD_TITLE_FOR_GOOGLE_PLAY, "Parental Lock"));

            mLang.put(PLD_TITLE_WRONG_SELECTION, stringsJSONObject.optString(PLD_TITLE_WRONG_SELECTION, "Wrong selection..."));
            mLang.put(PLD_TITLE_WRONG_SELECTION_TRY_AGAIN, stringsJSONObject.optString(PLD_TITLE_WRONG_SELECTION_TRY_AGAIN, "TRY AGAIN"));

            mLang.put(PLD_TITLE_LOCK_ACTIVATED, stringsJSONObject.optString(PLD_TITLE_LOCK_ACTIVATED, "LOCK ACTIVATED"));
            mLang.put(PLD_TITLE_LOCK_DEACTIVATED, stringsJSONObject.optString(PLD_TITLE_LOCK_DEACTIVATED, "LOCK DEACTIVATED"));

            mLang.put(PLD_TITLE_LOCK_ACTIVATION_NEW, stringsJSONObject.optString(PLD_TITLE_LOCK_ACTIVATION_NEW, "To block external links solve the equation"));
            mLang.put(PLD_TITLE_LOCK_DEACTIVATION_NEW, stringsJSONObject.optString(PLD_TITLE_LOCK_DEACTIVATION_NEW, "To enable external links solve the equation"));
            mLang.put(PLD_TITLE_GOOGLE_PLAY_GATE_NEW, stringsJSONObject.optString(PLD_TITLE_GOOGLE_PLAY_GATE_NEW, "Solve the equation to access content"));
        }
    }

    public static boolean parseStrings(Context context, String dataResponse)
    {
        boolean result = false;
        if (dataResponse != null)
        {
            try
            {
                JSONObject rootObject = new JSONObject(dataResponse);
                JSONObject data = rootObject.optJSONObject("data");
                if (data != null)
                {
                    JSONObject strings = data.optJSONObject("strings");
                    if (strings != null)
                    {
                        saveStringsFile(context, strings);
                    }
                }
            } catch (Exception ex)
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to parse strings: " + ex.getMessage());
            }
        }
        return result;
    }

    public static JSONObject loadStringsFile(Context context)
    {
        JSONObject result = null;
        String configurationFileName = "StringsFile";
        StringBuilder stringBuffer = new StringBuilder();
        try
        {
            FileInputStream fileInputStream = context.openFileInput(configurationFileName);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String nextLine = bufferedReader.readLine();
            while (nextLine != null)
            {
                stringBuffer.append(nextLine);
                nextLine = bufferedReader.readLine();
            }
            inputStreamReader.close();
            result = new JSONObject(stringBuffer.toString());
        } catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to load strings file: " + ex.getMessage());
        }
        return result;
    }

    private static void saveStringsFile(Context context, JSONObject jSONObject)
    {
        String stringsFileName = "StringsFile";
        try
        {
            File dir = context.getFilesDir();
            File file = new File(dir, stringsFileName);
            if (file.exists() == true)
            {
                file.delete();
            }

            FileOutputStream fileOutputStream = context.openFileOutput(stringsFileName, Context.MODE_PRIVATE);
            fileOutputStream.write(jSONObject.toString().getBytes());
            fileOutputStream.close();
        } catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to create strings file: " + ex.getMessage());
        }
    }
}
