/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.Context;
import android.support.annotation.NonNull;
import java.lang.reflect.Method;
import pl.droidsonroids.gif.ReLinker;

public class LibraryLoader {
    static final String SURFACE_LIBRARY_NAME = "pl_droidsonroids_gif_surface";
    static final String BASE_LIBRARY_NAME = "pl_droidsonroids_gif";
    private static Context sAppContext;

    private LibraryLoader() {
    }

    public static void initialize(@NonNull Context context) {
        sAppContext = context.getApplicationContext();
    }

    private static Context getContext() {
        if (sAppContext == null) {
            try {
                Class<?> activityThread = Class.forName("android.app.ActivityThread");
                Method currentApplicationMethod = activityThread.getDeclaredMethod("currentApplication", new Class[0]);
                sAppContext = (Context)currentApplicationMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("LibraryLoader not initialized. Call LibraryLoader.initialize() before using library classes.", e);
            }
        }
        return sAppContext;
    }

    static void loadLibrary(Context context) {
        try {
            System.loadLibrary(BASE_LIBRARY_NAME);
        }
        catch (UnsatisfiedLinkError e) {
            if (context == null) {
                context = LibraryLoader.getContext();
            }
            ReLinker.loadLibrary(context);
        }
    }
}

