/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.one_item_view;

import android.animation.Animator;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.panel_view.OneContentItemView;
import java.util.ArrayList;
import org.json.JSONObject;

public class ItemViewPagerAdapter
extends PagerAdapter {
    private ArrayList<ContentItem> mContent = new ArrayList();
    private ViewPagerItemClickListener mViewPagerItemClickListener;
    private boolean mIsCanClick = true;
    protected int mWidth;
    protected int mHeight;
    private IOnItemInstaniateFinishListener mItemInstaniateListener;
    private boolean mFirstItemCreated = false;
    private JSONObject mProperties;

    public ItemViewPagerAdapter(JSONObject properties, int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.mProperties = properties;
    }

    public void setViewPagerItemClickListener(ViewPagerItemClickListener viewPagerItemClickListener) {
        this.mViewPagerItemClickListener = viewPagerItemClickListener;
    }

    public int getCount() {
        int result = 0;
        if (this.mContent != null && this.mContent.size() > 0) {
            result = this.mContent.size() == 1 ? 1 : 100;
        }
        return result;
    }

    public int getRealCount() {
        return this.mContent.size();
    }

    public void setContent(ArrayList<ContentItem> content) {
        this.mContent = content;
        this.notifyDataSetChanged();
    }

    public void clearContent() {
        this.mContent.clear();
        this.notifyDataSetChanged();
    }

    public Object instantiateItem(ViewGroup container, int position) {
        final int virtualPosition = position % this.mContent.size();
        final ContentItem contentItem = this.mContent.get(virtualPosition);
        OneContentItemView panelContentItem = new OneContentItemView(this.mProperties, container.getContext(), this.mWidth, this.mHeight);
        panelContentItem.setTag(virtualPosition);
        panelContentItem.applyViewSettingsByContentType(contentItem.getContentType());
        panelContentItem.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ItemViewPagerAdapter.this.mIsCanClick) {
                    ItemViewPagerAdapter.this.mIsCanClick = false;
                    SdkAnimationsUtils.animateClick(view, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                        }

                        public void onAnimationEnd(Animator animation) {
                            ItemViewPagerAdapter.this.mViewPagerItemClickListener.onClickEnd(contentItem, virtualPosition);
                            ItemViewPagerAdapter.this.mIsCanClick = true;
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    }, 50, 100);
                }
            }
        });
        if (contentItem != null) {
            panelContentItem.setData(contentItem);
        }
        container.addView((View)panelContentItem);
        if (position == 0 && !this.mFirstItemCreated && contentItem != null) {
            this.mFirstItemCreated = true;
            if (this.mItemInstaniateListener != null) {
                this.mItemInstaniateListener.onFirstItemReady();
            }
        }
        return panelContentItem;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)((OneContentItemView)((Object)object)));
    }

    public ContentItem getContentItem(int position) {
        ContentItem result = null;
        if (this.mContent != null && this.mContent.size() > position) {
            result = this.mContent.get(position);
        }
        return result;
    }

    public boolean isAdapterEmpty() {
        if (this.mContent == null) {
            return true;
        }
        return this.mContent.isEmpty();
    }

    public void setOnItemInstantiateFinishListener(IOnItemInstaniateFinishListener listener) {
        this.mItemInstaniateListener = listener;
    }

    public int getItemPosition(Object object) {
        return -2;
    }

    public static interface IOnItemInstaniateFinishListener {
        public void onFirstItemReady();
    }

    public static interface ViewPagerItemClickListener {
        public void onClickEnd(ContentItem var1, int var2);
    }
}

