/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.html_view;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.KidozTopBar;
import com.kidoz.sdk.api.ui_views.html_view.BaseInterstitialDialog;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import org.greenrobot.eventbus.EventBus;

public class MaximizedViewDialog
extends BaseInterstitialDialog {
    private static final int DEFAULT_TOP_BAR_COLOR = Color.parseColor((String)"#36a7ec");
    private static final int MAXIMIZED_VIEW_RESOURCE_ID = 3;
    private KidozTopBar mKidozTopBar;
    private boolean mFocusLost = false;

    public MaximizedViewDialog(Context context, String widgetType, String styleId, HtmlViewWrapper htmlViewWrapper) {
        super(context, widgetType, styleId, htmlViewWrapper);
        this.initTopBar();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mInnerContainer.setBackgroundColor(Color.parseColor((String)"#77000000"));
    }

    private void initTopBar() {
        this.mKidozTopBar = new KidozTopBar(this.getContext(), true, this.mWidgetType, null);
        this.mKidozTopBar.setId(Utils.generateViewId());
        this.mKidozTopBar.setTopBarBackgroundColor(DEFAULT_TOP_BAR_COLOR);
        this.mKidozTopBar.showParentalLockIcon(false);
        this.mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener(){

            @Override
            public void onExitClicked(View view) {
                MaximizedViewDialog.this.closeDialog();
            }
        });
        this.mInnerContainer.addView((View)this.mKidozTopBar, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mWebView.getLayoutParams();
        params.addRule(3, this.mKidozTopBar.getId());
        params.setMargins(0, -Utils.dpTOpx(this.getContext(), 7.0f), 0, 0);
    }

    @Override
    public void openDialog() {
        this.mWebView.setAlpha(0.01f);
        super.openDialog();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                MaximizedViewDialog.this.mWebView.setAlpha(1.0f);
            }
        }, 500L);
        WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.MAXIMIZED_PLAYER_OPEN, WidgetType.createFromString(this.mWidgetType));
        EventBus.getDefault().post((Object)eventMessage);
        EventManager.getInstance(this.getContext()).logEvent(this.getContext(), this.mWidgetType, this.mStyleID, EventManager.LOG_CRITICAL_LEVEL, "Maximized View", "Open Dialog", "Web");
        if (this.mContentItem != null) {
            EventManager.getInstance(this.getContext()).logEventWithDurationStart(this.mWidgetType, this.mStyleID, EventManager.LOG_NORMAL_LEVEL, 3, "Maximized View", "View Duration", this.mContentItem.getName(), this.mContentItem.getId());
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventMessage eventMsg = new EventMessage(EventMessage.MessageType.HTML_FULL_VIEW_CLOSE);
        eventMsg.setAdditionalParam(this.mWidgetType);
        EventBus.getDefault().post((Object)eventMsg);
        WidgetEventMessage widgetEventMessage = new WidgetEventMessage(EventMessage.MessageType.MAXIMIZED_PLAYER_CLOSE, WidgetType.createFromString(this.mWidgetType));
        EventBus.getDefault().post((Object)widgetEventMessage);
        EventManager.getInstance(this.getContext()).logEvent(this.getContext(), this.mWidgetType, null, EventManager.LOG_CRITICAL_LEVEL, "Maximized View", "Close Dialog", "Web");
        EventManager.getInstance(this.getContext()).logEventWithDurationEnd(this.getContext(), this.mWidgetType, this.mStyleID, 3);
    }

    public void loadHtmlView(ContentItem contentItem) {
        this.mContentItem = contentItem;
        if (this.mContentItem.getIsUseNativeTopBar()) {
            this.mKidozTopBar.setVisibility(0);
            this.mKidozTopBar.setTitle(this.mContentItem.getName());
        } else {
            this.mKidozTopBar.setVisibility(8);
        }
        this.mWebView.setData(this.mContentItem);
        if (contentItem.getIsNonDefaultHtml()) {
            this.mWebView.loadHtml();
        } else {
            this.mWebView.requestMaximize();
        }
    }

    public HtmlViewWrapper getInnerWebView() {
        return this.mWebView;
    }

    @Override
    protected void onDialogFocusChange(boolean isVisible) {
        super.onDialogFocusChange(isVisible);
        if (!isVisible) {
            this.mFocusLost = true;
            if (this.mWebView != null) {
                this.mWebView.requestFocusOff();
            }
        }
    }

    @Override
    protected void onDialogWindowVisibilityChange(boolean visible) {
        super.onDialogWindowVisibilityChange(visible);
        if (visible && this.mFocusLost) {
            this.mFocusLost = false;
            if (this.mWebView != null) {
                this.mWebView.requestFocusOn(true);
            }
        }
    }
}

