/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.html_view;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Build;
import android.util.AttributeSet;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import org.json.JSONObject;

public class HtmlFiveWebView
extends WebView {
    public HtmlFiveWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getSettings().setMixedContentMode(0);
        }
    }

    public HtmlFiveWebView(Context context) {
        super(context);
        try {
            this.initWebView(context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.getSettings().setMixedContentMode(0);
        }
    }

    public HtmlFiveWebView(Context context, boolean flag) {
        super(context);
        this.initWorkingSettingsForVideoInWebView();
    }

    private void initWorkingSettingsForVideoInWebView() {
        this.getSettings().setJavaScriptEnabled(true);
        CookieManager.getInstance().setAcceptCookie(true);
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager.getInstance().setAcceptThirdPartyCookies((WebView)this, true);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.getSettings().setMixedContentMode(0);
        }
        this.setDrawingCacheBackgroundColor(0);
        this.setBackgroundColor(Color.argb((int)1, (int)0, (int)0, (int)0));
        this.setFocusableInTouchMode(true);
        this.setFocusable(true);
        if (Build.VERSION.SDK_INT < 23) {
            this.setAnimationCacheEnabled(true);
        }
        if (Build.VERSION.SDK_INT < 19) {
            this.getSettings().setDatabasePath(this.getContext().getCacheDir() + "/databases");
        }
        this.getSettings().setAppCacheEnabled(true);
        this.getSettings().setDatabaseEnabled(true);
        if (Build.VERSION.SDK_INT < 18) {
            this.getSettings().setAppCacheMaxSize(Long.MAX_VALUE);
        }
        if (Build.VERSION.SDK_INT < 17) {
            this.getSettings().setEnableSmoothTransition(true);
        }
        if (Build.VERSION.SDK_INT < 18) {
            this.getSettings().setRenderPriority(WebSettings.RenderPriority.HIGH);
        }
        this.getSettings().setBuiltInZoomControls(false);
        this.getSettings().setDisplayZoomControls(false);
        this.getSettings().setGeolocationDatabasePath(this.getContext().getFilesDir().toString());
        this.getSettings().setAppCachePath(this.getContext().getCacheDir().toString());
        this.getSettings().setAllowContentAccess(false);
        this.getSettings().setDefaultTextEncodingName("utf-8");
        this.getSettings().setUserAgentString("Mozilla/5.0 (Linux; Android 5.1; Nexus 4 Build/KRT16H) AppleWebKit/537.36(KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36");
        this.getSettings().setGeolocationEnabled(true);
        this.getSettings().setSupportMultipleWindows(false);
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        this.getSettings().setBlockNetworkImage(false);
        if (Build.VERSION.SDK_INT < 18) {
            this.getSettings().setSavePassword(false);
            this.getSettings().setPluginState(WebSettings.PluginState.ON);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            this.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setAllowFileAccess(true);
        this.getSettings().setSupportZoom(false);
        if (Build.VERSION.SDK_INT >= 16) {
            this.getSettings().setAllowFileAccessFromFileURLs(true);
            this.getSettings().setAllowUniversalAccessFromFileURLs(true);
        }
        this.getSettings().setSaveFormData(false);
        this.getSettings().setLoadWithOverviewMode(false);
        this.getSettings().setUseWideViewPort(false);
        this.getSettings().setCacheMode(2);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setLayerType(2, null);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.getSettings().setMixedContentMode(0);
        }
        this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        if (Build.VERSION.SDK_INT >= 19) {
            HtmlFiveWebView.setWebContentsDebuggingEnabled((boolean)ConstantDef.DGM);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            this.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
    }

    private void initWebView(Context context) {
        if (Build.VERSION.SDK_INT >= 19) {
            HtmlFiveWebView.setWebContentsDebuggingEnabled((boolean)ConstantDef.DGM);
        }
        this.setDrawingCacheBackgroundColor(0);
        this.setBackgroundColor(Color.argb((int)1, (int)0, (int)0, (int)0));
        this.setFocusableInTouchMode(true);
        this.setFocusable(true);
        if (Build.VERSION.SDK_INT < 23) {
            this.setAnimationCacheEnabled(true);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(null);
            this.getRootView().setBackground(null);
        } else {
            this.getRootView().setBackgroundDrawable(null);
        }
        if (Build.VERSION.SDK_INT < 19) {
            String databasePath = context.getDir("database", 0).getPath();
            this.getSettings().setDatabasePath(databasePath);
        }
        this.getSettings().setAppCacheEnabled(true);
        this.getSettings().setDatabaseEnabled(true);
        if (Build.VERSION.SDK_INT < 18) {
            this.getSettings().setAppCacheMaxSize(Long.MAX_VALUE);
        }
        if (Build.VERSION.SDK_INT < 17) {
            this.getSettings().setEnableSmoothTransition(true);
        }
        if (Build.VERSION.SDK_INT < 18) {
            this.getSettings().setRenderPriority(WebSettings.RenderPriority.HIGH);
        }
        this.getSettings().setBuiltInZoomControls(false);
        this.getSettings().setDisplayZoomControls(false);
        this.getSettings().setGeolocationDatabasePath(context.getFilesDir().toString());
        this.getSettings().setAppCachePath(context.getCacheDir().toString());
        this.getSettings().setAllowContentAccess(false);
        this.getSettings().setDefaultTextEncodingName("utf-8");
        this.getSettings().setUserAgentString("Mozilla/5.0 (Linux; Android 5.1; Nexus 4 Build/KRT16H) AppleWebKit/537.36(KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36");
        this.getSettings().setGeolocationEnabled(true);
        this.getSettings().setSupportMultipleWindows(false);
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        this.getSettings().setBlockNetworkImage(false);
        SharedPreferences mPreferences = context.getSharedPreferences("settings", 0);
        if (Build.VERSION.SDK_INT < 18) {
            switch (mPreferences.getInt("enableflash", 0)) {
                case 0: {
                    this.getSettings().setPluginState(WebSettings.PluginState.OFF);
                    break;
                }
                case 1: {
                    this.getSettings().setPluginState(WebSettings.PluginState.ON_DEMAND);
                    break;
                }
                case 2: {
                    this.getSettings().setPluginState(WebSettings.PluginState.ON);
                    break;
                }
            }
        }
        if (Build.VERSION.SDK_INT < 18) {
            this.getSettings().setSavePassword(false);
        }
        this.applyProperties(new JSONObject());
        if (Build.VERSION.SDK_INT >= 17) {
            this.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setAllowFileAccess(true);
        this.getSettings().setSupportZoom(false);
        if (Build.VERSION.SDK_INT >= 16) {
            this.getSettings().setAllowFileAccessFromFileURLs(true);
            this.getSettings().setAllowUniversalAccessFromFileURLs(true);
        }
        this.getSettings().setSaveFormData(false);
        this.getSettings().setLoadWithOverviewMode(false);
        this.getSettings().setUseWideViewPort(false);
        this.getSettings().setCacheMode(2);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setLayerType(2, null);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.getSettings().setMixedContentMode(0);
        }
        if (mPreferences.getBoolean("textreflow", false)) {
            this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        } else if (Build.VERSION.SDK_INT >= 19) {
            try {
                this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.TEXT_AUTOSIZING);
            }
            catch (IllegalArgumentException e) {
                this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
            }
        } else {
            this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        }
    }

    public synchronized void stopAndReleaseWebView() {
        this.loadUrl("");
        this.stopLoading();
        this.clearHistory();
        this.removeAllViews();
        this.destroyDrawingCache();
    }

    public void applyProperties(JSONObject properties) {
        if (properties != null) {
            if (Build.VERSION.SDK_INT >= 17) {
                this.getSettings().setMediaPlaybackRequiresUserGesture(properties.optBoolean("setMediaPlaybackRequiersGesture", false));
            }
            this.getSettings().setDomStorageEnabled(properties.optBoolean("setDomStorageEnabled", true));
            this.getSettings().setAllowFileAccess(properties.optBoolean("setAllowFileAccess", true));
            this.getSettings().setSupportZoom(properties.optBoolean("setZoomSupport", false));
            if (Build.VERSION.SDK_INT >= 16) {
                this.getSettings().setAllowFileAccessFromFileURLs(properties.optBoolean("setAllowFileAccessFromFileUrls", true));
                this.getSettings().setAllowUniversalAccessFromFileURLs(properties.optBoolean("setAllowUniversalAccessFromFileURLs", true));
                if (properties.optBoolean("setHardwareAcceleration", true)) {
                    this.setLayerType(2, null);
                } else {
                    this.setLayerType(1, null);
                }
            }
            this.getSettings().setSaveFormData(properties.optBoolean("setSaveFormData", false));
            this.getSettings().setLoadWithOverviewMode(properties.optBoolean("setLoadWithOverviewMode", false));
            this.getSettings().setUseWideViewPort(properties.optBoolean("setUseWideViewPort", false));
            this.getSettings().setCacheMode(properties.optInt("setCacheMode", 2));
            if (properties.has("setBackgroundColor")) {
                try {
                    this.setBackgroundColor(Color.argb((int)1, (int)0, (int)0, (int)0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.setBackgroundColor(Color.argb((int)1, (int)0, (int)0, (int)0));
    }
}

