/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.server_connect;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

@SuppressLint(value={"NewApi"})
public class BaseConnectionClient {
    protected static String mPublicherId = null;
    protected static String mSecurityToken = null;
    protected static String MAIN_SERVER_URL = "http://sdk.kidoz.net/api/sdk";
    protected static String KIDOZ_ANALITYCS_SERVER_URL = "http://analytics.kidoz.net/parents/KidozRestMobile.php";
    protected static String SDK_API_URL = "http://sdk-api.kidoz.net/api/";
    protected static final String TAG = BaseConnectionClient.class.getSimpleName();
    private static OkHttpClient client;
    private static final MediaType JSON;

    public static int getConnectionType(Context context) {
        ConnectivityManager connManager;
        NetworkInfo nInfo;
        int reuslt = 1;
        if (context != null && (nInfo = (connManager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && nInfo.isAvailable()) {
            reuslt = nInfo.getType();
        }
        return reuslt;
    }

    protected static void initConnectionClient() {
        BaseConnectionClient.getOkHttpClient();
        BaseConnectionClient.initCookieManager();
    }

    public static synchronized OkHttpClient getOkHttpClient() {
        if (client == null) {
            client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).build();
        }
        return client;
    }

    private static void initCookieManager() {
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(cookieManager);
    }

    public static Call makePostConnection(String url, ContentValues contentValues, String requestTag) throws IOException {
        Call result = null;
        if (contentValues != null && contentValues.size() > 0) {
            String val;
            StringBuilder stringBuilder = new StringBuilder();
            Set set = contentValues.keySet();
            Iterator iter = set.iterator();
            if (iter.hasNext()) {
                val = (String)iter.next();
                stringBuilder.append(val).append("=").append(contentValues.getAsString(val));
            }
            while (iter.hasNext()) {
                val = (String)iter.next();
                stringBuilder.append("&");
                stringBuilder.append(val).append("=").append(contentValues.getAsString(val));
            }
            if (url != null && !url.equals("")) {
                RequestBody body = RequestBody.create((MediaType)JSON, (String)stringBuilder.toString());
                Request request = new Request.Builder().url(url).post(body).tag((Object)requestTag).build();
                result = client.newCall(request);
            } else {
                SDKLogger.printErrorLog(" \n Invalid Server Url or Request parameters JSON !");
            }
        }
        return result;
    }

    public static Call makeGetConnection(String url, ContentValues contentValues, String requestTag) throws IOException {
        StringBuilder sb = new StringBuilder(url);
        if (contentValues != null && contentValues.size() > 0) {
            String val;
            sb.append("?");
            Set set = contentValues.keySet();
            Iterator iter = set.iterator();
            if (iter.hasNext()) {
                val = (String)iter.next();
                sb.append(val).append("=").append(Uri.encode((String)contentValues.getAsString(val)));
            }
            while (iter.hasNext()) {
                val = (String)iter.next();
                sb.append("&");
                sb.append(val).append("=").append(Uri.encode((String)contentValues.getAsString(val)));
            }
        }
        Request request = new Request.Builder().url(sb.toString()).header("Access-Key", mPublicherId + "::" + mSecurityToken).tag((Object)requestTag).build();
        Call call = client.newCall(request);
        return call;
    }

    private static void cancelRequest(Call call) {
        call.cancel();
    }

    public static void getImageStreamAsync(String url, String requestTag, final IOnImageRequestCallback requestCallback) {
        Request request = new Request.Builder().url(url).tag((Object)requestTag).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
            }

            public void onResponse(Call call, Response response) throws IOException {
                requestCallback.onImageRecieved(response.body().byteStream());
            }
        });
    }

    public static Call getImageStream(String url, String requestTag) throws IOException {
        Request request = new Request.Builder().url(url).tag((Object)requestTag).build();
        return client.newCall(request);
    }

    public static boolean downloadAndSaveFile(String fileURL, File destinationFile) {
        boolean result = false;
        try {
            int len;
            SDKLogger.printDebbugLog(TAG, "Downloading file url: " + fileURL);
            Request request = new Request.Builder().url(fileURL).build();
            Response response = client.newCall(request).execute();
            InputStream inputStream = response.body().byteStream();
            FileOutputStream outputStream = new FileOutputStream(destinationFile);
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                ((OutputStream)outputStream).write(buf, 0, len);
            }
            ((OutputStream)outputStream).close();
            inputStream.close();
            result = true;
        }
        catch (Exception ex) {
            SDKLogger.printDebbugLog(TAG, "Error when trying download file: " + ex.getMessage());
        }
        return result;
    }

    static {
        JSON = MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8");
    }

    public static interface IOnImageRequestCallback {
        public void onImageRecieved(InputStream var1) throws IOException;
    }

    protected static enum CONNECTION_TYPE {
        POST,
        GET;

    }
}

