/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.web_player;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.support.v4.content.LocalBroadcastManager;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.RelativeLayout;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.web_player.WebPlayerType;
import com.kidoz.sdk.api.players.web_player.WebPlayerView;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.KidozTopBar;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;
import java.io.Serializable;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONArray;

public class WebPlayerDialog
extends BaseDialog {
    private static final int DEFAULT_TOP_BAR_COLOR = Color.parseColor((String)"#36a7ec");
    private static final String TAG = WebPlayerDialog.class.getSimpleName();
    private static final int WEB_PLAYER_RESOURCE_ID = 1;
    private static final String CONTENT_ITEM_SAVE_STATE_KEY = "CONTENT_ITEM_SAVE_STATE_KEY_WP";
    private static final String WEB_PLAYER_TYPE_SAVE_STATE_KEY = "WEB_PLAYER_TYPE_SAVE_STATE_KEY_WP";
    private RelativeLayout mInnerContainer;
    private ContentItem mContentItem;
    private WebPlayerType mWebPlayerType;
    private KidozTopBar mKidozTopBar;
    private WebPlayerView mWebPlayerView;
    private HtmlViewWrapper mHtmlViewWrapper;
    private String mLabel;
    private String mWidgetType = null;
    private String mStyleId = null;
    private Utils.StaticHandler staticHandler = new Utils.StaticHandler(Looper.getMainLooper());
    private BroadcastReceiver mBroadcastReceiver;

    public WebPlayerDialog(Context context, ContentItem contentItem, String widgetType, String styleId, WebPlayerType webPlayerType, boolean allowOrientationModification) {
        super(context, 0x1030011, allowOrientationModification);
        if (webPlayerType != null && webPlayerType == WebPlayerType.EXTERNAL_LINK) {
            this.setCancelable(false);
        } else {
            this.setCancelable(true);
        }
        this.mContentItem = contentItem;
        this.mWebPlayerType = webPlayerType;
        this.mWidgetType = widgetType;
        this.mStyleId = styleId;
        this.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                boolean result = false;
                if (WebPlayerDialog.this.mWebPlayerType != null && WebPlayerDialog.this.mWebPlayerType == WebPlayerType.ROVIO && keyCode == 4 && WebPlayerDialog.this.mWebPlayerView.getKidozWebView().canGoBack()) {
                    try {
                        WebPlayerDialog.this.mWebPlayerView.getKidozWebView().goBack();
                        result = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return result;
            }
        });
    }

    public void setAutoCloseTimer() {
        this.mBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent != null && intent.getAction().equals("CloseRedirectWebsiteDialog")) {
                    LocalBroadcastManager.getInstance((Context)WebPlayerDialog.this.getContext()).unregisterReceiver(WebPlayerDialog.this.mBroadcastReceiver);
                    WebPlayerDialog.this.closeDialog();
                }
            }
        };
        LocalBroadcastManager.getInstance((Context)this.getContext()).registerReceiver(this.mBroadcastReceiver, new IntentFilter("CloseRedirectWebsiteDialog"));
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            if (savedInstanceState.containsKey(CONTENT_ITEM_SAVE_STATE_KEY)) {
                this.mContentItem = (ContentItem)((Object)savedInstanceState.getSerializable(CONTENT_ITEM_SAVE_STATE_KEY));
            }
            this.mWebPlayerType = (WebPlayerType)((Object)savedInstanceState.getSerializable(WEB_PLAYER_TYPE_SAVE_STATE_KEY));
        }
        this.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
            }
        });
        try {
            this.initDialogView();
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error initDialog: " + ex.getMessage());
        }
    }

    private void initDialogView() {
        this.mInnerContainer = new RelativeLayout(this.getContext());
        this.setContentView((View)this.mInnerContainer, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        if (this.mWebPlayerType == WebPlayerType.HTML_PLAYBACK) {
            this.addHtmlPlaybackView();
        } else {
            this.addWebPlayerView();
        }
        this.initTopBar();
        RelativeLayout videoLayout = new RelativeLayout(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        videoLayout.setId(Utils.generateViewId());
        this.mInnerContainer.addView((View)videoLayout, (ViewGroup.LayoutParams)params);
        if (this.mWebPlayerView != null) {
            this.mWebPlayerView.setFullScreenWebChromeClient((ViewGroup)videoLayout);
        }
        if (this.mWebPlayerType != null && this.mWebPlayerType == WebPlayerType.EXTERNAL_LINK) {
            this.mInnerContainer.setBackgroundColor(Color.parseColor((String)"#77000000"));
            this.mKidozTopBar.setVisibility(4);
        } else {
            this.mInnerContainer.setBackgroundColor(-1);
        }
        if (this.mContentItem.getName() != null) {
            this.mKidozTopBar.setTitle(this.mContentItem.getName());
        } else {
            this.mKidozTopBar.setTitle("");
        }
        if (this.mWebPlayerType != null && this.mWebPlayerType == WebPlayerType.ROVIO) {
            CookieManager.getInstance().setAcceptCookie(true);
            if (this.mWebPlayerView != null && Build.VERSION.SDK_INT >= 21) {
                CookieManager.getInstance().setAcceptThirdPartyCookies((WebView)this.mWebPlayerView.getKidozWebView(), true);
            }
        }
        if (this.mWebPlayerType != null && this.mWebPlayerType == WebPlayerType.ROVIO || !this.mContentItem.getIsUseNativeTopBar()) {
            this.mKidozTopBar.setVisibility(8);
        }
    }

    private void addHtmlPlaybackView() {
        this.mHtmlViewWrapper = new HtmlViewWrapper((Context)this.mCallingActivity, false);
        this.mHtmlViewWrapper.setInFocusActivityContext((Context)this.mCallingActivity);
        this.mHtmlViewWrapper.setHtmlWebViewListener(new IOnHtmlWebViewInterface(){

            @Override
            public void onHtmlStartLoading() {
                super.onHtmlStartLoading();
                WebPlayerDialog.this.mHtmlViewWrapper.showLoadingProgressView();
            }

            @Override
            public void onHtmlFinishedLoading() {
                super.onHtmlFinishedLoading();
                WebPlayerDialog.this.mHtmlViewWrapper.hideLoadingProgressView();
            }

            @Override
            public void onClose() {
                super.onClose();
                WebPlayerDialog.this.closeDialog();
            }
        });
        this.mHtmlViewWrapper.setData(this.mContentItem);
        this.mHtmlViewWrapper.loadHtml();
        if (!this.mContentItem.getIsUseNativeTopBar()) {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            Point point = Utils.getScreenSize(this.getContext());
            params.topMargin = (int)((float)Math.max(point.x, point.y) * 0.061458334f);
            this.mInnerContainer.addView((View)this.mHtmlViewWrapper, (ViewGroup.LayoutParams)params);
        }
    }

    private void addWebPlayerView() {
        this.mWebPlayerView = new WebPlayerView(this.getWindow(), (Context)this.mCallingActivity, this.mWebPlayerType, this.mContentItem.getIsUseNativeTopBar());
        this.mWebPlayerView.getKidozWebView().addJavascriptInterface(new WebPlayerJavaInterface(), "KidozAndroid");
        if (this.mContentItem != null) {
            String[] allowedDomains = null;
            try {
                JSONArray jsonArray;
                if (this.mContentItem.getExtraParameters() != null && (jsonArray = this.mContentItem.getExtraParameters().optJSONArray("allowed_domains")) != null) {
                    allowedDomains = new String[jsonArray.length()];
                    for (int keyIndex = 0; keyIndex < jsonArray.length(); ++keyIndex) {
                        allowedDomains[keyIndex] = jsonArray.getString(keyIndex);
                    }
                }
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to gnerate website's allowed domains: " + ex.getMessage());
            }
            this.mWebPlayerView.loadWebUrlWithAllowedDomains(allowedDomains, this.mContentItem.getData(), this.mContentItem.getId());
        }
        this.mWebPlayerView.setOnRemoveViewRequestListener(new WebPlayerView.IOnRemoveViewRequestListener(){

            @Override
            public void onRemoveView() {
                WebPlayerDialog.this.closeDialog();
            }
        });
        this.mInnerContainer.addView((View)this.mWebPlayerView);
    }

    private void initTopBar() {
        this.mKidozTopBar = new KidozTopBar(this.getContext(), true, this.mWidgetType, null);
        this.mKidozTopBar.setId(Utils.generateViewId());
        this.mKidozTopBar.setTopBarBackgroundColor(DEFAULT_TOP_BAR_COLOR);
        this.mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener(){

            @Override
            public void onExitClicked(View view) {
                WebPlayerDialog.this.closeDialog();
            }
        });
        this.mKidozTopBar.showParentalLockIcon(false);
        this.mInnerContainer.addView((View)this.mKidozTopBar, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
    }

    protected void onStart() {
        super.onStart();
    }

    protected void onStop() {
        super.onStop();
    }

    public Bundle onSaveInstanceState() {
        Bundle bundle = super.onSaveInstanceState();
        if (bundle != null) {
            bundle.putSerializable(WEB_PLAYER_TYPE_SAVE_STATE_KEY, (Serializable)((Object)this.mWebPlayerType));
        }
        return bundle;
    }

    @Override
    public void closeDialog() {
        super.closeDialog();
        Intent intent = new Intent();
        intent.setAction("WebPlayerDialogClosed");
        LocalBroadcastManager.getInstance((Context)this.getContext()).sendBroadcast(intent);
    }

    public void dismiss() {
        super.dismiss();
        if (this.mWebPlayerType != null && (this.mWebPlayerType == WebPlayerType.ROVIO || this.mWebPlayerType == WebPlayerType.ONLINE_GAME || this.mWebPlayerType == WebPlayerType.WEB_BROWSER || this.mWebPlayerType == WebPlayerType.HTML_PLAYBACK)) {
            WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.PLAYER_CLOSE, WidgetType.createFromString(this.mWidgetType));
            EventBus.getDefault().post((Object)eventMessage);
        }
    }

    @Override
    public void openDialog() {
        super.openDialog();
        if (this.mWebPlayerType != WebPlayerType.EXTERNAL_LINK) {
            WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.PLAYER_OPEN, WidgetType.createFromString(this.mWidgetType));
            EventBus.getDefault().post((Object)eventMessage);
        }
        switch (this.mWebPlayerType) {
            case EXTERNAL_LINK: {
                this.mLabel = "Web External Link";
                break;
            }
            case ONLINE_GAME: {
                this.mLabel = "Online Games Player";
                break;
            }
            case WEB_BROWSER: {
                this.mLabel = "Website";
                break;
            }
            case HTML_PLAYBACK: {
                this.mLabel = "Html";
                break;
            }
            case ROVIO: {
                this.mLabel = "Rovio";
            }
        }
        if (this.mWebPlayerType != WebPlayerType.EXTERNAL_LINK) {
            EventManager.getInstance(this.getContext()).logEvent(this.getContext(), this.mWidgetType, this.mStyleId, EventManager.LOG_CRITICAL_LEVEL, "Web Player", "Open Dialog", this.mLabel);
            EventManager.getInstance(this.getContext()).logEventWithDurationStart(this.mWidgetType, this.mStyleId, EventManager.LOG_NORMAL_LEVEL, 1, "Web Player", "View Duration", this.mContentItem.getName(), this.mContentItem.getId());
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.staticHandler.removeCallbacksAndMessages(null);
        if (this.mWebPlayerView != null) {
            try {
                this.mWebPlayerView.releaseAndcloseView();
            }
            catch (Exception ex) {
                SDKLogger.printDebbugLog(TAG, "Error when trying to onDetach: " + ex.getMessage());
            }
        }
        if (this.mHtmlViewWrapper != null) {
            try {
                this.mHtmlViewWrapper.stopAndReleaseWebView();
            }
            catch (Exception ex) {
                SDKLogger.printDebbugLog(TAG, "Error when trying to mHtmlViewWrapper.stopAndReleaseWebView(): " + ex.getMessage());
            }
        }
        if (this.mWebPlayerType != WebPlayerType.EXTERNAL_LINK) {
            EventManager.getInstance(this.getContext()).logEvent(this.getContext(), this.mWidgetType, this.mStyleId, EventManager.LOG_CRITICAL_LEVEL, "Web Player", "Close Dialog", this.mLabel);
            EventManager.getInstance(this.getContext()).logEventWithDurationEnd(this.getContext(), this.mWidgetType, this.mStyleId, 1);
        }
    }

    @Override
    protected void onDialogVisibilityChange(int isVisible) {
        super.onDialogVisibilityChange(isVisible);
        if (isVisible != 0) {
            this.staticHandler.removeCallbacksAndMessages(null);
        }
    }

    @Override
    protected void onDialogWindowVisibilityChange(boolean visible) {
        super.onDialogWindowVisibilityChange(visible);
        if (!visible) {
            this.staticHandler.removeCallbacksAndMessages(null);
        }
    }

    class WebPlayerJavaInterface {
        WebPlayerJavaInterface() {
        }

        @JavascriptInterface
        public void onInvokeCloseClick() {
            try {
                WebPlayerDialog.this.staticHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        WebPlayerDialog.this.closeDialog();
                    }
                });
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to close web dialog: " + ex.getMessage());
            }
        }
    }
}

