/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.database;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.SDKLogger;

public class BaseTable {
    private final String TAG = BaseTable.class.getSimpleName();
    protected DatabaseManager mDBmanager;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    protected final Object mSyncObject;

    public BaseTable(DatabaseManager databaseManager, Object syncObj) {
        this.mDBmanager = databaseManager;
        this.mSyncObject = syncObj;
    }

    protected static void printDBLog(DBactionType type, String fucntionName, String tableName, int count) {
        if (ConstantDef.DGM) {
            String print = "";
            switch (type) {
                case INSERT: {
                    print = "KD (" + fucntionName + ")  : Inserted [" + count + "] items into " + tableName + "DB Table";
                    break;
                }
                case UPDATE: {
                    print = "KD (" + fucntionName + ") :  Updated [" + count + "] items at " + tableName + "DB Table";
                    break;
                }
                case DELETE: {
                    print = "KD (" + fucntionName + ") :  Deleted [" + count + "] items from " + tableName + "DB Table";
                    break;
                }
                case LOAD: {
                    print = "KD (" + fucntionName + ") :  Loaded [" + count + "] items from " + tableName + "DB Table";
                }
            }
            SDKLogger.printInfoLog("Kidoz DataBase Print Log", print);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTable(String tableName) {
        if (this.mDBmanager != null) {
            Object object = this.mSyncObject;
            synchronized (object) {
                int rowsCount = 0;
                SQLiteDatabase database = this.mDBmanager.openDatabase();
                int rowID = database.delete(tableName, null, null);
                if (rowID != -1) {
                    rowsCount = rowID;
                }
                BaseTable.printDBLog(DBactionType.DELETE, "clearTable", tableName, rowsCount);
                this.mDBmanager.closeDatabase();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTable(String tableName) {
        if (this.mDBmanager != null) {
            Object object = this.mSyncObject;
            synchronized (object) {
                SQLiteDatabase db = this.mDBmanager.openDatabase();
                try {
                    StringBuilder stringBuilder = new StringBuilder();
                    db.beginTransaction();
                    Cursor cursor = db.query(tableName, null, null, null, null, null, null);
                    if (cursor != null) {
                        String[] columnNames;
                        for (String nextColumn : columnNames = cursor.getColumnNames()) {
                            stringBuilder.append(nextColumn).append("\t");
                        }
                        stringBuilder.append("\n");
                        if (cursor.getCount() > 0) {
                            cursor.moveToFirst();
                            do {
                                for (String nextColumn : columnNames) {
                                    stringBuilder.append(cursor.getString(cursor.getColumnIndex(nextColumn))).append("\t");
                                }
                                stringBuilder.append("\n");
                            } while (cursor.moveToNext());
                        }
                        cursor.close();
                    }
                    SDKLogger.printDebbugLog(this.TAG, ">>>>Print Table = " + tableName + "\n" + stringBuilder.toString());
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                    this.mDBmanager.closeDatabase();
                }
            }
        }
    }

    public static enum DBactionType {
        INSERT,
        UPDATE,
        DELETE,
        LOAD;

    }
}

