/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.dialogs;

import android.animation.Animator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.content.LocalBroadcastManager;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.dialogs.ParentalLockLayoutGenerator;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.StringAssetsUtils;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.general.utils.SdkToast;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import java.util.Random;

public class ParentalLockDialog
extends BaseDialog {
    private static final int DIALOG_BACKGROUND = Color.parseColor((String)"#0fcaf7");
    private static final int DIALOG_BACKGROUND_CORNER_RADIUS = 4;
    public static final float PIVOT_X_FACTOR = 0.722f;
    public static final float PIVOT_Y_FACTOR = 0.04f;
    private final String TAG = ParentalLockDialog.class.getSimpleName();
    public static final String PARENTAL_LOCK_ACTIVE_KEY = "PARENTAL_LOCK_ACTIVE_KEY";
    private final int NUMBER_OF_COLUMNS = 4;
    private int[] mPopLocation;
    private View mRootView;
    private TextView mDialogMessage;
    private TextView mDialogTitleTextView;
    private boolean mIsLockActive;
    private ParentLockDialogListener mParentLockDialogListener;
    private boolean mIsGateToGooglePlay;
    private boolean mIsLockChangeSuccessfully;
    private TextView mEquationTextView;
    private LinearLayout mEquationContainerView;
    private TextView mResTextView1;
    private TextView mResTextView2;
    private TextView mResTextView3;
    private TextView mResTextView4;
    private RelativeLayout mInnerViewContainer;
    private TextView mFeedbackMessage;
    private TextView mFeedbackMessageAction;
    private View mFeedbackMessageContainer;
    private View mAnimatableView;
    private int mCounter;
    private Handler mHandler;
    private int mRightResultIndex;
    private Random random = new Random();

    public ParentalLockDialog(Context context, boolean isGateToGooglePlay, int[] popLocation) {
        super(context, 0x1030011);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.requestWindowFeature(1);
        this.mPopLocation = popLocation;
        this.mIsGateToGooglePlay = isGateToGooglePlay;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mRootView = ParentalLockLayoutGenerator.generateParentalLockView(this.getContext());
        this.setContentView(this.mRootView);
        this.initDialog();
    }

    private void initDialog() {
        this.mHandler = new Handler();
        this.initDialogBackgroundView();
        this.initTitle();
        this.initDialogWidth();
        this.initExitButton();
        this.initQuestionAnswerView();
        this.initMessageTextView();
        this.initFeedbackMessageView();
        this.prepareDialog();
        this.mCounter = 0;
    }

    private void initDialogBackgroundView() {
        KidozCardView kidozCardView = (KidozCardView)this.mRootView.findViewById(ParentalLockLayoutGenerator.PARENTAL_CARDVIEW_ID);
        kidozCardView.setRadius(Utils.dpTOpx(this.getContext(), 4.0f));
        kidozCardView.setCardBackgroundColor(DIALOG_BACKGROUND);
    }

    private void initFeedbackMessageView() {
        this.mFeedbackMessageContainer = this.mRootView.findViewById(ParentalLockLayoutGenerator.FEEDBACK_MESSAGE_CONTAINER_ID);
        this.mFeedbackMessageContainer.setSoundEffectsEnabled(false);
        this.mFeedbackMessageContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ParentalLockDialog.this.prepareDialog();
                if (ParentalLockDialog.this.mIsLockChangeSuccessfully) {
                    ParentalLockDialog.this.mIsLockChangeSuccessfully = false;
                }
                ParentalLockDialog.this.animateFeedBackMessageBack();
            }
        });
        this.mFeedbackMessage = (TextView)this.mRootView.findViewById(ParentalLockLayoutGenerator.FEEDBACK_MESSAGE_TEXT_VIEW_ID);
        this.mFeedbackMessageAction = (TextView)this.mRootView.findViewById(ParentalLockLayoutGenerator.FEEDBACK_ACTION_TEXT_VIEW_ID);
        int availableSpace = Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false));
        if (ScreenUtils.getIsTablet(this.getContext())) {
            availableSpace = (int)(0.8f * (float)availableSpace);
        }
        int itemSize = availableSpace / 4;
        this.mInnerViewContainer = (RelativeLayout)this.mRootView.findViewById(ParentalLockLayoutGenerator.INNER_VIEW_CONTAINER_ID);
        this.mInnerViewContainer.getLayoutParams().width = availableSpace;
        this.mInnerViewContainer.getLayoutParams().height = (int)((float)itemSize * 1.85f);
    }

    private void initTitle() {
        this.mDialogTitleTextView = (TextView)this.mRootView.findViewById(ParentalLockLayoutGenerator.PARENTAL_DIALOG_TITLE_ID);
    }

    private void initDialogWidth() {
        this.mAnimatableView = this.mRootView.findViewById(ParentalLockLayoutGenerator.ANIMATABLE_VIEW);
        this.mAnimatableView.getLayoutParams().width = !ScreenUtils.getIsTablet(this.getContext()) ? Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false)) : (int)(0.8f * (float)Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false)));
    }

    private void prepareDialog() {
        try {
            boolean bl = this.mIsLockActive = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), PARENTAL_LOCK_ACTIVE_KEY) != null;
            if (this.mIsGateToGooglePlay) {
                this.mDialogTitleTextView.setText((CharSequence)StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogTitleForGooglePlay"));
            } else if (this.mIsLockActive) {
                this.mDialogTitleTextView.setText((CharSequence)StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogTitleDeActivate"));
            } else {
                this.mDialogTitleTextView.setText((CharSequence)StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogTitleActivate"));
            }
            if (this.mIsGateToGooglePlay) {
                this.mDialogMessage.setText((CharSequence)StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogMessageGooglePlayGateNew"));
            } else if (this.mIsLockActive) {
                this.mDialogMessage.setText((CharSequence)StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogMessageParentalLockDeactivationNew"));
            } else {
                this.mDialogMessage.setText((CharSequence)StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogMessageParentalLockActivationNew"));
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to prepareDialog: " + ex.getMessage());
        }
        this.generateQuestionAnswerSequence();
    }

    private void initMessageTextView() {
        this.mDialogMessage = (TextView)this.mRootView.findViewById(ParentalLockLayoutGenerator.PARENTAL_LOCK_DIALOG_MESSAGE_TEXTVIEW_ID);
    }

    private void initExitButton() {
        this.mRootView.findViewById(ParentalLockLayoutGenerator.EXIT_BUTTON_ID).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SdkAnimationsUtils.animateClick(view, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        ParentalLockDialog.this.closeParentalDialog();
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        });
    }

    private void initQuestionAnswerView() {
        this.mEquationContainerView = (LinearLayout)this.mRootView.findViewById(ParentalLockLayoutGenerator.EQUATION_VIEW_CONTAINER_ID);
        this.mEquationTextView = (TextView)this.mRootView.findViewById(ParentalLockLayoutGenerator.EQUATION_TEXT_VIEW_ID);
        this.mResTextView1 = (TextView)this.mRootView.findViewById(ParentalLockLayoutGenerator.ANSWER_1_TEXT_VIEW_ID);
        this.mResTextView1.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GenAnimator.playClickAnimation(v, new GenAnimator.IOnClickAnimFinishListener(){

                    @Override
                    public void onClickFinished() {
                        ParentalLockDialog.this.checkResolutionResult(0);
                    }
                });
            }
        });
        this.mResTextView2 = (TextView)this.mRootView.findViewById(ParentalLockLayoutGenerator.ANSWER_2_TEXT_VIEW_ID);
        this.mResTextView2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GenAnimator.playClickAnimation(v, new GenAnimator.IOnClickAnimFinishListener(){

                    @Override
                    public void onClickFinished() {
                        ParentalLockDialog.this.checkResolutionResult(1);
                    }
                });
            }
        });
        this.mResTextView3 = (TextView)this.mRootView.findViewById(ParentalLockLayoutGenerator.ANSWER_3_TEXT_VIEW_ID);
        this.mResTextView3.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GenAnimator.playClickAnimation(v, new GenAnimator.IOnClickAnimFinishListener(){

                    @Override
                    public void onClickFinished() {
                        ParentalLockDialog.this.checkResolutionResult(2);
                    }
                });
            }
        });
        this.mResTextView4 = (TextView)this.mRootView.findViewById(ParentalLockLayoutGenerator.ANSWER_4_TEXT_VIEW_ID);
        this.mResTextView4.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GenAnimator.playClickAnimation(v, new GenAnimator.IOnClickAnimFinishListener(){

                    @Override
                    public void onClickFinished() {
                        ParentalLockDialog.this.checkResolutionResult(3);
                    }
                });
            }
        });
    }

    private void checkResolutionResult(int index) {
        try {
            if (index == this.mRightResultIndex) {
                this.mIsLockChangeSuccessfully = true;
                if (this.mIsGateToGooglePlay) {
                    this.closeParentalDialog();
                } else {
                    if (this.mIsLockActive) {
                        SharedPreferencesUtils.removeSharedPreferencesData(this.getContext(), PARENTAL_LOCK_ACTIVE_KEY);
                    } else {
                        SharedPreferencesUtils.saveSharedPreferencesData(this.getContext(), PARENTAL_LOCK_ACTIVE_KEY, PARENTAL_LOCK_ACTIVE_KEY);
                    }
                    this.animateFeedBackMessageSuccess(this.mIsLockActive);
                    if (this.mParentLockDialogListener != null) {
                        this.mParentLockDialogListener.onPasswordEntered(true);
                        EventManager.getInstance(this.getContext()).LogEventWithIntField(this.getContext(), null, null, EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Correct Password", null, this.mCounter);
                    }
                }
                if (this.mParentLockDialogListener != null) {
                    this.mParentLockDialogListener.onPasswordEntered(true);
                    ++this.mCounter;
                    EventManager.getInstance(this.getContext()).LogEventWithIntField(this.getContext(), null, null, EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Correct Password", null, this.mCounter);
                }
            } else {
                this.animateFeedBackMessageError();
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to handle lock icon click: " + ex.getMessage());
        }
    }

    private void generateQuestionAnswerSequence() {
        int i;
        int[] temp = new int[20];
        int[] mResults = new int[4];
        int firstNum = this.random.nextInt(9);
        int secondNum = this.random.nextInt(9);
        this.mRightResultIndex = this.random.nextInt(3);
        mResults[this.mRightResultIndex] = firstNum + secondNum;
        for (i = 0; i < mResults.length; ++i) {
            if (i == this.mRightResultIndex) continue;
            do {
                mResults[i] = this.random.nextInt(19);
            } while (temp[mResults[i]] != 0 || mResults[i] == mResults[this.mRightResultIndex]);
            temp[mResults[i]] = 1;
        }
        this.mEquationTextView.setText((CharSequence)("" + firstNum + " + " + secondNum + " = ?"));
        block8: for (i = 0; i < mResults.length; ++i) {
            switch (i) {
                case 0: {
                    this.mResTextView1.setText((CharSequence)("" + mResults[0]));
                    continue block8;
                }
                case 1: {
                    this.mResTextView2.setText((CharSequence)("" + mResults[1]));
                    continue block8;
                }
                case 2: {
                    this.mResTextView3.setText((CharSequence)("" + mResults[2]));
                    continue block8;
                }
                case 3: {
                    this.mResTextView4.setText((CharSequence)("" + mResults[3]));
                }
            }
        }
    }

    protected void onStart() {
        super.onStart();
    }

    @Override
    public void show() {
        super.openDialog();
        EventManager.getInstance(this.getContext()).LogEventWithIntField(this.getContext(), null, null, EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Dialog Show", null, this.mCounter);
        this.mAnimatableView.setVisibility(0);
        Utils.setOnGlobalLayoutFinishListener(this.mAnimatableView, new Utils.OnGlobalLayoutFinishedListener(){

            @Override
            public void onLayoutFinished() {
                if (ParentalLockDialog.this.mPopLocation != null) {
                    GenAnimator.playPopInFromRightTop(ParentalLockDialog.this.mAnimatableView, ParentalLockDialog.this.mPopLocation, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                            ParentalLockDialog.this.mAnimatableView.setVisibility(0);
                        }

                        public void onAnimationEnd(Animator animation) {
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                } else {
                    ParentalLockDialog.this.mAnimatableView.setVisibility(0);
                }
            }
        });
    }

    public void closeParentalDialog() {
        this.mHandler.removeCallbacksAndMessages(null);
        if (this.mPopLocation != null) {
            GenAnimator.playPopOutToRightTop(this.mAnimatableView, this.mPopLocation, new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (ParentalLockDialog.this.mParentLockDialogListener != null) {
                        ParentalLockDialog.this.mParentLockDialogListener.onPasswordEntered(false);
                    }
                    EventManager.getInstance((Context)ParentalLockDialog.this.mCallingActivity).LogEventWithIntField((Context)ParentalLockDialog.this.mCallingActivity, null, null, EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Dialog Dismiss", null, ParentalLockDialog.this.mCounter);
                    ParentalLockDialog.this.closeDialog();
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        } else {
            if (this.mParentLockDialogListener != null) {
                this.mParentLockDialogListener.onPasswordEntered(false);
            }
            EventManager.getInstance((Context)this.mCallingActivity).LogEventWithIntField((Context)this.mCallingActivity, null, null, EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Dialog Dismiss", null, this.mCounter);
            this.closeDialog();
        }
    }

    @Override
    public void closeDialog() {
        try {
            Intent intent = new Intent();
            intent.setAction("PARENTAL_DIALOG_CLOSE");
            LocalBroadcastManager.getInstance((Context)this.getContext()).sendBroadcast(intent);
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to send parental dialog close message: " + ex.getMessage());
        }
        super.closeDialog();
    }

    public void setParentLockDialogListener(ParentLockDialogListener parentLockDialogListener) {
        this.mParentLockDialogListener = parentLockDialogListener;
    }

    private void animateFeedBackMessageError() {
        ++this.mCounter;
        EventManager.getInstance(this.getContext()).LogEventWithIntField(this.getContext(), null, null, EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Incorrect Password", null, this.mCounter);
        String tryAgain = StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogWrongSelectionTryAgain");
        String wrongSelection = StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogWrongSelection");
        SpannableString messageTextError = new SpannableString((CharSequence)wrongSelection);
        SpannableString messageActionTryAgain = new SpannableString((CharSequence)tryAgain);
        messageActionTryAgain.setSpan((Object)new StyleSpan(1), 0, messageActionTryAgain.length(), 0);
        this.mFeedbackMessage.setText((CharSequence)messageTextError);
        this.mFeedbackMessageAction.setText((CharSequence)messageActionTryAgain);
        this.mFeedbackMessageContainer.setVisibility(0);
        this.mEquationContainerView.setVisibility(4);
    }

    private void animateFeedBackMessageSuccess(boolean mIsLockActive) {
        if (mIsLockActive) {
            this.closeParentalDialog();
            SdkToast.getSdkInstance(this.getContext()).showToast(StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogLockDeactivatedTitle"), 1);
        } else {
            this.closeParentalDialog();
            SdkToast.getSdkInstance(this.getContext()).showToast(StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogLockActivatedTitle"), 1);
        }
        this.mFeedbackMessageContainer.setVisibility(0);
        this.mInnerViewContainer.setVisibility(4);
    }

    private void animateFeedBackMessageBack() {
        this.mFeedbackMessageContainer.setVisibility(4);
        this.mEquationContainerView.setVisibility(0);
    }

    public static interface ParentLockDialogListener {
        public void onPasswordEntered(boolean var1);
    }
}

