/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.dialogs;

import android.animation.Animator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SdkDeviceUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.web_player.KidozWebView;
import com.kidoz.sdk.api.ui_views.AboutKidozWebViewContainer;
import com.kidoz.sdk.api.ui_views.custom_drawables.XViewDrawable;

public class AboutKidozDialog
extends BaseDialog {
    private final String TAG = AboutKidozDialog.class.getSimpleName();
    private RelativeLayout mRootView;
    private AboutKidozWebViewContainer mContainer;
    private KidozCardView mKidozCardView;
    private int[] mPopLocation;

    public AboutKidozDialog(Context context, int[] popLocation) {
        super(context, 16973839);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.requestWindowFeature(1);
        if (this.getWindow() != null) {
            WindowManager.LayoutParams windowParams = this.getWindow().getAttributes();
            if (windowParams != null) {
                windowParams.dimAmount = 0.7f;
                this.getWindow().setAttributes(windowParams);
            }
            this.getWindow().addFlags(2);
        }
        this.mPopLocation = popLocation;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initDialog();
        this.setContentView((View)this.mRootView);
    }

    private void initDialog() {
        this.initRootView();
        this.initBackgroundkidozCardView();
        this.initWebView();
        this.initCloseButton();
        this.prepareSize();
    }

    private void initCloseButton() {
        Point point = SdkDeviceUtils.getScreenSize(this.getContext());
        int size = Math.min(point.x, point.y);
        size = (int)((double)size * 0.058);
        XViewDrawable xViewDrawable = new XViewDrawable(this.getContext(), Color.parseColor((String)"#04a0e1"));
        final ImageView closeImageView = new ImageView(this.getContext());
        closeImageView.setScaleType(ImageView.ScaleType.FIT_XY);
        closeImageView.setImageDrawable((Drawable)xViewDrawable);
        closeImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GenAnimator.clickItemAnimation(v, 100, new GenAnimator.ViewAnimationListener(){

                    @Override
                    public void onAnimationEnd() {
                        AboutKidozDialog.this.dismiss();
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });
        RelativeLayout.LayoutParams relParams = new RelativeLayout.LayoutParams(size, size);
        relParams.addRule(11);
        relParams.setMargins(0, Utils.dpTOpx(this.getContext(), 5.0f), Utils.dpTOpx(this.getContext(), 5.0f), 0);
        this.mContainer.addView((View)closeImageView, (ViewGroup.LayoutParams)relParams);
        RelativeLayout closeButtonContainer = new RelativeLayout(this.getContext());
        closeButtonContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                closeImageView.performClick();
            }
        });
        closeButtonContainer.setBackgroundColor(0);
        FrameLayout.LayoutParams containerParams = new FrameLayout.LayoutParams(Utils.dpTOpx(this.getContext(), 55.0f), Utils.dpTOpx(this.getContext(), 55.0f));
        containerParams.gravity = 5;
        this.mKidozCardView.addView((View)closeButtonContainer, (ViewGroup.LayoutParams)containerParams);
    }

    private void initRootView() {
        this.mRootView = new RelativeLayout(this.getContext());
    }

    private void initBackgroundkidozCardView() {
        this.mKidozCardView = new KidozCardView(this.getContext());
        this.mKidozCardView.setCardBackgroundColor(Color.parseColor((String)"#ffffff"));
        this.mKidozCardView.setRadius(Utils.dpTOpx(this.getContext(), 4.0f));
        int padding = Utils.dpTOpx(this.getContext(), 10.0f);
        this.mKidozCardView.setPadding(padding, padding, padding, padding);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.setMargins(padding, padding, padding, padding);
        params.addRule(13);
        this.mRootView.addView((View)this.mKidozCardView, (ViewGroup.LayoutParams)params);
        this.mContainer = new AboutKidozWebViewContainer(this.getContext());
        this.mKidozCardView.addView((View)this.mContainer, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    private void prepareSize() {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mKidozCardView.getLayoutParams();
        if (this.getContext().getResources().getConfiguration().orientation == 1) {
            params.width = (int)(0.8f * (float)Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false)));
            params.height = (int)(0.5f * (float)Math.max(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false)));
        } else if (!ScreenUtils.getIsTablet(this.getContext())) {
            params.width = (int)(0.8f * (float)Math.max(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false)));
            params.height = -2;
        } else {
            params.height = params.width = (int)(0.7f * (float)Math.max(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false)));
        }
    }

    private void initWebView() {
        KidozWebView mKidozWebView = new KidozWebView(this.getContext());
        mKidozWebView.getSettings().setUseWideViewPort(true);
        mKidozWebView.getSettings().setLoadWithOverviewMode(true);
        mKidozWebView.getSettings().setSupportZoom(false);
        if (Build.VERSION.SDK_INT >= 21) {
            mKidozWebView.getSettings().setMixedContentMode(0);
        }
        mKidozWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.startsWith("mailto:")) {
                    Intent mailIntent = new Intent("android.intent.action.SENDTO", Uri.parse((String)url));
                    mailIntent.addFlags(0x10000000);
                    AboutKidozDialog.this.getContext().startActivity(mailIntent);
                } else {
                    Intent linkIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                    linkIntent.addFlags(0x10000000);
                    AboutKidozDialog.this.getContext().startActivity(linkIntent);
                }
                return true;
            }
        });
        mKidozWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return false;
            }
        });
        mKidozWebView.setLongClickable(true);
        mKidozWebView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return true;
            }
        });
        mKidozWebView.setVerticalScrollBarEnabled(true);
        mKidozWebView.setHorizontalScrollBarEnabled(false);
        mKidozWebView.setScrollbarFadingEnabled(true);
        mKidozWebView.loadUrl("http://kidoz.net/v3policy/");
        if (Build.VERSION.SDK_INT >= 21) {
            mKidozWebView.getSettings().setMixedContentMode(0);
        }
        this.mContainer.addView((View)mKidozWebView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
    }

    @Override
    public void show() {
        super.openDialog();
        this.mKidozCardView.setVisibility(4);
        Utils.setOnGlobalLayoutFinishListener((View)this.mKidozCardView, new Utils.OnGlobalLayoutFinishedListener(){

            @Override
            public void onLayoutFinished() {
                if (AboutKidozDialog.this.mPopLocation != null) {
                    GenAnimator.playPopInFromRightTop((View)AboutKidozDialog.this.mKidozCardView, AboutKidozDialog.this.mPopLocation, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                            AboutKidozDialog.this.mKidozCardView.setVisibility(0);
                        }

                        public void onAnimationEnd(Animator animation) {
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                } else {
                    AboutKidozDialog.this.mKidozCardView.setVisibility(0);
                }
            }
        });
    }

    public void dismiss() {
        if (this.mPopLocation != null) {
            GenAnimator.playPopOutToRightTop((View)this.mKidozCardView, this.mPopLocation, new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    AboutKidozDialog.super.dismiss();
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        } else {
            AboutKidozDialog.super.dismiss();
        }
    }

    @Override
    protected void onDialogOrientationChange(boolean isPortrait) {
        super.onDialogOrientationChange(isPortrait);
        this.prepareSize();
    }
}

