package com.kidoz.sdk.api.ui_views.video_unit;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.fullscreen_video_layer.FullScreenVideoEnabledWebChromeClient;
import com.kidoz.sdk.api.fullscreen_video_layer.FullScreenVideoEnabledWebView;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;

import org.json.JSONObject;

public class VideoUnitActivity extends Activity
{
    public static final String VIDEO_UNIT_ACTION_BUTTON_TAG = "VIDEO_UNIT_ACTION_BUTTON_TAG";

    private final String TAG = VideoUnitActivity.class.getSimpleName();
    public static FullScreenVideoEnabledWebView mWebView;
    public static VideoUnit.VideoUnitListener sVideoUnitListener;
    private BroadcastReceiver mBroadcastReceiver;
    private boolean mIsAlreadyLoaded = false;

    @Override
    public void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        initActivity();
        setContentView(mWebView, new ViewGroup.MarginLayoutParams(ViewGroup.MarginLayoutParams.MATCH_PARENT, ViewGroup.MarginLayoutParams.MATCH_PARENT));
        invokeJavaScript("javascript:onWidgetOpen();");
        if (sVideoUnitListener != null && sVideoUnitListener != null)
        {
            sVideoUnitListener.onOpen();
        }
    }

    @Override
    protected void onDestroy()
    {
        super.onDestroy();
        invokeJavaScript("javascript:onWidgetClose();");
        if (sVideoUnitListener != null && sVideoUnitListener != null)
        {
            sVideoUnitListener.onClose();
        }

        mWebView = null;
        sVideoUnitListener = null;
    }

    @Override
    protected void onResume()
    {
        super.onResume();
        initFullScreenFlags();
        LocalBroadcastManager.getInstance(VideoUnitActivity.this).registerReceiver(mBroadcastReceiver, new IntentFilter("WebPlayerDialogClosed"));
        LocalBroadcastManager.getInstance(VideoUnitActivity.this).registerReceiver(mBroadcastReceiver, new IntentFilter("CloseVideoUnit"));

        if (mWebView != null)
            mWebView.bringToFront();
        invokeJavaScript("javascript:onWidgetResume();");
    }

    @Override
    protected void onPause()
    {
        super.onPause();
        LocalBroadcastManager.getInstance(VideoUnitActivity.this).unregisterReceiver(mBroadcastReceiver);
        invokeJavaScript("javascript:onWidgetPause();");
    }

    private void initActivity()
    {
        if (getIntent() != null)
        {
            mIsAlreadyLoaded = getIntent().getBooleanExtra("isLoaded", false);
        }

        initFullScreenFlags();
        initWebView();
        initBroadcastReceiver();
    }

    private void forwardToGooglePlay(final String advertiserID, final String appID, final String googlePlayLink, final String widgetType, final String styleID, final String itemIndex)
    {
        runOnUiThread(new Runnable()
        {
            @Override
            public void run()
            {
                int itemIndexAsInteger = 0;
                try
                {
                    itemIndexAsInteger = Integer.parseInt(itemIndex);
                } catch (Exception ex)
                {
                    SDKLogger.printErrorLog(TAG, "Error when trying to parse item index: " + ex.getMessage());
                }
                ContentItem contentItem = new ContentItem();
                contentItem.setId(appID);
                contentItem.setName("");
                contentItem.setData(googlePlayLink);
                contentItem.setContentType(ContentType.PROMOTED_PLAY_APPLICATION);
                contentItem.setAdvertiserID(advertiserID);
                contentItem.setIsPromoted(true);

                ContentExecutionHandler.handleContentItemClick(VideoUnitActivity.this, contentItem, widgetType, styleID, itemIndexAsInteger, false, null);
            }
        });
    }

    private void initWebView()
    {

        if (mWebView != null)
        {
            if (mWebView.getParent() != null)
                ((ViewGroup) mWebView.getParent()).removeView(mWebView);

            if (Build.VERSION.SDK_INT >= 19)
            {
                mWebView.setWebContentsDebuggingEnabled(ConstantDef.DGM);
            }
        }

        if (mIsAlreadyLoaded == false)
        {
            initWebViewSettings();
            VideoUnit.misLoaded = true;
        }
    }

    private void initWebViewSettings()
    {
        if (mWebView != null)
        {
            mWebView.initWebViewSettings();
            mWebView.addJavascriptInterface(new VideoUnitJavascriptInterface(), "VideoUnit");
        }

        PropertiesObj propertiesObj = DatabaseManager.getInstance(VideoUnitActivity.this).getConfigTable().loadAppProperties();
        if (propertiesObj != null)
        {
            String videoUnitURL = propertiesObj.getVideoUnitURL();
//            videoUnitURL = "http://s3.amazonaws.com/kidoz.test.bucket/ronybrosh/VIDEO_UNIT/mergedVideoUnit.html";
            StringBuilder stringBuilder = HtmlViewWrapper.populateMustHaveParams(VideoUnitActivity.this, videoUnitURL);

            stringBuilder.append("&style_id=" + 0);
            stringBuilder.append("&widget_type=").append(WidgetType.WIDGET_TYPE_VIDEO_UNIT.getStringValue());

            SharedPreferences sharedPreferences = VideoUnitActivity.this.getSharedPreferences(EventManager.EVENTS_SHARED_PREFERENCES_KEY, 0);
            long appSessionID = sharedPreferences.getLong(EventManager.EVENTS_LAST_SESSION_ID_KEY, 0);
            stringBuilder.append("&appSessionID=").append(appSessionID);

            if (mWebView != null)
            {
                mWebView.setWebViewClient(new WebViewClient()
                {
                    @Override
                    public boolean shouldOverrideUrlLoading(WebView view, String url)
                    {
                        SDKLogger.printDebbugLog(TAG, "shouldOverrideUrlLoading: URL = " + url);
                        if (url.contains("kidoz") == false && url.contains("youtube") == false)
                        {
                            Intent intent = new Intent(Intent.ACTION_VIEW);
                            intent.setData(Uri.parse(url));
                            startActivity(intent);
                        }
                        return true;
                    }
                });

                FullScreenVideoEnabledWebChromeClient webChromeClient = new FullScreenVideoEnabledWebChromeClient(null, null, null, mWebView)
                {
                };

                webChromeClient.setOnToggledFullscreen(new FullScreenVideoEnabledWebChromeClient.ToggledFullscreenCallback()
                {
                    @Override
                    public void toggledFullscreen(boolean fullscreen)
                    {

                    }
                });
                mWebView.setWebChromeClient(webChromeClient);

                mWebView.loadUrl(stringBuilder.toString());
            }
        }
    }

    private void initBroadcastReceiver()
    {
        mBroadcastReceiver = new BroadcastReceiver()
        {
            @Override
            public void onReceive(Context context, Intent intent)
            {
                if (intent != null)
                {
                    if (intent.getAction().equals("WebPlayerDialogClosed") == true)
                    {
                        if (mWebView != null)
                            mWebView.bringToFront();

                        invokeJavaScript("javascript:onWidgetResume();");
                    } else if (intent.getAction().equals("CloseVideoUnit") == true)
                    {
                        finish();
                    }
                }
            }
        };
    }

    private void initFullScreenFlags()
    {
        if (Build.VERSION.SDK_INT < 16)
        {
            getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        } else
        {
            if (Build.VERSION.SDK_INT < 18)
            {
                View decorView = getWindow().getDecorView();
                int uiOptions = View.SYSTEM_UI_FLAG_FULLSCREEN;
                decorView.setSystemUiVisibility(uiOptions);
            } else
            {
                final View decorView = getWindow().getDecorView();
                decorView.setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_STABLE | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_FULLSCREEN | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
                decorView.setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener()
                {
                    @Override
                    public void onSystemUiVisibilityChange(int visibility)
                    {
                        if ((visibility & View.SYSTEM_UI_FLAG_FULLSCREEN) == 0)
                        {
                            decorView.setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_STABLE | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_FULLSCREEN | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
                        }
                    }
                });
            }
        }
    }

    private void invokeJavaScript(final String javascript)
    {
        runOnUiThread(new Runnable()
        {
            @Override
            public void run()
            {
                if (mWebView != null)
                {
                    if (Build.VERSION.SDK_INT >= 19)
                    {
                        mWebView.evaluateJavascript(javascript, null);
                    } else
                    {
                        mWebView.loadUrl(javascript);
                    }
                }
            }
        });
    }

    public class VideoUnitJavascriptInterface
    {
        @android.webkit.JavascriptInterface
        public void onVideoUnitReady()
        {
        }

        @android.webkit.JavascriptInterface
        public void onCloseVideoUnit()
        {
            runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    Intent intent = new Intent();
                    intent.setAction("CloseVideoUnit");
                    LocalBroadcastManager.getInstance(VideoUnitActivity.this).sendBroadcast(intent);
                }
            });
        }

        @android.webkit.JavascriptInterface
        public void forwardToGooglePlay(final String advertiserID, final String appID, final String googlePlayLink, final String widgetType, final String styleID, final String itemIndex)
        {
            runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    VideoUnitActivity.this.forwardToGooglePlay(advertiserID, appID, googlePlayLink, widgetType, styleID, itemIndex);
                }
            });
        }
    }

    public static void parseVideoUnitStyle(final Context context, final JSONObject json)
    {
        new Thread(new Runnable()
        {
            @Override
            public void run()
            {
                try
                {
                    String actionButtonURL = null;
                    if (json != null)
                    {
                        try
                        {
                            JSONObject videoUnitStyle = json.getJSONObject("videoUnitStyle");
                            JSONObject videoUnit = videoUnitStyle.getJSONObject("videoUnit");
                            actionButtonURL = videoUnit.getString("action_button_url");
                        } catch (Exception ex)
                        {

                        }

                        if (actionButtonURL != null)
                        {
                            boolean isNeedUpdate = false;
                            boolean isNeedRefresh = false;
                            JSONObject jsonObject = DatabaseManager.getInstance(context).getConfigTable().loadProperties(VIDEO_UNIT_ACTION_BUTTON_TAG);
                            if (jsonObject != null)
                            {
                                try
                                {
                                    String oldActionButtonURL = jsonObject.getString(VIDEO_UNIT_ACTION_BUTTON_TAG);
                                    if (oldActionButtonURL != null && oldActionButtonURL.equals(actionButtonURL) == false)
                                    {
                                        // Need to update the action button.
                                        isNeedUpdate = true;
                                        AssetUtil.deleteAssetFile2(context, oldActionButtonURL);
                                    }
                                } catch (Exception ex)
                                {
                                }
                            } else
                            {
                                // This is the first action button update.
                                isNeedUpdate = true;
                                isNeedRefresh = true;
                            }

                            if (isNeedUpdate == true)
                            {
                                AssetUtil.createAssetFile2(context, actionButtonURL);
                                jsonObject = new JSONObject();
                                try
                                {
                                    jsonObject.put(VIDEO_UNIT_ACTION_BUTTON_TAG, actionButtonURL);
                                    DatabaseManager.getInstance(context).getConfigTable().insertProperties(VIDEO_UNIT_ACTION_BUTTON_TAG, jsonObject);
                                    if (isNeedRefresh == true)
                                    {
                                        LocalBroadcastManager.getInstance(context).sendBroadcast(new Intent(EventMessage.MessageType.VIDEO_UNIT_BUTTON_READY.name()));
                                    }
                                } catch (Exception ex)
                                {
                                }
                            }
                        }
                    }
                } catch (Exception ex)
                {

                }
            }
        }).start();
    }
}
