package com.kidoz.sdk.api.server_connect;

import org.json.JSONObject;

import java.io.Serializable;

public class ResponseStatus implements Serializable
{
    private static final String TAG = ResponseStatus.class.getSimpleName();
    private static final long serialVersionUID = 1L;

    private boolean mIsSuccessful;
    private String mErrorCode;

    public ResponseStatus()
    {

    }
    public ResponseStatus(String data)
    {
        if (data != null)
        {
            try
            {
                JSONObject jSONObject = new JSONObject(data);
                if (jSONObject.has("success") == true && jSONObject.isNull("success") == false)
                {
                    mIsSuccessful = jSONObject.getBoolean("success");
                }
                if (jSONObject.has("error_code") == true && jSONObject.isNull("error_code") == false)
                {
                    mErrorCode = jSONObject.getString("error_code");
                }
            }
            catch (Exception ex)
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error creating response status: " + ex.getMessage());
            }
        }
    }

    public boolean getIsSuccessful()
    {
        return mIsSuccessful;
    }

    public void setIsSuccessful(boolean isSuccessful)
    {
        mIsSuccessful = isSuccessful;
    }

    public String getErrorCode()
    {
        return mErrorCode;
    }

    public void setErrorCode(String errorCode)
    {
        mErrorCode = errorCode;
    }
}
