package com.kidoz.sdk.api.general.utils;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;


public class SdkToast {

    private static SdkToast mInstance;

    private Context mContext;
    private Toast mToast;
    private TextView mTextView;

    private SdkToast(Context context) {
        mContext = context;
        initToast(mContext);
    }

    public static SdkToast getSdkInstance(Context context) {
        if (mInstance == null) {
            mInstance = new SdkToast(context);
        }
        return mInstance;
    }

    private void initToast(Context mContext) {
        mToast = new Toast(mContext);
        mToast.setView(generateToastLayout(mContext));
    }

    private View generateToastLayout(Context context) {
        LinearLayout container = new LinearLayout(context);
        container.setGravity(Gravity.CENTER);

        mTextView = new TextView(context);
        mTextView.setGravity(Gravity.CENTER);
        mTextView.setTypeface(Typeface.DEFAULT_BOLD);
        mTextView.setEllipsize(TextUtils.TruncateAt.END);
        mTextView.setTextColor(Color.WHITE);
        mTextView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 17);
        mTextView.setMinLines(2);
        int padding = Utils.dpTOpx(mContext, 12);
        mTextView.setPadding(padding, padding, padding, padding);

        GradientDrawable gradientDrawable = new GradientDrawable();

        gradientDrawable.setColor(Color.parseColor("#ee39b0c6"));
        gradientDrawable.setStroke(Utils.spTOpx(mContext, 1), Color.parseColor("#ffffff"));
        gradientDrawable.setCornerRadius(Utils.dpTOpx(mContext, 15));

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            mTextView.setBackground(gradientDrawable);
        } else {
            mTextView.setBackgroundDrawable(gradientDrawable);
        }

        container.addView(mTextView, new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT));
        return container;
    }


    public void showToast(String text, int duration) {
        mTextView.setText(text);
        mToast.setDuration(duration);
        mToast.show();
    }
}
