package com.kidoz.sdk.api.general.utils;

import org.json.JSONException;
import org.json.JSONObject;


public class PropertiesObj
{
    public static final String DEFAULT_YOUTUBE_HTML_URL = "http://cdn.kidoz.net/video_player/video_player_sdk.html";
    public static final String VIDEO_UNIT_DEFAULT_URL = "http://d28lrrc51wcjkk.cloudfront.net/video_unit/html/default/v1.0.0/DefaultTV.html";

    private static final String CONFIG_VERSION_KEY = "configuration_version";
    private static final String SDK_STYLE_VERSION_KEY = "style";
    private static final String HTML_LOADER_DEFAULT_URL_KEY = "htmlLoaderDefaultURL";
    private static final String YOUTUBE_PLAYER_DEFAULT_HTML_KEY = "defaultHTMLPlayerURL";
    private static final String INTERSTITIAL_DEFAULT_URL_KEY = "interstitialHTMLURL";
    private static final String TIME_TO_WAIT_FOR_INSTALL_EVENT_MINUTES = "timeToWaitForInstallEvent";

    private static final String PANEL_VIEW_STYLE = "panelStyle";
    private static final String FEED_VIEW_STYLE = "feedStyle";
    private static final String FLEXI_VIEW_STYLE = "flexiStyle";
    private static final String INTERSTITIAL_VIEW_STYLE = "interstitialStyle";

    // This key return the video unit style which then parsed to get the actual video unit url.
    private static final String VIDEO_UNIT_URL = "video_unit_url";

    JSONObject mProperties = new JSONObject();

    public PropertiesObj(JSONObject data)
    {
        mProperties = data;
    }

    public JSONObject getData()
    {
        return mProperties;
    }

    public int getConfigVersion()
    {
        int result = -1;
        if (mProperties != null)
        {
            result = mProperties.optInt(CONFIG_VERSION_KEY, 1);
        }
        return result;
    }

    public int getSdkStyleVersion()
    {
        int result = -1;
        if (mProperties != null)
        {
            result = mProperties.optInt(SDK_STYLE_VERSION_KEY, 0);
        }
        return result;
    }

    public JSONObject getProperties()
    {
        return mProperties;
    }

    public String getHtmlLoaderDefaultLink()
    {
        String result = "";
        if (mProperties != null)
        {
            result = mProperties.optString(HTML_LOADER_DEFAULT_URL_KEY, "");
        }
        return result;
    }

    public String getDefaultYouTubePlayerHtmlLink()
    {
        String result = DEFAULT_YOUTUBE_HTML_URL;
        if (mProperties != null)
        {
            result = mProperties.optString(YOUTUBE_PLAYER_DEFAULT_HTML_KEY, result);
        }
        return result;
    }

    public String getInterstitialHtmlLink()
    {
        String result = "";
        if (mProperties != null)
        {
            result = mProperties.optString(INTERSTITIAL_DEFAULT_URL_KEY, result);
        }
        return result;
    }

    public String getVideoUnitURL()
    {
        String result = VIDEO_UNIT_DEFAULT_URL;
        if (mProperties != null)
        {
            result = mProperties.optString(VIDEO_UNIT_URL, result);
        }
        return result;
    }

    public String getPanelViewStyle()
    {
        String result = null;
        if (mProperties != null)
        {
            result = mProperties.optString(PANEL_VIEW_STYLE, result);
        }
        return result;
    }

    public String getFeedViewStyle()
    {
        String result = null;
        if (mProperties != null)
        {
            result = mProperties.optString(FEED_VIEW_STYLE, result);
        }
        return result;
    }

    public String getFlexiViewStyle()
    {
        String result = null;
        if (mProperties != null)
        {
            result = mProperties.optString(FLEXI_VIEW_STYLE, result);
        }
        return result;
    }

    public String getInterstitialViewStyle()
    {
        String result = null;
        if (mProperties != null)
        {
            result = mProperties.optString(INTERSTITIAL_VIEW_STYLE, result);
        }
        return result;
    }

    public String parseVideoUnitURL()
    {
        String result = VIDEO_UNIT_DEFAULT_URL;
        if (mProperties != null)
        {
            try
            {
                JSONObject videoUnitStyle = mProperties.optJSONObject("videoUnitStyle");
                JSONObject videoUnit = videoUnitStyle.optJSONObject("videoUnit");
                result = videoUnit.optString(VIDEO_UNIT_URL, result);
            }
            catch (Exception ex)
            {

            }

        }
        return result;
    }

    public int getMaxTimeToWaitForInstall()
    {
        int result = 24 * 60 * 60 * 1000;
        if (mProperties != null)
        {
            result = mProperties.optInt(TIME_TO_WAIT_FOR_INSTALL_EVENT_MINUTES);
        }
        return result;
    }

    public void setConfigVersion(int version)
    {
        try
        {
            mProperties.put(CONFIG_VERSION_KEY, version);
        }
        catch (Exception ex)
        {

        }
    }

    // Update Configuration properties from other properties object (Updates all except the Configuration Version field)
    public void updateConfigFromData(PropertiesObj data)
    {
        try
        {
            if (data != null)
            {
                mProperties.put(CONFIG_VERSION_KEY, data.getConfigVersion());
                mProperties.put(SDK_STYLE_VERSION_KEY, data.getSdkStyleVersion());
                mProperties.put(HTML_LOADER_DEFAULT_URL_KEY, data.getHtmlLoaderDefaultLink());
                mProperties.put(YOUTUBE_PLAYER_DEFAULT_HTML_KEY, data.getDefaultYouTubePlayerHtmlLink());
                mProperties.put(INTERSTITIAL_DEFAULT_URL_KEY, data.getInterstitialHtmlLink());
                mProperties.put(TIME_TO_WAIT_FOR_INSTALL_EVENT_MINUTES, data.getMaxTimeToWaitForInstall());
                mProperties.put(VIDEO_UNIT_URL, data.parseVideoUnitURL());

                mProperties.put(PANEL_VIEW_STYLE, data.getPanelViewStyle());
                mProperties.put(FEED_VIEW_STYLE, data.getFeedViewStyle());
                mProperties.put(FLEXI_VIEW_STYLE, data.getFlexiViewStyle());
                mProperties.put(INTERSTITIAL_VIEW_STYLE, data.getInterstitialViewStyle());
            }
        }
        catch (JSONException e)
        {
        }
    }
}
