package com.kidoz.sdk.api.general.animations;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;

import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;

/**
 * Created by User on 14/07/2015.
 * Class that hold specific animations used in the SDK
 */
public class GenAnimator
{
    public static String ROTATE_HORIZONTAL = "rotateHorizontal";
    public static String PRESS_IN_OUT = "pressInOut";
    public static String PRESS_TOP = "pressTop";
    public static String PRESS_LEFT = "pressLeft";
    public static String PRESS_RIGHT = "pressRight";

    /**
     * Content item click animation
     */
    public static AnimatorSet clickItemAnimation(View view, int duration, final ViewAnimationListener listener)
    {
        AnimatorSet cilAnim = new AnimatorSet();
        AnimatorSet clickSet = new AnimatorSet();
        clickSet.playTogether(ObjectAnimator.ofFloat(view, "scaleX", 1, 0.8f), ObjectAnimator.ofFloat(view, "scaleY", 1, 0.8f));

        AnimatorSet unClickSet = new AnimatorSet();
        unClickSet.playTogether(ObjectAnimator.ofFloat(view, "scaleX", 0.8f, 1), ObjectAnimator.ofFloat(view, "scaleY", 0.8f, 1));

        cilAnim.playSequentially(clickSet, unClickSet);
        cilAnim.setDuration(duration);
        cilAnim.setInterpolator(new AccelerateDecelerateInterpolator());

        cilAnim.addListener(new Animator.AnimatorListener()
        {
            @Override
            public void onAnimationStart(Animator animation)
            {
                if (listener != null)
                {
                    listener.onAnimationStart();
                }
            }

            @Override
            public void onAnimationEnd(Animator animation)
            {
                if (listener != null)
                {
                    listener.onAnimationEnd();
                }
            }

            @Override
            public void onAnimationCancel(Animator animation)
            {

            }

            @Override
            public void onAnimationRepeat(Animator animation)
            {

            }
        });

        cilAnim.start();
        return cilAnim;
    }

    public static AnimatorSet animateLongDurationClick(View view, int duration, final ViewAnimationListener listener)
    {
        AnimatorSet cilAnim = new AnimatorSet();
        AnimatorSet clickSet = new AnimatorSet();
        clickSet.playTogether(ObjectAnimator.ofFloat(view, "scaleX", 1, 0.95f), ObjectAnimator.ofFloat(view, "scaleY", 1, 0.95f));

        AnimatorSet unClickSet = new AnimatorSet();
        unClickSet.playTogether(ObjectAnimator.ofFloat(view, "scaleX", 0.95f, 1), ObjectAnimator.ofFloat(view, "scaleY", 0.95f, 1));

        cilAnim.playSequentially(clickSet, unClickSet);
        cilAnim.setDuration(duration);
        cilAnim.setInterpolator(new AccelerateDecelerateInterpolator());

        cilAnim.addListener(new Animator.AnimatorListener()
        {
            @Override
            public void onAnimationStart(Animator animation)
            {
                if (listener != null)
                {
                    listener.onAnimationStart();
                }
            }

            @Override
            public void onAnimationEnd(Animator animation)
            {
                if (listener != null)
                {
                    listener.onAnimationEnd();
                }
            }

            @Override
            public void onAnimationCancel(Animator animation)
            {

            }

            @Override
            public void onAnimationRepeat(Animator animation)
            {

            }
        });

        cilAnim.start();
        return cilAnim;
    }

    public static AnimatorSet animateItem(View view, int duration, final ViewAnimationListener listener)
    {
        AnimatorSet cilAnim = new AnimatorSet();
        cilAnim.setStartDelay(duration);
        AnimatorSet clickSet = new AnimatorSet();
        clickSet.playTogether(ObjectAnimator.ofFloat(view, "scaleX", 1, 0.8f), ObjectAnimator.ofFloat(view, "scaleY", 1, 0.8f));

        AnimatorSet unClickSet = new AnimatorSet();
        unClickSet.playTogether(ObjectAnimator.ofFloat(view, "scaleX", 0.8f, 1), ObjectAnimator.ofFloat(view, "scaleY", 0.8f, 1));

        cilAnim.playSequentially(clickSet, unClickSet);
        cilAnim.setDuration(duration);
        cilAnim.setInterpolator(new AccelerateDecelerateInterpolator());

        cilAnim.addListener(new Animator.AnimatorListener()
        {
            @Override
            public void onAnimationStart(Animator animation)
            {
                if (listener != null)
                {
                    listener.onAnimationStart();
                }
            }

            @Override
            public void onAnimationEnd(Animator animation)
            {
                if (listener != null)
                {
                    listener.onAnimationEnd();
                }
            }

            @Override
            public void onAnimationCancel(Animator animation)
            {

            }

            @Override
            public void onAnimationRepeat(Animator animation)
            {

            }
        });

        cilAnim.start();
        return cilAnim;
    }

    public static AnimatorSet animateWalking(View view, int duration, float startDistance, float distance, final ViewAnimationListener listener)
    {
        AnimatorSet result = new AnimatorSet();
        result.setDuration(duration);
        result.setInterpolator(new LinearInterpolator());
        result.play(ObjectAnimator.ofFloat(view, "translationX", startDistance, distance));

        result.addListener(new Animator.AnimatorListener()
        {
            @Override
            public void onAnimationStart(Animator animation)
            {
                if (listener != null)
                {
                    listener.onAnimationStart();
                }
            }

            @Override
            public void onAnimationEnd(Animator animation)
            {
                if (listener != null)
                {
                    listener.onAnimationEnd();
                }
            }

            @Override
            public void onAnimationCancel(Animator animation)
            {

            }

            @Override
            public void onAnimationRepeat(Animator animation)
            {

            }
        });

        result.start();
        return result;
    }

    public interface ViewAnimationListener
    {

        void onAnimationEnd();

        void onAnimationStart();
    }

    /**
     * Recycle item show animation
     */
    public static AnimatorSet recycleItemAnimation(View view, final ViewAnimationListener listener)
    {
        ObjectAnimator anim1 = ObjectAnimator.ofFloat(view, "scaleX", 0.52f, 1f);
        anim1.setDuration(250);

        ObjectAnimator anim2 = ObjectAnimator.ofFloat(view, "scaleY", 0.52f, 1f);
        anim2.setDuration(250);

        ObjectAnimator anim3 = ObjectAnimator.ofFloat(view, "alpha", 0.2f, 1f);
        anim3.setDuration(250);

        AnimatorSet set = new AnimatorSet();
        set.playTogether(anim1, anim2, anim3);
        set.setInterpolator(new AccelerateDecelerateInterpolator());

        set.addListener(new Animator.AnimatorListener()
        {
            @Override
            public void onAnimationStart(Animator animation)
            {
                if (listener != null)
                {
                    listener.onAnimationStart();
                }
            }

            @Override
            public void onAnimationEnd(Animator animation)
            {
                if (listener != null)
                {
                    listener.onAnimationEnd();
                }
            }

            @Override
            public void onAnimationCancel(Animator animation)
            {

            }

            @Override
            public void onAnimationRepeat(Animator animation)
            {

            }
        });

        set.start();
        return set;
    }

    /**
     * Slider panel slide up (Show animation)
     */
    public static AnimatorSet hideTopBar(View view, int slideOffset, int duration, TimeInterpolator timeInterpolator, Animator.AnimatorListener animatorListener)
    {
        AnimatorSet set = new AnimatorSet();
        set.play(ObjectAnimator.ofFloat(view, "translationY", 0, slideOffset));
        set.setDuration(duration);
        if (timeInterpolator != null)
        {
            set.setInterpolator(timeInterpolator);
        }

        if (animatorListener != null)
        {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    /**
     * Slider panel slide down (Hide animation)
     */
    public static AnimatorSet showTopBar(View view, int slideOffset, int duration, TimeInterpolator timeInterpolator, Animator.AnimatorListener animatorListener)
    {
        AnimatorSet set = new AnimatorSet();
        set.play(ObjectAnimator.ofFloat(view, "translationY", -slideOffset, 0));
        set.setDuration(duration);
        if (timeInterpolator != null)
        {
            set.setInterpolator(timeInterpolator);
        }
        if (animatorListener != null)
        {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    /**
     * Play slide In left animation
     */
    public static AnimatorSet playSlideInLeftAnimation(View view, Animator.AnimatorListener animatorListener, int duration)
    {
        AnimatorSet set = new AnimatorSet();
        int distance = view.getWidth() - view.getLeft();
        set.playTogether(ObjectAnimator.ofFloat(view, "alpha", 0, 1), ObjectAnimator.ofFloat(view, "translationX", -distance, 0));
        set.setDuration(duration);
        set.setInterpolator(new DecelerateInterpolator());
        if (animatorListener != null)
        {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    /**
     * Play slide In left animation
     */
    public static AnimatorSet playSlideInRightAnimation(View view, Animator.AnimatorListener animatorListener, int duration)
    {
        AnimatorSet set = new AnimatorSet();
        int distance = view.getWidth() - view.getLeft();
        set.playTogether(ObjectAnimator.ofFloat(view, "alpha", 0, 1), ObjectAnimator.ofFloat(view, "translationX", distance, 0));
        set.setDuration(duration);
        set.setInterpolator(new DecelerateInterpolator());
        if (animatorListener != null)
        {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    /**
     * Play slide Out left animation
     */
    public static AnimatorSet playSlideOutLeftAnimation(View view, Animator.AnimatorListener animatorListener, int duration)
    {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(ObjectAnimator.ofFloat(view, "alpha", 1, 0), ObjectAnimator.ofFloat(view, "translationX", 0, -view.getWidth()));
        set.setDuration(duration);
        set.setInterpolator(new DecelerateInterpolator());
        if (animatorListener != null)
        {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    /**
     * Play slide Out right animation
     */
    public static AnimatorSet playSlideOutRightAnimation(View view, Animator.AnimatorListener animatorListener, int duration)
    {
        AnimatorSet set = new AnimatorSet();
        int distance = view.getWidth() - view.getLeft();
        set.playTogether(ObjectAnimator.ofFloat(view, "alpha", 0, 1), ObjectAnimator.ofFloat(view, "translationX", 0, distance));
        set.setDuration(duration);
        set.setInterpolator(new DecelerateInterpolator());
        if (animatorListener != null)
        {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    /**
     * Play bounce in right animation
     */
    public static AnimatorSet playBounceInRightAnimation(View view, Animator.AnimatorListener animatorListener, int duration)
    {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(ObjectAnimator.ofFloat(view, "translationX", -view.getWidth(), 30, -10, 0), ObjectAnimator.ofFloat(view, "alpha", 0, 1, 1, 1));
        set.setDuration(duration);
        set.setInterpolator(new AccelerateInterpolator());
        if (animatorListener != null)
        {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    /**
     * Play bounce in left animation
     */
    public static AnimatorSet playBounceInLeftAnimation(View view, Animator.AnimatorListener animatorListener, int duration)
    {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(ObjectAnimator.ofFloat(view, "translationX", view.getWidth(), -30, 10, 0), ObjectAnimator.ofFloat(view, "alpha", 0, 1, 1, 1));
        set.setDuration(duration);
        if (animatorListener != null)
        {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    /**
     * Stand up animation
     */
    public static AnimatorSet playStandUpAnimation(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        float x = (target.getWidth() - target.getPaddingLeft() - target.getPaddingRight()) / 2 + target.getPaddingLeft();
        float y = target.getPaddingBottom();
        result.setInterpolator(new LinearInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", x), ObjectAnimator.ofFloat(target, "pivotY", y, y), ObjectAnimator.ofFloat(target, "rotationX", -15, -30, -15, 0, 15, 0, -15, 0, 10, 0, -10, 0, 5, 0, -5, 0));
        result.setDuration(750);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playStandUpAnimationBottom(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        float x = (target.getWidth() - target.getPaddingLeft() - target.getPaddingRight()) / 2 + target.getPaddingLeft();
        float y = target.getHeight();
        result.setInterpolator(new LinearInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", x), ObjectAnimator.ofFloat(target, "pivotY", y, y), ObjectAnimator.ofFloat(target, "rotationX", 15, 30, 15, 0, -15, 0, 15, 0));
        result.setDuration(550);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPressTopAnimation(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        float x = (target.getWidth() - target.getPaddingLeft() - target.getPaddingRight()) / 2 + target.getPaddingLeft();
        float y = target.getHeight();
        result.setInterpolator(new LinearInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", x), ObjectAnimator.ofFloat(target, "pivotY", y), ObjectAnimator.ofFloat(target, "rotationX", 15, 30, 15, 0));
        result.setDuration(250);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPressLeftAnimation(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        float x = target.getWidth();
        float y = target.getHeight() / 2;
        result.setInterpolator(new LinearInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", x), ObjectAnimator.ofFloat(target, "pivotY", y), ObjectAnimator.ofFloat(target, "rotationY", -5, -10, -5, 0));
        result.setDuration(250);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPressRightAnimation(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        float x = 0;
        float y = target.getHeight() / 2;
        result.setInterpolator(new LinearInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", x), ObjectAnimator.ofFloat(target, "pivotY", y), ObjectAnimator.ofFloat(target, "rotationY", 5, 10, 5, 0));
        result.setDuration(250);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playDropAnimation(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new BounceInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "translationY", -target.getHeight(), 0));
        result.setDuration(800);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playOnBoardingCloudDropAnimation(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new LinearInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "translationY", -target.getHeight(), 0));
        result.setDuration(800);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopOutAnimation(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new AccelerateInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "translationY", 0, -target.getHeight()));
        result.setDuration(450);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopInFromRightBottom(View target, int[] pivot, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        int pivotX = target.getWidth() - pivot[0];
        int pivotY = target.getHeight() - pivot[1];
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new DecelerateInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", pivotX, pivotX), ObjectAnimator.ofFloat(target, "pivotY", pivotY, pivotY), ObjectAnimator.ofFloat(target, "scaleX", 0f, 1f), ObjectAnimator.ofFloat(target, "scaleY", 0f, 1f));
        result.setDuration(270);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopInFromRightTop(View target, int[] pivot, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        int pivotX = -target.getLeft() + pivot[0];
        int pivotY = -target.getTop() + pivot[1];
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new DecelerateInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", pivotX, pivotX), ObjectAnimator.ofFloat(target, "pivotY", pivotY, pivotY), ObjectAnimator.ofFloat(target, "scaleX", 0f, 1f), ObjectAnimator.ofFloat(target, "scaleY", 0f, 1f));
        result.setDuration(270);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopOutToRightBottom(View target, int[] pivot, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        int pivotX = target.getWidth() - pivot[0];
        int pivotY = target.getHeight() - pivot[1];
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new AccelerateInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", pivotX, pivotX), ObjectAnimator.ofFloat(target, "pivotY", pivotY, pivotY), ObjectAnimator.ofFloat(target, "scaleX", 1f, 0f), ObjectAnimator.ofFloat(target, "scaleY", 1f, 0f));
        result.setDuration(320);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopOutToRightTop(View target, int[] pivot, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        int pivotX = -target.getLeft() + pivot[0];
        int pivotY = -target.getTop() + pivot[1];
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new AccelerateInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", pivotX, pivotX), ObjectAnimator.ofFloat(target, "pivotY", pivotY, pivotY), ObjectAnimator.ofFloat(target, "scaleX", 1f, 0f), ObjectAnimator.ofFloat(target, "scaleY", 1f, 0f));
        result.setDuration(320);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static void closePanelView(View target, long duration, View anchorView, PANEL_TYPE panelType, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        switch (panelType)
        {
           /* case LEFT:
            {
                float distance = anchorView.getWidth();
                result.play(ObjectAnimator.ofFloat(target, "translationX", 0f, -distance));
                break;
            }*/
            case TOP:
            {
                float distance = anchorView.getHeight();
                result.play(ObjectAnimator.ofFloat(target, "translationY", 0f, -distance));
                break;
            }
           /* case RIGHT:
            {
                float distance = anchorView.getWidth();
                result.play(ObjectAnimator.ofFloat(target, "translationX", 0f, distance));
                break;
            }*/
            case BOTTOM:
            {
                float distance = anchorView.getHeight();
                result.play(ObjectAnimator.ofFloat(target, "translationY", 0f, distance));
                break;
            }
        }
        result.setInterpolator(new AccelerateInterpolator());
        result.setDuration(duration);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
    }

    public static void openPanelView(View target, View anchorView, PANEL_TYPE panelType, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        switch (panelType)
        {
           /* case LEFT:
            {
                float distance = -anchorView.getWidth();
                result.play(ObjectAnimator.ofFloat(target, "translationX", distance, 0f));
                break;
            }*/
            case TOP:
            {
                float distance = -anchorView.getHeight();
                result.play(ObjectAnimator.ofFloat(target, "translationY", distance, 0f));
                break;
            }
            /*case RIGHT:
            {
                float distance = anchorView.getWidth();
                result.play(ObjectAnimator.ofFloat(target, "translationX", distance, 0f));
                break;
            }*/
            case BOTTOM:
            {
                float distance = anchorView.getHeight();
                result.play(ObjectAnimator.ofFloat(target, "translationY", distance, 0f));
                break;
            }
        }
        result.setInterpolator(new DecelerateInterpolator());
        result.setDuration(200);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
    }

    public static AnimatorSet playClickAnimation(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        AnimatorSet clickStart = new AnimatorSet();
        clickStart.setInterpolator(new DecelerateInterpolator());
        clickStart.playTogether(ObjectAnimator.ofFloat(target, "scaleX", 1f, 0.8f), ObjectAnimator.ofFloat(target, "scaleY", 1f, 0.8f));
        clickStart.setDuration(90);

        AnimatorSet clickEnd = new AnimatorSet();
        clickEnd.setInterpolator(new AccelerateInterpolator());
        clickEnd.playTogether(ObjectAnimator.ofFloat(target, "scaleX", 0.8f, 1f), ObjectAnimator.ofFloat(target, "scaleY", 0.8f, 1f));
        clickEnd.setDuration(90);

        result.playSequentially(clickStart, clickEnd);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playClickAnimation(View target, final IOnClickAnimFinishListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        AnimatorSet clickStart = new AnimatorSet();
        clickStart.setInterpolator(new DecelerateInterpolator());
        clickStart.playTogether(ObjectAnimator.ofFloat(target, "scaleX", 1f, 0.8f), ObjectAnimator.ofFloat(target, "scaleY", 1f, 0.8f));
        clickStart.setDuration(90);

        AnimatorSet clickEnd = new AnimatorSet();
        clickEnd.setInterpolator(new AccelerateInterpolator());
        clickEnd.playTogether(ObjectAnimator.ofFloat(target, "scaleX", 0.8f, 1f), ObjectAnimator.ofFloat(target, "scaleY", 0.8f, 1f));
        clickEnd.setDuration(90);

        result.playSequentially(clickStart, clickEnd);

        result.addListener(new Animator.AnimatorListener()
        {
            @Override
            public void onAnimationStart(Animator animation)
            {

            }

            @Override
            public void onAnimationEnd(Animator animation)
            {
                animatorListener.onClickFinished();
            }

            @Override
            public void onAnimationCancel(Animator animation)
            {

            }

            @Override
            public void onAnimationRepeat(Animator animation)
            {

            }
        });

        result.start();
        return result;
    }

    public interface IOnClickAnimFinishListener
    {
        void onClickFinished();
    }

    public static AnimatorSet playPanelButtonClickAnimation(View target, PANEL_TYPE panelType, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new DecelerateInterpolator());

        switch (panelType)
        {
           /* case LEFT:
            {
                float pivotX = 0;
                float pivotY = target.getHeight() / 2;
                result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", pivotX, pivotX, pivotX, pivotX), ObjectAnimator.ofFloat(target, "pivotY", pivotY, pivotY, pivotY, pivotY), ObjectAnimator.ofFloat(target, "rotationY", 15, 30, 15, 0));

                break;
            }*/
            case TOP:
            {
                float pivotX = target.getWidth() / 2;
                float pivotY = 0;
                result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", pivotX, pivotX, pivotX, pivotX), ObjectAnimator.ofFloat(target, "pivotY", pivotY, pivotY, pivotY, pivotY), ObjectAnimator.ofFloat(target, "rotationX", -15, -30, -15, 0));

                break;
            }
           /* case RIGHT:
            {
                float pivotX = target.getWidth();
                float pivotY = target.getHeight() / 2;
                result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", pivotX, pivotX, pivotX, pivotX), ObjectAnimator.ofFloat(target, "pivotY", pivotY, pivotY, pivotY, pivotY), ObjectAnimator.ofFloat(target, "rotationY", -15, -30, -15, 0));

                break;
            }*/
            case BOTTOM:
            {
                float pivotX = target.getWidth() / 2;
                float pivotY = target.getHeight();
                result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", pivotX, pivotX, pivotX, pivotX), ObjectAnimator.ofFloat(target, "pivotY", pivotY, pivotY, pivotY, pivotY), ObjectAnimator.ofFloat(target, "rotationX", 15, 30, 15, 0));
                break;
            }
        }
        result.setDuration(200);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playGrowAnimation(View target, long duration, long startDelay, Interpolator interpolator, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new AccelerateInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "scaleX", 0f, 1f), ObjectAnimator.ofFloat(target, "scaleY", 0f, 1f));
        result.setDuration(duration);
        result.setStartDelay(startDelay);
        if (interpolator != null)
        {
            result.setInterpolator(interpolator);
        }
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playShrinkAnimation(View target, long duration, TimeInterpolator interpolator, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        if (interpolator != null)
        {
            result.setInterpolator(interpolator);
        }
        result.playTogether(ObjectAnimator.ofFloat(target, "scaleX", 1f, 0f), ObjectAnimator.ofFloat(target, "scaleY", 1f, 0f));
        result.setDuration(duration);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet animateHandleClose(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        float pivotX = target.getWidth() / 2;
        float pivotY = target.getHeight() / 2;

        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new DecelerateInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", pivotX), ObjectAnimator.ofFloat(target, "pivotY", pivotY), ObjectAnimator.ofFloat(target, "rotation", 0, 0));
        result.setDuration(300);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet animateHandleOpen(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        float pivotX = target.getWidth() / 2;
        float pivotY = target.getHeight() / 2;

        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new DecelerateInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", pivotX), ObjectAnimator.ofFloat(target, "pivotY", pivotY), ObjectAnimator.ofFloat(target, "rotation", 0, 0));
        result.setDuration(300);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet getBanner(final View view, final int slideOffset, final int duration, final TimeInterpolator timeInterpolator, final Animator.AnimatorListener animatorListener)
    {
        final AnimatorSet fullAnimSet = new AnimatorSet();

        AnimatorSet side1Set = new AnimatorSet();
        side1Set.playTogether(ObjectAnimator.ofFloat(view, "scaleY", 1f, 0.5f, 0.5f, 0.5f, 1f), ObjectAnimator.ofFloat(view, "scaleX", 1f, 0.5f, 0.5f, 0.5f, 1f), ObjectAnimator.ofFloat(view, "rotation", 360, 0), ObjectAnimator.ofFloat(view, "translationX", 0, -slideOffset));

        AnimatorSet side2Set = new AnimatorSet();
        side2Set.playTogether(ObjectAnimator.ofFloat(view, "scaleY", 1f, 0.5f, 0.5f, 0.5f, 1f), ObjectAnimator.ofFloat(view, "scaleX", 1f, 0.5f, 0.5f, 0.5f, 1f), ObjectAnimator.ofFloat(view, "rotation", 0, 360), ObjectAnimator.ofFloat(view, "translationX", -slideOffset, 0));
        side2Set.setStartDelay(duration / 2);

        fullAnimSet.playSequentially(side1Set, side2Set);
        fullAnimSet.setDuration(duration);
        fullAnimSet.setInterpolator(new AccelerateDecelerateInterpolator());
        fullAnimSet.setStartDelay(1500);

        if (timeInterpolator != null)
        {
            fullAnimSet.setInterpolator(timeInterpolator);
        }

        if (animatorListener != null)
        {
            fullAnimSet.addListener(animatorListener);
        } else
        {
            fullAnimSet.addListener(new Animator.AnimatorListener()
            {
                @Override
                public void onAnimationStart(Animator animator)
                {

                }

                @Override
                public void onAnimationEnd(Animator animator)
                {
                    fullAnimSet.start();
                }

                @Override
                public void onAnimationCancel(Animator animator)
                {

                }

                @Override
                public void onAnimationRepeat(Animator animator)
                {

                }
            });
        }
        return fullAnimSet;
    }

    public static void playWormAnimation(final View view)
    {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(ObjectAnimator.ofFloat(view, "scaleY", 1f, 1.1f, 0.2f, 0.6f, 0.5f, 0.5f, 0.5f, 0.5f, 1f), ObjectAnimator.ofFloat(view, "scaleX", 1f, 1.1f, 0.2f, 0.6f, 0.5f, 0.5f, 0.5f, 0.5f, 1f));
        set.setDuration(1000);
        set.setStartDelay(1000);
        set.setInterpolator(new AccelerateInterpolator());
        set.addListener(new Animator.AnimatorListener()
        {
            @Override
            public void onAnimationStart(Animator animator)
            {

            }

            @Override
            public void onAnimationEnd(Animator animator)
            {
                playWormAnimation(view);
            }

            @Override
            public void onAnimationCancel(Animator animator)
            {

            }

            @Override
            public void onAnimationRepeat(Animator animator)
            {

            }
        });
        set.start();
    }

    public static AnimatorSet fade(final boolean isFadeIn, final View view, final int duration, final Animator.AnimatorListener animatorListener)
    {
        AnimatorSet set = new AnimatorSet();
        float alphaStart = isFadeIn == true ? 0f : 1f;
        float alphaEnd = isFadeIn == true ? 1f : 0f;
        set.play(ObjectAnimator.ofFloat(view, "alpha", alphaStart, alphaEnd));
        set.setDuration(duration);
        set.setInterpolator(new AccelerateDecelerateInterpolator());

        if (animatorListener != null)
        {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet flexiPulseAnimation(final View view, int duration, TimeInterpolator timeInterpolator)
    {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(ObjectAnimator.ofFloat(view, "scaleY", 1, 1.1f, 1, 1.1f, 1), ObjectAnimator.ofFloat(view, "scaleX", 1, 1.1f, 1, 1.1f, 1));

        set.setDuration(duration);
        if (timeInterpolator != null)
        {
            set.setInterpolator(timeInterpolator);
        }
        return set;
    }

    public static AnimatorSet flexiSwingAnimation(final View view, int duration, TimeInterpolator timeInterpolator)
    {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(ObjectAnimator.ofFloat(view, "rotation", 0, 10, -10, 6, -6, 3, -3, 0));

        set.setDuration(duration);
        if (timeInterpolator != null)
        {
            set.setInterpolator(timeInterpolator);
        }
        return set;
    }

    public static AnimatorSet flexiBounceAnimation(final View view, int duration, TimeInterpolator timeInterpolator)
    {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(ObjectAnimator.ofFloat(view, "translationY", view.getTranslationY(), view.getTranslationY(), view.getTranslationY() - 30, view.getTranslationY(), view.getTranslationY() - 15, view.getTranslationY(), view.getTranslationY()));

        set.setDuration(duration);
        if (timeInterpolator != null)
        {
            set.setInterpolator(timeInterpolator);
        }
        return set;
    }

    public static AnimatorSet flexiFlashAnimation(final View view, int duration, TimeInterpolator timeInterpolator)
    {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(ObjectAnimator.ofFloat(view, "alpha", 1, 0, 1, 0, 1));

        set.setDuration(duration);
        if (timeInterpolator != null)
        {
            set.setInterpolator(timeInterpolator);
        }
        return set;
    }

    public static AnimatorSet flexiTadaAnimation(final View view, int duration, TimeInterpolator timeInterpolator)
    {
        AnimatorSet set = new AnimatorSet();
        ObjectAnimator bounce1 = ObjectAnimator.ofFloat(view, "translationY", view.getTranslationY(), view.getTranslationY(), view.getTranslationY() - 30, view.getTranslationY(), view.getTranslationY() - 15, view.getTranslationY(), view.getTranslationY());
        bounce1.setStartDelay(300);
        ObjectAnimator bounce2 = ObjectAnimator.ofFloat(view, "translationY", view.getTranslationY(), view.getTranslationY(), view.getTranslationY() - 30, view.getTranslationY(), view.getTranslationY() - 15, view.getTranslationY(), view.getTranslationY());
        bounce2.setStartDelay(300);

        AnimatorSet tada = new AnimatorSet();
        tada.playTogether(
                ObjectAnimator.ofFloat(view, "scaleX", 1, 0.9f, 0.9f, 1.1f, 1.1f, 1.1f, 1.1f, 1.1f, 1.1f, 1),
                ObjectAnimator.ofFloat(view, "scaleY", 1, 0.9f, 0.9f, 1.1f, 1.1f, 1.1f, 1.1f, 1.1f, 1.1f, 1),
                ObjectAnimator.ofFloat(view, "rotation", 0, -3, -3, 3, -3, 3, -3, 3, -3, 0));

        set.playSequentially(bounce1, bounce2, tada);

        set.setDuration(duration);
        if (timeInterpolator != null)
        {
            set.setInterpolator(timeInterpolator);
        }
        return set;
    }
}
