/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.web_unit_view;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.web_unit_view.ConfigurationView;
import com.kidoz.sdk.api.ui_views.web_unit_view.WebUnitListener;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.json.JSONArray;

public class WebUnitView
extends RelativeLayout {
    private final String TAG = WebUnitView.class.getSimpleName();
    private final String WIDGET_TYPE = "6";
    private WebView mWebView;
    private Context mActivityContext;
    private WebUnitListener mWebUnitListener;
    private boolean mIsContentLoaded;
    private boolean mIsShuldBlockClicks;

    public WebUnitView(Context context) {
        super(context);
        this.initView();
    }

    public WebUnitView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public WebUnitView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public void setActivityContext(Context context) {
        this.mActivityContext = context;
    }

    public void setWebUnitListener(WebUnitListener webUnitListener) {
        this.mWebUnitListener = webUnitListener;
    }

    public void loadContent() {
        this.mIsContentLoaded = false;
        this.invokeJavaScript("javascript:loadContent()");
    }

    public boolean getIsContentLoaded() {
        return this.mIsContentLoaded;
    }

    public void show() {
        this.setVisibility(0);
        this.invokeJavaScript("focusOn()");
    }

    public void close() {
        this.setVisibility(8);
        this.invokeJavaScript("focusOff()");
    }

    public void test() {
        this.invokeJavaScript("test()");
    }

    private void initView() {
        this.initRootView();
        this.initConfigurationView();
        this.initWebView();
        this.setVisibility(8);
    }

    private void initRootView() {
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
    }

    private void initWebView() {
        this.mWebView = new WebView(this.getContext());
        if (Build.VERSION.SDK_INT >= 17) {
            this.mWebView.getSettings().setMediaPlaybackRequiresUserGesture(true);
        }
        if (Build.VERSION.SDK_INT < 18) {
            this.mWebView.getSettings().setPluginState(WebSettings.PluginState.ON);
        }
        if (Build.VERSION.SDK_INT > 22) {
            this.mWebView.setLayerType(2, null);
        } else {
            this.mWebView.setLayerType(1, null);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.mWebView.getSettings().setMixedContentMode(0);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.mWebView.getSettings().setMixedContentMode(0);
        }
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.setDrawingCacheBackgroundColor(0);
        this.mWebView.setBackgroundColor(0);
        this.mWebView.setWebChromeClient(new WebChromeClient());
        this.mWebView.setWebViewClient(new WebViewClient());
        this.mWebView.addJavascriptInterface((Object)new WebUnitViewJavaScript(), "WebUnitView");
        this.addView((View)this.mWebView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.mWebView.loadUrl(this.generateHtmlBannerURL());
    }

    private void initConfigurationView() {
        ConfigurationView configurationView = new ConfigurationView(this.getContext(), new ConfigurationView.ConfigurationViewInterface(){

            @Override
            public void onViewVisibilityChanged(boolean isVisible) {
                if (isVisible) {
                    WebUnitView.this.invokeJavaScript("focusOn()");
                } else {
                    WebUnitView.this.invokeJavaScript("focusOff()");
                }
            }
        });
        this.addView(configurationView);
    }

    private String generateHtmlBannerURL() {
        StringBuilder result = new StringBuilder();
        result.append("http://s3.amazonaws.com/kidoz.test.bucket/ronybrosh/test_html_view_builder/WebUnitView.html");
        result.append("?");
        result.append("publisher_id=");
        result.append(KidozSDK.getPublisherID());
        result.append("&package_id=");
        result.append(this.getContext().getPackageName());
        result.append("&style_id=");
        result.append("0");
        result.append("&version=");
        result.append("4");
        result.append("&os_version=");
        result.append(Build.VERSION.SDK_INT);
        result.append("&country_code=");
        result.append(Locale.getDefault().getCountry());
        result.append("&hash=");
        result.append(Utils.generateUniqeDeviceID(this.getContext().getPackageName(), KidozSDK.getPublisherID()));
        result.append("&device_lang=");
        result.append(String.valueOf(Locale.getDefault().getLanguage()));
        result.append("&widget_type=");
        result.append("6");
        result.append("&auth_token=");
        result.append(KidozSDK.getAuthToken());
        return result.toString();
    }

    private void invokeJavaScript(String javaScriptMethod) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.mWebView.evaluateJavascript(javaScriptMethod, null);
        } else {
            this.mWebView.loadUrl(javaScriptMethod);
        }
    }

    private final class WebUnitViewJavaScript {
        private WebUnitViewJavaScript() {
        }

        @JavascriptInterface
        public void setViewSize(final String width, final String height, final String xPoint, final String yPoint, final String alignmentFlags) {
            SDKLogger.printDebbugLog(WebUnitView.this.TAG, "setViewSize: width = " + width + ", height = " + height + ", xPoint = " + xPoint + ", yPoint = " + yPoint + ", alignmentFlags = " + alignmentFlags);
            try {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int yPosition;
                            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(Integer.parseInt(width), Integer.parseInt(height));
                            boolean ALIGN_TOP = false;
                            boolean ALIGN_RIGHT = true;
                            int ALIGN_BOTTOM = 2;
                            int ALIGN_LEFT = 3;
                            int CENTER_HORIZONTAL = 4;
                            int CENTER_VERTICAL = 5;
                            int CENTER_IN_PARENT = 6;
                            JSONArray alignmentFlagsArray = new JSONArray(alignmentFlags);
                            if (alignmentFlagsArray != null) {
                                block11: for (int flagIndex = 0; flagIndex < alignmentFlagsArray.length(); ++flagIndex) {
                                    int nextFlag = alignmentFlagsArray.getInt(flagIndex);
                                    switch (nextFlag) {
                                        case 0: {
                                            params.addRule(10);
                                            continue block11;
                                        }
                                        case 1: {
                                            params.addRule(11);
                                            continue block11;
                                        }
                                        case 2: {
                                            params.addRule(12);
                                            continue block11;
                                        }
                                        case 3: {
                                            params.addRule(9);
                                            continue block11;
                                        }
                                        case 4: {
                                            params.addRule(14);
                                            continue block11;
                                        }
                                        case 5: {
                                            params.addRule(15);
                                            continue block11;
                                        }
                                        case 6: {
                                            params.addRule(13);
                                        }
                                    }
                                }
                            }
                            WebUnitView.this.mWebView.setLayoutParams((ViewGroup.LayoutParams)params);
                            int NONE = -1;
                            int xPosition = Integer.parseInt(xPoint);
                            if (xPosition != -1) {
                                WebUnitView.this.mWebView.setX((float)xPosition);
                            }
                            if ((yPosition = Integer.parseInt(yPoint)) != -1) {
                                WebUnitView.this.mWebView.setY((float)yPosition);
                            }
                        }
                        catch (Exception ex) {
                            SDKLogger.printErrorLog(WebUnitView.this.TAG, "Error when trying to setViewSize: " + ex.getMessage());
                        }
                    }
                });
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(WebUnitView.this.TAG, "Error setting webview size: " + ex.getMessage());
            }
        }

        @JavascriptInterface
        public void onContentLoaded() {
            WebUnitView.this.mIsContentLoaded = true;
            if (WebUnitView.this.mWebUnitListener != null) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        WebUnitView.this.mWebUnitListener.onWebUnitContentLoaded();
                    }
                });
            }
        }

        @JavascriptInterface
        public void simulateClick(final String contentItemJson, final String positionIndex, final String styleID) {
            if (WebUnitView.this.mWebUnitListener != null) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ContentItem item = null;
                            JSONArray jsonArray = new JSONArray(contentItemJson);
                            if (jsonArray != null && jsonArray.length() > 1) {
                                JSONArray keysArray = jsonArray.getJSONArray(0);
                                LinkedHashMap<String, Integer> keysMap = new LinkedHashMap<String, Integer>();
                                if (keysArray != null && keysArray.length() > 0) {
                                    for (int i = 0; i < keysArray.length(); ++i) {
                                        keysMap.put(keysArray.getString(i), i);
                                    }
                                }
                                if (!keysMap.isEmpty() && jsonArray.getJSONArray(1) != null) {
                                    item = new ContentItem(jsonArray.getJSONArray(1), keysMap);
                                }
                            }
                            if (item != null && !WebUnitView.this.mIsShuldBlockClicks) {
                                WebUnitView.this.mIsShuldBlockClicks = true;
                                if (WebUnitView.this.mActivityContext != null) {
                                    ContentExecutionHandler.handleContentItemClick(WebUnitView.this.mActivityContext, item, "6", styleID, Integer.parseInt(positionIndex), true, new ContentExecutionHandler.IOnHandleClickListener(){

                                        @Override
                                        public void onRestoreClick() {
                                            WebUnitView.this.mIsShuldBlockClicks = false;
                                        }
                                    });
                                }
                            }
                        }
                        catch (Exception ex) {
                            SDKLogger.printDebbugLog(WebUnitView.this.TAG, "Error when trying to simulate click: " + ex.getMessage());
                        }
                    }
                });
            }
        }

        @JavascriptInterface
        public void forwardToGooglePlay(final String advertiserID, final String appID, final String googlePlayLink, final String widgetType, final String styleID, final String itemIndex) {
            SDKLogger.printDebbugLog(WebUnitView.this.TAG, "forwardToGooglePlay: advertiserID = " + advertiserID + ", appID = " + appID + ", googlePlayLink = " + googlePlayLink + ", widgetType = " + widgetType + ", styleID = " + styleID + ", itemIndex = " + itemIndex);
            if (WebUnitView.this.mActivityContext != null) {
                try {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            int itemIndexAsInteger = 0;
                            try {
                                itemIndexAsInteger = Integer.parseInt(itemIndex);
                            }
                            catch (Exception ex) {
                                SDKLogger.printErrorLog(WebUnitView.this.TAG, "Error when trying to parse item index: " + ex.getMessage());
                            }
                            ContentItem contentItem = new ContentItem();
                            contentItem.setId(appID);
                            contentItem.setName("");
                            contentItem.setData(googlePlayLink);
                            contentItem.setContentType(ContentType.PROMOTED_PLAY_APPLICATION);
                            contentItem.setAdvertiserID(advertiserID);
                            contentItem.setIsPromoted(true);
                            ContentExecutionHandler.handleContentItemClick(WebUnitView.this.mActivityContext, contentItem, widgetType, styleID, itemIndexAsInteger, false, null);
                        }
                    });
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(WebUnitView.this.TAG, "Error when trying to forward to google play: " + ex.getMessage());
                }
            }
        }
    }
}

