/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.video_unit;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.view.View;
import android.view.ViewGroup;
import com.kidoz.sdk.api.fullscreen_video_layer.FullScreenVideoEnabledWebView;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.video_unit.VideoUnit;

public class VideoUnitActivity
extends Activity {
    private final String TAG = VideoUnitActivity.class.getSimpleName();
    public static VideoUnitActivityListener sVideoUnitActivityListener;
    private FullScreenVideoEnabledWebView mWebView;
    private BroadcastReceiver mBroadcastReceiver;

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initActivity();
        this.setContentView((View)this.mWebView, (ViewGroup.LayoutParams)new ViewGroup.MarginLayoutParams(-1, -1));
        this.invokeJavaScript("javascript:onWidgetOpen();");
        if (VideoUnit.sVideoUnitListener != null) {
            VideoUnit.sVideoUnitListener.onOpen();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.invokeJavaScript("javascript:onWidgetClose();");
        if (VideoUnit.sVideoUnitListener != null) {
            VideoUnit.sVideoUnitListener.onClose();
        }
        sVideoUnitActivityListener = null;
    }

    protected void onResume() {
        super.onResume();
        this.initFullScreenFlags();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mBroadcastReceiver, new IntentFilter("CloseVideoUnit"));
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mBroadcastReceiver, new IntentFilter("WebPlayerDialogClosed"));
        this.mWebView.bringToFront();
        this.invokeJavaScript("javascript:onWidgetResume();");
    }

    protected void onPause() {
        super.onPause();
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mBroadcastReceiver);
        this.invokeJavaScript("javascript:onWidgetPause();");
    }

    private void initActivity() {
        this.initFullScreenFlags();
        this.initWebView();
        this.initBroadcastReceiver();
        this.initVideoUnitActivityListener();
    }

    private void initVideoUnitActivityListener() {
        sVideoUnitActivityListener = new VideoUnitActivityListener(){

            @Override
            public void forwardToGooglePlay(final String advertiserID, final String appID, final String googlePlayLink, final String widgetType, final String styleID, final String itemIndex) {
                VideoUnitActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        int itemIndexAsInteger = 0;
                        try {
                            itemIndexAsInteger = Integer.parseInt(itemIndex);
                        }
                        catch (Exception ex) {
                            SDKLogger.printErrorLog(VideoUnitActivity.this.TAG, "Error when trying to parse item index: " + ex.getMessage());
                        }
                        ContentItem contentItem = new ContentItem();
                        contentItem.setId(appID);
                        contentItem.setName("");
                        contentItem.setData(googlePlayLink);
                        contentItem.setContentType(ContentType.PROMOTED_PLAY_APPLICATION);
                        contentItem.setAdvertiserID(advertiserID);
                        contentItem.setIsPromoted(true);
                        ContentExecutionHandler.handleContentItemClick((Context)VideoUnitActivity.this, contentItem, widgetType, styleID, itemIndexAsInteger, false, null);
                    }
                });
            }
        };
    }

    private void initWebView() {
        this.mWebView = VideoUnit.mWebView;
        if (this.mWebView.getParent() != null) {
            ((ViewGroup)this.mWebView.getParent()).removeView((View)this.mWebView);
        }
        if (Build.VERSION.SDK_INT >= 19 && ConstantDef.DGM) {
            FullScreenVideoEnabledWebView.setWebContentsDebuggingEnabled((boolean)true);
        }
    }

    private void initBroadcastReceiver() {
        this.mBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent != null) {
                    if (intent.getAction().equals("CloseVideoUnit")) {
                        VideoUnitActivity.this.finish();
                    } else if (intent.getAction().equals("WebPlayerDialogClosed")) {
                        VideoUnitActivity.this.mWebView.bringToFront();
                        VideoUnitActivity.this.invokeJavaScript("javascript:onWidgetResume();");
                    }
                }
            }
        };
    }

    private void initFullScreenFlags() {
        if (Build.VERSION.SDK_INT < 16) {
            this.getWindow().setFlags(1024, 1024);
        } else if (Build.VERSION.SDK_INT < 18) {
            View decorView = this.getWindow().getDecorView();
            int uiOptions = 4;
            decorView.setSystemUiVisibility(uiOptions);
        } else {
            final View decorView = this.getWindow().getDecorView();
            decorView.setSystemUiVisibility(5894);
            decorView.setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(){

                public void onSystemUiVisibilityChange(int visibility) {
                    if ((visibility & 4) == 0) {
                        decorView.setSystemUiVisibility(5894);
                    }
                }
            });
        }
    }

    private void invokeJavaScript(final String javascript) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (Build.VERSION.SDK_INT >= 19) {
                    VideoUnitActivity.this.mWebView.evaluateJavascript(javascript, null);
                } else {
                    VideoUnitActivity.this.mWebView.loadUrl(javascript);
                }
            }
        });
    }

    public static interface VideoUnitActivityListener {
        public void forwardToGooglePlay(String var1, String var2, String var3, String var4, String var5, String var6);
    }
}

