/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.video_unit;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Looper;
import android.support.v4.content.LocalBroadcastManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.kidoz.events.DeviceUtils;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.fullscreen_video_layer.FullScreenVideoEnabledWebChromeClient;
import com.kidoz.sdk.api.fullscreen_video_layer.FullScreenVideoEnabledWebView;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.video_unit.VideoUnitActivity;
import java.util.Locale;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class VideoUnit {
    public static final String TAG = VideoUnit.class.getSimpleName();
    private Context mContext;
    public static FullScreenVideoEnabledWebView mWebView;
    private Utils.StaticHandler mExecutionHandler = new Utils.StaticHandler(Looper.getMainLooper());
    public static VideoUnitListener sVideoUnitListener;
    private String mStyleID = "";
    private String mWidgetType = WidgetType.WIDGET_TYPE_VIDEO_UNIT.getStringValue();
    private boolean mIsCanShow = false;

    public VideoUnit(Context context) {
        SDKLogger.printDebbugLog(TAG, "VideoUnit");
        this.mContext = context;
        this.load();
    }

    public void setVideoUnitListener(VideoUnitListener videoUnitListener) {
        sVideoUnitListener = videoUnitListener;
    }

    public boolean getIsReady() {
        boolean isKidozInitialised = KidozSDK.isInitialised();
        SDKLogger.printDebbugLog(TAG, "getIsReady: isKidozInitialised = " + Boolean.toString(isKidozInitialised));
        SDKLogger.printDebbugLog(TAG, "getIsReady: mIsCanShow = " + Boolean.toString(this.mIsCanShow));
        return this.mIsCanShow && isKidozInitialised;
    }

    public void load() {
        SDKLogger.printDebbugLog(TAG, "load");
        if (KidozSDK.isInitialised()) {
            this.initVideoUnit();
        } else if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    public void show() {
        SDKLogger.printDebbugLog(TAG, "show");
        Intent intent = new Intent(this.mContext, VideoUnitActivity.class);
        intent.addFlags(0x30020000);
        this.mContext.startActivity(intent);
    }

    private void initVideoUnit() {
        SDKLogger.printDebbugLog(TAG, "initVideoUnit");
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        this.initWebView();
    }

    private void initWebView() {
        String[] tempVal;
        int index;
        String sub;
        String[] res;
        SDKLogger.printDebbugLog(TAG, "initWebView");
        mWebView = new FullScreenVideoEnabledWebView(this.mContext);
        mWebView.initWebViewSettings();
        mWebView.addJavascriptInterface(new VideoUnitJavascriptInterface(), "VideoUnit");
        StringBuilder stringBuilder = new StringBuilder();
        PropertiesObj propertiesObj = DatabaseManager.getInstance(this.mContext).getConfigTable().loadAppProperties();
        if (propertiesObj != null) {
            String videoUnitURL = propertiesObj.getVideoUnitURL();
            if (!videoUnitURL.contains("?")) {
                videoUnitURL = videoUnitURL + "?";
            }
            stringBuilder.append(videoUnitURL);
        }
        String appVersionCode = "";
        String appVersionName = "";
        try {
            PackageManager packageManager = this.mContext.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
            appVersionCode = String.valueOf(packageInfo.versionCode);
            appVersionName = packageInfo.versionName;
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to get app version name and code: " + ex.getMessage());
        }
        stringBuilder.append("app_version_code=" + appVersionCode);
        stringBuilder.append("&app_version_name=" + appVersionName);
        stringBuilder.append("&publisher_id=" + KidozSDK.getPublisherID());
        stringBuilder.append("&device_lang=" + Locale.getDefault().getLanguage());
        stringBuilder.append("&style_id=" + this.mStyleID);
        stringBuilder.append("&actual_sdk_version=" + String.valueOf("0.6.0"));
        stringBuilder.append("&extension_type=" + String.valueOf(ConstantDef.SDK_EXTENSION_TYPE));
        stringBuilder.append("&package_id=" + this.mContext.getPackageName());
        stringBuilder.append("&sdk_version=4");
        stringBuilder.append("&os_version=" + Build.VERSION.SDK_INT);
        stringBuilder.append("&os_type=android");
        if (Utils.getIsDeviceTablet(this.mContext)) {
            stringBuilder.append("&device_type=2");
        } else {
            stringBuilder.append("&device_type=1");
        }
        String webviewVersion = "w";
        String useragent = Utils.getDefaultUserAgent();
        if (useragent != null && useragent.contains("Chrome") && (res = (sub = useragent.substring(index = useragent.indexOf("Chrome"), useragent.length())).split(" ")) != null && res.length > 0 && (tempVal = res[0].split("/")) != null && tempVal.length > 1) {
            webviewVersion = "c_" + tempVal[1];
        }
        stringBuilder.append("&webview_version=" + webviewVersion);
        stringBuilder.append("&device_hash=" + Utils.generateUniqeDeviceID(this.mContext.getPackageName(), KidozSDK.getPublisherID()));
        stringBuilder.append("&widget_type=" + this.mWidgetType);
        stringBuilder.append("&auth_token=" + KidozSDK.getAuthToken());
        stringBuilder.append("&gid=" + DeviceUtils.getGoogleAdvertisingID(this.mContext));
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences("events_shared_preferences", 0);
        long appSessionID = sharedPreferences.getLong("last_session_id", 0L);
        stringBuilder.append("&appSessionID=" + appSessionID);
        mWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                SDKLogger.printDebbugLog(TAG, "shouldOverrideUrlLoading: URL = " + url);
                return true;
            }
        });
        FullScreenVideoEnabledWebChromeClient webChromeClient = new FullScreenVideoEnabledWebChromeClient(null, null, null, mWebView){};
        webChromeClient.setOnToggledFullscreen(new FullScreenVideoEnabledWebChromeClient.ToggledFullscreenCallback(){

            @Override
            public void toggledFullscreen(boolean fullscreen) {
            }
        });
        mWebView.setWebChromeClient(webChromeClient);
        mWebView.loadUrl(stringBuilder.toString());
        SDKLogger.printDebbugLog(TAG, "initWebView URL = " + stringBuilder.toString());
    }

    @Subscribe
    public void onHandleEvent(EventMessage event) {
        SDKLogger.printDebbugLog(TAG, "onHandleEvent");
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK) {
            if (EventBus.getDefault().isRegistered((Object)this)) {
                EventBus.getDefault().unregister((Object)this);
            }
            this.initVideoUnit();
        }
    }

    public static interface VideoUnitListener {
        public void onReady();

        public void onOpen();

        public void onClose();
    }

    public class VideoUnitJavascriptInterface {
        @JavascriptInterface
        public void onVideoUnitReady() {
            SDKLogger.printDebbugLog(TAG, "onVideoUnitReady");
            VideoUnit.this.mIsCanShow = true;
            if (sVideoUnitListener != null) {
                VideoUnit.this.mExecutionHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        sVideoUnitListener.onReady();
                    }
                });
            }
        }

        @JavascriptInterface
        public void onCloseVideoUnit() {
            Intent intent = new Intent();
            intent.setAction("CloseVideoUnit");
            LocalBroadcastManager.getInstance((Context)VideoUnit.this.mContext).sendBroadcast(intent);
        }

        @JavascriptInterface
        public void forwardToGooglePlay(final String advertiserID, final String appID, final String googlePlayLink, final String widgetType, final String styleID, final String itemIndex) {
            VideoUnit.this.mExecutionHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (VideoUnitActivity.sVideoUnitActivityListener != null) {
                        VideoUnitActivity.sVideoUnitActivityListener.forwardToGooglePlay(advertiserID, appID, googlePlayLink, widgetType, styleID, itemIndex);
                    }
                }
            });
        }
    }
}

