/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.panel_view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.PanelView;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.custom_drawables.ShadowView;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.one_item_view.OneItemFamilyView;
import com.kidoz.sdk.api.ui_views.panel_view.AbstractPanelView;
import com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;
import java.util.ArrayList;
import org.json.JSONObject;

public class FamilyPanelView
extends AbstractPanelView {
    public static final float ITEM_WIDTH = 660.0f;
    public static final float ITEM_HEIGHT = 420.0f;
    public static final String TAG = FamilyPanelView.class.getSimpleName();
    private static final int DEFAULT_CORNER_RADIUS = 4;
    protected int mBtnAnimType = 1;
    protected AssetView mNextButton;
    protected AssetView mGifView;
    protected int mViewPagerWidth;
    protected int mViewPagerHeight;
    public static final String MAIN_ANIMATION_URL = "animUrl";
    public static final String MAIN_ANIMATION_URL_NEW = "animUrlNew";
    public static final String NEXT_BTN_URL = "nextBtnUrl";
    public static final String NEXT_BTN_RATIO = "nextBtnRatio";
    public static final String NEXT_BTN_ANIMATION_TYPE = "nextBtnAnimType";
    public static final String HTML_MAXIMIZE_BTN = "htmlMaximizeBtn";
    public static final String SWAP_CONTENT_REFRESH_RATE_SECONDS = "swapContentRefreshRateSec";

    public FamilyPanelView(Context context, JSONObject jsonObject) {
        super(context, jsonObject);
        float SCALE_FACTOR = ScreenUtils.getScaleFactor(this.getContext());
        this.mViewPagerWidth = (int)(660.0f * SCALE_FACTOR);
        this.mViewPagerHeight = (int)(420.0f * SCALE_FACTOR);
    }

    @Override
    protected void prepareProperties() {
        super.prepareProperties();
        this.mBtnAnimType = this.mWidgetProperties.optInt(NEXT_BTN_ANIMATION_TYPE, 1);
    }

    @Override
    protected void initInnerPanelView() {
        this.mOneItemFamilyView = new OneItemFamilyView(this.getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), this.mStyleId, this.mWidgetProperties, new OneItemFamilyView.IOnOneItemActionListener(){

            @Override
            public void onAction(OneItemFamilyView.OneItemAction action) {
                switch (action) {
                    case STOP_ANY_ANIMATION: {
                        FamilyPanelView.this.mGifView.stopGifAnim();
                        break;
                    }
                    case RESTART_ANY_ANIMATION: {
                        FamilyPanelView.this.mGifView.startGifAnim();
                        break;
                    }
                    case ON_RESET_AUTO_LAUNCH: {
                        FamilyPanelView.this.getStaticHandler().removeCallbacksAndMessages(null);
                    }
                }
            }
        });
        this.mOneItemFamilyView.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        params.setMargins(0, Utils.dpTOpx(this.getContext(), 2.0f), 0, Utils.dpTOpx(this.getContext(), -2.0f));
        this.mInnerContainer.addView((View)this.mOneItemFamilyView, (ViewGroup.LayoutParams)params);
        this.mOneItemFamilyView.setViewPagerItemClickListener(new ItemViewPagerAdapter.ViewPagerItemClickListener(){

            @Override
            public void onClickEnd(ContentItem contentItem, int position) {
                if (FamilyPanelView.this.mAllowClickHandling) {
                    FamilyPanelView.this.mAllowClickHandling = false;
                    ContentExecutionHandler.handleContentItemClick(FamilyPanelView.this.getContext(), contentItem, WidgetType.WIDGET_TYPE_PANEL.getStringValue(), FamilyPanelView.this.mStyleId, position, true, new ContentExecutionHandler.IOnHandleClickListener(){

                        @Override
                        public void onRestoreClick() {
                            FamilyPanelView.this.mAllowClickHandling = true;
                        }
                    });
                }
            }
        });
        this.mOneItemFamilyView.setOnRefreshDrawRequestListener(new OneItemFamilyView.IOnRefreshListener(){

            @Override
            public void onRefreshDrawRequest() {
                FamilyPanelView.this.mPanelHandle.bringToFront();
                FamilyPanelView.this.mPanelHandle.requestFocus();
            }
        });
        this.initNextButton();
        this.initAnimationView();
    }

    private void initNextButton() {
        this.mNextButton = new AssetView(this.getContext());
        this.mNextButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mNextButton.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -1);
        this.mInnerContainer.addView((View)this.mNextButton, (ViewGroup.LayoutParams)params);
        this.mNextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FamilyPanelView.this.mNextButton.setClickable(false);
                GenAnimator.clickItemAnimation(v, 80, new GenAnimator.ViewAnimationListener(){

                    @Override
                    public void onAnimationEnd() {
                        FamilyPanelView.this.mNextButton.setClickable(true);
                        FamilyPanelView.this.mOneItemFamilyView.nextPagerItem();
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });
        this.mNextButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mWidgetProperties.optString(NEXT_BTN_URL, null)), null);
    }

    private void initAnimationView() {
        this.mGifView = new AssetView(this.getContext());
        this.mGifView.setId(Utils.generateViewId());
        this.mGifView.setScaleType(ImageView.ScaleType.FIT_END);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.setMargins(0, 0, 0, Utils.dpTOpx(this.getContext(), 4.0f));
        this.mInnerContainer.addView((View)this.mGifView, (ViewGroup.LayoutParams)params);
        this.mGifView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        this.loadAnimation();
    }

    @Override
    protected void initPanelViewsRules() {
        int button = Utils.dpTOpx(this.getContext(), 30.0f);
        int overallWidth = (int)((double)this.mViewPagerWidth * 1.5 + (double)button);
        RelativeLayout.LayoutParams panelInnerContainerParamas = new RelativeLayout.LayoutParams(-2, -2);
        panelInnerContainerParamas.width = overallWidth;
        int margin = Utils.dpTOpx(this.getContext(), 4.0f);
        this.mInnerContainer.setPadding(0, margin, 0, margin);
        this.mInnerContainer.setLayoutParams((ViewGroup.LayoutParams)panelInnerContainerParamas);
        RelativeLayout.LayoutParams oneItemParams = (RelativeLayout.LayoutParams)this.mOneItemFamilyView.getLayoutParams();
        oneItemParams.width = this.mViewPagerWidth;
        oneItemParams.height = this.mViewPagerHeight;
        ((RelativeLayout.LayoutParams)this.mOneItemFamilyView.getLayoutParams()).addRule(0, this.mNextButton.getId());
        RelativeLayout.LayoutParams animationParams = new RelativeLayout.LayoutParams(-1, -1);
        animationParams.addRule(0, this.mOneItemFamilyView.getId());
        animationParams.addRule(6, this.mOneItemFamilyView.getId());
        animationParams.addRule(8, this.mOneItemFamilyView.getId());
        this.mGifView.setLayoutParams((ViewGroup.LayoutParams)animationParams);
        RelativeLayout.LayoutParams nextButtonParams = new RelativeLayout.LayoutParams(Utils.dpTOpx(this.getContext(), 30.0f), -1);
        this.mNextButton.setLayoutParams((ViewGroup.LayoutParams)nextButtonParams);
        nextButtonParams.addRule(11);
        nextButtonParams.addRule(6, this.mOneItemFamilyView.getId());
        nextButtonParams.addRule(8, this.mOneItemFamilyView.getId());
        RelativeLayout.LayoutParams bottomBarParams = (RelativeLayout.LayoutParams)this.mBottomBarContainer.getLayoutParams();
        bottomBarParams.width = overallWidth;
        bottomBarParams.addRule(3, this.mOneItemFamilyView.getId());
        RelativeLayout.LayoutParams shadowParams = new RelativeLayout.LayoutParams(-1, -1);
        this.mShadowView.setLayoutParams((ViewGroup.LayoutParams)shadowParams);
        shadowParams.addRule(5, this.mInnerContainer.getId());
        shadowParams.addRule(7, this.mInnerContainer.getId());
        shadowParams.addRule(6, this.mInnerContainer.getId());
        shadowParams.addRule(8, this.mInnerContainer.getId());
        RelativeLayout.LayoutParams handleParams = new RelativeLayout.LayoutParams(-2, -2);
        this.mPanelHandle.setLayoutParams((ViewGroup.LayoutParams)handleParams);
        this.mPoweredByTextView.setVisibility(0);
        this.mShadowView.setVisibility(4);
        int shadowMargin = Utils.dpTOpx(this.getContext(), 10.0f);
        switch (this.mPanelType) {
            case TOP: {
                panelInnerContainerParamas.addRule(10);
                handleParams.addRule(3, this.mInnerContainer.getId());
                shadowParams.bottomMargin = -shadowMargin;
                break;
            }
            case BOTTOM: {
                panelInnerContainerParamas.addRule(12);
                handleParams.addRule(2, this.mInnerContainer.getId());
                shadowParams.topMargin = -shadowMargin;
            }
        }
        margin = Utils.dpTOpx(this.getContext(), 6.0f);
        switch (this.mHandlePosition) {
            case CENTER: {
                handleParams.addRule(14);
                panelInnerContainerParamas.addRule(14);
                shadowParams.leftMargin = -shadowMargin;
                shadowParams.rightMargin = -shadowMargin;
                break;
            }
            case END: {
                handleParams.addRule(7, this.mInnerContainer.getId());
                handleParams.rightMargin = margin;
                panelInnerContainerParamas.addRule(11);
                shadowParams.leftMargin = -shadowMargin;
                break;
            }
            default: {
                handleParams.addRule(5, this.mInnerContainer.getId());
                handleParams.leftMargin = margin;
                panelInnerContainerParamas.addRule(9);
                shadowParams.rightMargin = -shadowMargin;
            }
        }
        this.mShadowView.setConfiguration(this.mPanelType, this.mHandlePosition);
    }

    @Override
    protected void setContentAndRefresh(ArrayList<ContentItem> content) {
        if (content != null && !content.isEmpty()) {
            this.mOneItemFamilyView.setContent(content);
        }
    }

    @Override
    protected void onContentDataLoadStarted() {
    }

    @Override
    protected void onContentDataLoadEnded() {
    }

    @Override
    protected void onContentDataLoadFailed() {
    }

    @Override
    protected void clearPanelContent() {
        this.mOneItemFamilyView.clearContent();
    }

    @Override
    protected void setShowable(boolean showable) {
        this.mOneItemFamilyView.setIsAllowShowable(showable);
    }

    @Override
    protected void invokeViewAction(int itemIndex) {
        this.mOneItemFamilyView.invokeViewAction(itemIndex);
    }

    @Override
    protected void onExpandPanelAnimationStarted() {
        super.onExpandPanelAnimationStarted();
        this.mOneItemFamilyView.invokeWidgetOpen();
        this.mShadowView.setVisibility(0);
        this.mOneItemFamilyView.setVisibility(0);
        this.startHandlers();
    }

    @Override
    protected void onCollapsePanelAnimationEnded() {
        super.onCollapsePanelAnimationEnded();
        this.mShadowView.setVisibility(4);
        this.mOneItemFamilyView.setVisibility(4);
        this.mOneItemFamilyView.stopAnyPlaybackAction(true);
        this.mOneItemFamilyView.invokeWidgetClose();
        this.stopHandlers();
    }

    @Override
    protected void initShadowView() {
        this.mShadowView = new ShadowView(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.mContainer.addView((View)this.mShadowView, (ViewGroup.LayoutParams)params);
    }

    @Override
    protected void initBottomBar() {
        super.initBottomBar();
    }

    @Override
    public void setPanelColor(int color) {
        super.setPanelColor(color);
        if (this.mInnerContainer != null) {
            this.setFamilyColorAndShape(this.mPanelType, this.mHandlePosition, this.mPanelBgColor);
        }
    }

    private void setFamilyColorAndShape(PANEL_TYPE panelType, HANDLE_POSITION handlePosition, int color) {
        GradientDrawable shape = new GradientDrawable();
        shape.setColor(color);
        float cornerRadius = Utils.dpTOpx(this.getContext(), 4.0f);
        block0 : switch (panelType) {
            case TOP: {
                switch (handlePosition) {
                    case CENTER: {
                        shape.setCornerRadii(new float[]{0.0f, 0.0f, 0.0f, 0.0f, cornerRadius, cornerRadius, cornerRadius, cornerRadius});
                        break block0;
                    }
                    case END: {
                        shape.setCornerRadii(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, cornerRadius, cornerRadius});
                        break block0;
                    }
                }
                shape.setCornerRadii(new float[]{0.0f, 0.0f, 0.0f, 0.0f, cornerRadius, cornerRadius, 0.0f, 0.0f});
                break;
            }
            default: {
                switch (handlePosition) {
                    case CENTER: {
                        shape.setCornerRadii(new float[]{cornerRadius, cornerRadius, cornerRadius, cornerRadius, 0.0f, 0.0f, 0.0f, 0.0f});
                        break block0;
                    }
                    case END: {
                        shape.setCornerRadii(new float[]{cornerRadius, cornerRadius, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f});
                        break block0;
                    }
                }
                shape.setCornerRadii(new float[]{0.0f, 0.0f, cornerRadius, cornerRadius, 0.0f, 0.0f, 0.0f, 0.0f});
            }
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.mInnerContainer.setBackground((Drawable)shape);
        } else {
            this.mInnerContainer.setBackgroundDrawable((Drawable)shape);
        }
    }

    private void loadAnimation() {
        if (this.mGifView != null) {
            this.mGifView.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mWidgetProperties.optString(MAIN_ANIMATION_URL_NEW, null)), new AssetView.IOnAssetLoadedListener(){

                @Override
                public void onAssetLoaded(boolean successful) {
                    if (!successful) {
                        FamilyPanelView.this.mGifView.loadAsset(AssetUtil.getAssetFile(FamilyPanelView.this.getContext(), FamilyPanelView.this.mWidgetProperties.optString(FamilyPanelView.MAIN_ANIMATION_URL, null)), null);
                    }
                }
            });
        }
    }

    public static boolean parseFamilyPanelData(Context context, JSONObject jsonObject) {
        boolean result = false;
        if (jsonObject != null) {
            try {
                jsonObject.put(PanelView.TAG, (Object)TAG);
                JSONObject oldData = DatabaseManager.getInstance(context).getConfigTable().loadProperties(PanelView.TAG);
                AssetUtil.loadAsset(context, oldData, jsonObject, "btnOpenDefaultSponsoredUrl");
                AssetUtil.loadAsset(context, oldData, jsonObject, "btnOpenedUrl");
                AssetUtil.loadAsset(context, oldData, jsonObject, "btnClosedUrl");
                AssetUtil.loadAsset(context, oldData, jsonObject, "contentItemHandleBtnOpenUrl");
                AssetUtil.loadAsset(context, oldData, jsonObject, MAIN_ANIMATION_URL_NEW);
                AssetUtil.loadAsset(context, oldData, jsonObject, MAIN_ANIMATION_URL);
                result = AssetUtil.loadAsset(context, oldData, jsonObject, NEXT_BTN_URL);
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, HTML_MAXIMIZE_BTN);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, "btnUnlockUrl");
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, "btnLockUrl");
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, "kidozIcon");
                }
                if (result) {
                    DatabaseManager.getInstance(context).getConfigTable().insertProperties(PanelView.TAG, jsonObject);
                }
            }
            catch (Exception ex) {
                result = false;
                SDKLogger.printErrorLog(PanelView.TAG, "Error when trying to parse kidoz FamilyPanelView properties" + ex.getMessage());
            }
        }
        return result;
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.startHandlers();
        } else {
            this.stopHandlers();
        }
    }

    @Override
    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.mOneItemFamilyView != null && !this.mOneItemFamilyView.isEmpty()) {
            if (visibility == 0) {
                this.startHandlers();
            } else {
                this.stopHandlers();
            }
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.pauseAction(true);
    }

    private void stopHandlers() {
        this.mOneItemFamilyView.stopAutoScroll();
    }

    private void startHandlers() {
        this.stopHandlers();
        if (this.getIsPanelViewExpanded()) {
            this.mOneItemFamilyView.startAutoScroll();
        }
    }

    public void resumeAction(boolean resume) {
        if (this.mOneItemFamilyView != null && resume) {
            this.mOneItemFamilyView.resumePlaybackAction();
        }
    }

    public void pauseAction(boolean withFocusOff) {
        if (this.mOneItemFamilyView != null) {
            this.mOneItemFamilyView.stopAnyPlaybackAction(withFocusOff);
        }
        if (this.mGifView != null) {
            this.mGifView.stopGifAnim();
        }
    }
}

