/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.panel_view;

import android.animation.Animator;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Looper;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.events.Event;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.dialogs.AboutKidozDialog;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.ContentLogicLoader;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.CookieManager;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.interfaces.IOnPanelViewEventListener;
import com.kidoz.sdk.api.picasso_related.RoundedTransformation;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.custom_drawables.ShadowView;
import com.kidoz.sdk.api.ui_views.interstitial.LocalIntrst;
import com.kidoz.sdk.api.ui_views.one_item_view.OneItemFamilyView;
import com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.kidoz.sdk.api.ui_views.panel_view.PanelHandle;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;
import java.util.ArrayList;
import org.json.JSONObject;

public abstract class AbstractPanelView
extends RelativeLayout {
    private static final String PANEL_SHARED_PREFERENCES = "panel_shared_pref";
    private static final String FIRST_TIME_LAST_LOUNCH_KEY = "fistTimeLastLounch";
    protected static final int DEFAULT_SHADOW_LINE_SIZE = 3;
    private static final int TIME_MULT_FACTOR = 3600000;
    protected PANEL_TYPE mPanelType = PANEL_TYPE.BOTTOM;
    protected HANDLE_POSITION mHandlePosition = HANDLE_POSITION.START;
    protected RelativeLayout mContainer;
    protected RelativeLayout mInnerContainer;
    protected ContentLogicLoader mContentLogicLoader;
    protected ArrayList<ContentItem> mContentItems = new ArrayList();
    protected AssetView mParentalLockButton;
    protected AssetView mAboutKidozButton;
    protected PanelHandle mPanelHandle;
    protected TextView mPoweredByTextView;
    protected RelativeLayout mBottomBarContainer;
    protected OneItemFamilyView mOneItemFamilyView;
    protected IOnPanelViewEventListener mIOnPanelViewEventListener;
    protected boolean mIsOpen;
    protected boolean mIsAnimationRunning;
    protected boolean mIsClicksBlocked;
    protected boolean mAllowClickHandling = true;
    protected boolean mIsPanelPrepared = false;
    protected boolean mIsAllowThumbChange = false;
    private long mLastInterceptTS = 0L;
    protected ShadowView mShadowView;
    protected LinearLayout mShadowLine;
    protected JSONObject mWidgetProperties;
    protected int mAnimType = 1;
    protected String mBtnCloseUrl = null;
    protected String mBtnOpenUrl = null;
    protected String mBtnOpenSposoredUrl = null;
    protected float mBtnScaleSize = 0.15f;
    protected int mPanelBgColor = -1;
    protected String mLabelText = "";
    protected int mLabelColor = -16777216;
    protected float mFirstLounchOpenPeriod = -1.0f;
    protected float mFirstLounchOpenRepeatTimeFarme = -1.0f;
    protected float mFirstLounchStartDelay = -1.0f;
    protected Utils.StaticHandler mStaticHandler;
    protected Utils.StaticHandler mHandleThumbStaticHandler = new Utils.StaticHandler(Looper.getMainLooper());
    protected SharedPreferences mSharedPreferences;
    protected LocalIntrst mInterstitial;
    protected boolean mIsShowFirstItemThumb = false;
    protected float mFirstItemThumbSize = 0.5f;
    protected int mHandleThumbCurrentShownIndex = 0;
    protected int mHandleThumbRefreshRateSec = 12;
    protected int mHandleContentThumbRoundVal = 0;
    protected String mStyleId = null;
    public static final String BTN_OPEN_URL = "btnOpenedUrl";
    public static final String BTN_CLOSE_URL = "btnClosedUrl";
    public static final String DEFAULT_OPEN_BTN_SPOSORED_URL = "btnOpenDefaultSponsoredUrl";
    public static final String BTN_SCALE_SIZE = "btnScaleSize";
    public static final String BTN_ANIMATION_TYPE = "btnAnimType";
    public static final String PANEL_BG_COLOR = "panelBgClr";
    public static final String LABEL_TEXT = "labelText";
    public static final String LABEL_TEXT_COLOR = "labelColor";
    public static final String STYLE_ID = "style_id";
    public static final String OVERRIDE_USER_PROPERTIES = "overrideUserProperties";
    public static final String FIRST_LAUNCH_STAY_OPEN_PERIOD_SECONDS = "flOpenPeriodSec";
    public static final String FIRST_LAUNCH_OPEN_START_DELAY_SECONDS = "flOpenStartDelaySec";
    public static final String FIRST_LAUNCH_OPEN_PANEL_EVEY_X_HOURS = "flOpenEveryXhoursTF";
    public static final String LAUNCH_INTERSTITIAL_ON_OPEN = "lounchInterstitialOnOpen";
    public static final String BTN_LOCK_OPEN = "btnUnlockUrl";
    public static final String BTN_LOCK_CLOSED = "btnLockUrl";
    public static final String THUMBNAIL_BG_COLOR = "thumbBgColor";
    public static final String KIDOZ_LOGO_ICON = "kidozIcon";
    public static final String CIH_SHOW_THUMB_IN_HANDLE = "contentItemHandleThumbShow";
    public static final String CIH_THUMB_SIZE = "contentItemHandleThumbSize";
    public static final String CIH_REFRESH_CYCLE_PERIOD_SECONDS = "contentItemHandleRefreshPeriodSec";
    public static final String CIH_BTN_OPEN_HANDLE_OVERLAY_URL = "contentItemHandleBtnOpenUrl";
    public static final String CIH_ROUND_CORNERS = "contentItemHandleRoundCornersPx";

    public AbstractPanelView(Context context, JSONObject jsonObject) {
        super(context);
        this.mWidgetProperties = jsonObject;
        this.prepareProperties();
        this.initView();
    }

    protected void prepareProperties() {
        String alternativeOpenBtn;
        this.mStyleId = this.mWidgetProperties.optString(STYLE_ID, null);
        this.mAnimType = this.mWidgetProperties.optInt(BTN_ANIMATION_TYPE, 1);
        this.mBtnCloseUrl = this.mWidgetProperties.optString(BTN_CLOSE_URL, null);
        this.mBtnOpenUrl = this.mWidgetProperties.optString(BTN_OPEN_URL, null);
        this.mBtnOpenSposoredUrl = this.mWidgetProperties.optString(DEFAULT_OPEN_BTN_SPOSORED_URL, null);
        this.mBtnScaleSize = (float)this.mWidgetProperties.optDouble(BTN_SCALE_SIZE, (double)0.15f);
        this.mLabelText = this.mWidgetProperties.optString(LABEL_TEXT, "");
        this.mFirstLounchOpenPeriod = (float)this.mWidgetProperties.optDouble(FIRST_LAUNCH_STAY_OPEN_PERIOD_SECONDS, -1.0);
        this.mFirstLounchStartDelay = (float)this.mWidgetProperties.optDouble(FIRST_LAUNCH_OPEN_START_DELAY_SECONDS, -1.0);
        this.mFirstLounchOpenRepeatTimeFarme = (float)this.mWidgetProperties.optDouble(FIRST_LAUNCH_OPEN_PANEL_EVEY_X_HOURS, -1.0);
        boolean bl = this.mIsShowFirstItemThumb = this.mWidgetProperties.optInt(CIH_SHOW_THUMB_IN_HANDLE, 0) == 1;
        if (this.mIsShowFirstItemThumb && (alternativeOpenBtn = this.mWidgetProperties.optString(CIH_BTN_OPEN_HANDLE_OVERLAY_URL, null)) != null && !alternativeOpenBtn.equals("")) {
            this.mBtnOpenUrl = alternativeOpenBtn;
        }
        this.mFirstItemThumbSize = (float)this.mWidgetProperties.optDouble(CIH_THUMB_SIZE, 0.5);
        this.mHandleThumbRefreshRateSec = this.mWidgetProperties.optInt(CIH_REFRESH_CYCLE_PERIOD_SECONDS, 12);
        this.mHandleContentThumbRoundVal = this.mWidgetProperties.optInt(CIH_ROUND_CORNERS, 0);
        try {
            this.mPanelBgColor = Color.parseColor((String)this.mWidgetProperties.optString(PANEL_BG_COLOR, "#FFFFFF"));
        }
        catch (Exception e) {
            this.mPanelBgColor = -1;
        }
        try {
            this.mLabelColor = Color.parseColor((String)this.mWidgetProperties.optString(LABEL_TEXT_COLOR, "#000000"));
        }
        catch (Exception e) {
            this.mLabelColor = -16777216;
        }
        this.mSharedPreferences = this.getContext().getSharedPreferences(PANEL_SHARED_PREFERENCES, 0);
        if (this.mWidgetProperties.optInt(LAUNCH_INTERSTITIAL_ON_OPEN, 0) == 1 && this.mInterstitial == null) {
            this.mInterstitial = new LocalIntrst(this.getContext());
        }
    }

    protected void initView() {
        this.initPanelContainer();
        this.initPanelHandleBtn();
        this.initInnerPanelView();
        this.initBottomBar();
        this.initPanelViewsRules();
        this.initContentLogicLoader();
        this.preparePanel();
    }

    protected abstract void initInnerPanelView();

    protected abstract void initPanelViewsRules();

    protected abstract void initShadowView();

    protected abstract void setContentAndRefresh(ArrayList<ContentItem> var1);

    protected abstract void onContentDataLoadStarted();

    protected abstract void onContentDataLoadEnded();

    protected abstract void onContentDataLoadFailed();

    protected abstract void clearPanelContent();

    protected abstract void setShowable(boolean var1);

    protected abstract void invokeViewAction(int var1);

    private void initPanelContainer() {
        this.mContainer = new RelativeLayout(this.getContext());
        this.mContainer.setBackgroundColor(0);
        this.mContainer.setId(Utils.generateViewId());
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.initShadowView();
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        this.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
        this.mInnerContainer = new RelativeLayout(this.getContext());
        this.mInnerContainer.setId(Utils.generateViewId());
        this.mInnerContainer.setBackgroundColor(-1);
        params = new RelativeLayout.LayoutParams(-1, -2);
        this.mContainer.addView((View)this.mInnerContainer, (ViewGroup.LayoutParams)params);
        this.mInnerContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        this.mInnerContainer.setSoundEffectsEnabled(false);
    }

    private void initPanelHandleBtn() {
        Point point = Utils.getScreenSize(this.getContext());
        int size = (int)((float)Math.min(point.x, point.y) * this.mBtnScaleSize);
        this.mPanelHandle = new PanelHandle(this.getContext(), this.mPanelType, this.mAnimType, size, this.mFirstItemThumbSize, new PanelHandle.IOnPanelHandleClickListener(){

            @Override
            public void onHandleClick() {
                AbstractPanelView.this.toggleAnimation();
                if (!AbstractPanelView.this.mIsOpen && AbstractPanelView.this.mWidgetProperties != null && AbstractPanelView.this.mWidgetProperties.optInt(AbstractPanelView.LAUNCH_INTERSTITIAL_ON_OPEN, 0) == 1 && AbstractPanelView.this.mInterstitial != null) {
                    AbstractPanelView.this.mInterstitial.loadAd();
                }
            }
        });
        if (this.mHandleContentThumbRoundVal > 0 && this.mPanelHandle.getThumbLayerAsset() != null) {
            this.mPanelHandle.getThumbLayerAsset().addTransformation(new RoundedTransformation(this.mHandleContentThumbRoundVal, 0));
        }
        if (this.mBtnScaleSize == 0.0f) {
            this.mPanelHandle.setVisibility(8);
        }
        this.mPanelHandle.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        this.mContainer.addView((View)this.mPanelHandle, (ViewGroup.LayoutParams)params);
    }

    protected void initBottomBar() {
        this.mBottomBarContainer = new RelativeLayout(this.getContext());
        this.mBottomBarContainer.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        int margin = Utils.dpTOpx(this.getContext(), 3.0f);
        params.setMargins(margin, 0, margin, margin);
        this.mInnerContainer.addView((View)this.mBottomBarContainer, (ViewGroup.LayoutParams)params);
        this.initParentalLockButton();
        this.initAboutKidozButton();
        int size = (int)(70.0f * ScreenUtils.getScaleFactor(this.getContext()));
        RelativeLayout.LayoutParams parentalLockParams = (RelativeLayout.LayoutParams)this.mParentalLockButton.getLayoutParams();
        parentalLockParams.width = size;
        parentalLockParams.height = size;
        RelativeLayout.LayoutParams aboutKidozParams = (RelativeLayout.LayoutParams)this.mAboutKidozButton.getLayoutParams();
        aboutKidozParams.width = size;
        aboutKidozParams.height = size;
        this.mPoweredByTextView = new TextView(this.getContext());
        this.mPoweredByTextView.setText((CharSequence)this.mLabelText);
        this.mPoweredByTextView.setTextColor(this.mLabelColor);
        this.mPoweredByTextView.setTextSize(2, 12.0f);
        this.mPoweredByTextView.setLines(1);
        this.mPoweredByTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.mPoweredByTextView.setGravity(83);
        this.mPoweredByTextView.setShadowLayer(3.0f, 2.0f, 2.0f, Color.parseColor((String)"#44000000"));
        params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(8, this.mAboutKidozButton.getId());
        params.addRule(0, this.mParentalLockButton.getId());
        params.addRule(1, this.mAboutKidozButton.getId());
        params.setMargins(Utils.dpTOpx(this.getContext(), 4.0f), 0, Utils.dpTOpx(this.getContext(), 4.0f), 0);
        this.mBottomBarContainer.addView((View)this.mPoweredByTextView, (ViewGroup.LayoutParams)params);
    }

    private void initParentalLockButton() {
        this.mParentalLockButton = new AssetView(this.getContext());
        this.mParentalLockButton.setId(Utils.generateViewId());
        this.mParentalLockButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mParentalLockButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!AbstractPanelView.this.mIsClicksBlocked) {
                    GenAnimator.clickItemAnimation(v, 80, new GenAnimator.ViewAnimationListener(){

                        @Override
                        public void onAnimationEnd() {
                            AbstractPanelView.this.mIsClicksBlocked = true;
                            if (ParentalLockDialog.getIsCanShowDialog(AbstractPanelView.this.getContext())) {
                                int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(AbstractPanelView.this.getContext(), true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(AbstractPanelView.this.getContext(), false) * 0.5f)};
                                ParentalLockDialog parentalLockDialog = new ParentalLockDialog(AbstractPanelView.this.getContext(), false, popLocation);
                                parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                                    public void onDismiss(DialogInterface dialog) {
                                        boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(AbstractPanelView.this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
                                        AbstractPanelView.this.setParentalLocIConkState(isLockActive);
                                        AbstractPanelView.this.mIsClicksBlocked = false;
                                    }
                                });
                                parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener(){

                                    @Override
                                    public void onPasswordEntered(boolean isPasswordCorrect) {
                                        boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(AbstractPanelView.this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
                                        AbstractPanelView.this.setParentalLocIConkState(isLockActive);
                                    }
                                });
                                parentalLockDialog.show();
                            } else {
                                AbstractPanelView.this.mIsClicksBlocked = false;
                            }
                        }

                        @Override
                        public void onAnimationStart() {
                        }
                    });
                }
            }
        });
        this.mParentalLockButton.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(11);
        params.addRule(15);
        this.mBottomBarContainer.addView((View)this.mParentalLockButton, (ViewGroup.LayoutParams)params);
        boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
        this.setParentalLocIConkState(isLockActive);
    }

    private void initAboutKidozButton() {
        this.mAboutKidozButton = new AssetView(this.getContext());
        this.mAboutKidozButton.setId(Utils.generateViewId());
        this.mAboutKidozButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mAboutKidozButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GenAnimator.clickItemAnimation(v, 80, new GenAnimator.ViewAnimationListener(){

                    @Override
                    public void onAnimationEnd() {
                        int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(AbstractPanelView.this.getContext(), true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(AbstractPanelView.this.getContext(), false) * 0.5f)};
                        AboutKidozDialog aboutKidozDialog = new AboutKidozDialog(AbstractPanelView.this.getContext(), popLocation);
                        aboutKidozDialog.openDialog();
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });
        this.mAboutKidozButton.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(15);
        params.setMargins(Utils.dpTOpx(this.getContext(), 1.0f), 0, 0, 0);
        this.mBottomBarContainer.addView((View)this.mAboutKidozButton, (ViewGroup.LayoutParams)params);
        this.mAboutKidozButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mWidgetProperties.optString(KIDOZ_LOGO_ICON)), null);
    }

    protected void initContentLogicLoader() {
        this.mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback(){

            @Override
            public void onDataReady(ContentData contentData) {
                AbstractPanelView.this.onContentDataLoadEnded();
                if (contentData != null && contentData.isHasContentToShow()) {
                    CookieManager.resetStorage(AbstractPanelView.this.getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), StorageLife.WIDGET);
                    AbstractPanelView.this.mContentItems.clear();
                    AbstractPanelView.this.clearPanelContent();
                    AbstractPanelView.this.mContentItems.addAll(contentData.getContentDataItems());
                    AbstractPanelView.this.setContentAndRefresh(AbstractPanelView.this.mContentItems);
                    final String url = AbstractPanelView.this.mContentItems.get(AbstractPanelView.this.mHandleThumbCurrentShownIndex).getThumb();
                    if (!AbstractPanelView.this.mIsPanelPrepared) {
                        if (AbstractPanelView.this.mIsShowFirstItemThumb && AbstractPanelView.this.mPanelHandle.getThumbLayerAsset() != null) {
                            AbstractPanelView.this.mPanelHandle.getThumbLayerAsset().prefetchAsset(url, new AssetView.IOnAssetLoadedListener(){

                                @Override
                                public void onAssetLoaded(boolean successful) {
                                    AbstractPanelView.this.prepareHandle(url);
                                }
                            });
                        } else {
                            AbstractPanelView.this.prepareHandle(null);
                        }
                    } else if (AbstractPanelView.this.mIsShowFirstItemThumb && AbstractPanelView.this.mPanelHandle.getThumbLayerAsset() != null) {
                        AbstractPanelView.this.mPanelHandle.getThumbLayerAsset().loadAsset(url, null);
                    }
                    AbstractPanelView.this.startThumbChangeCycle();
                }
            }

            @Override
            public void onLoadContentFailed() {
                AbstractPanelView.this.onContentDataLoadFailed();
            }
        });
    }

    private void setParentalLocIConkState(boolean isLockActive) {
        if (isLockActive) {
            this.mParentalLockButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mWidgetProperties.optString(BTN_LOCK_CLOSED)), null);
        } else {
            this.mParentalLockButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mWidgetProperties.optString(BTN_LOCK_OPEN)), null);
        }
    }

    public void setPanelColor(int color) {
        if (color != 0) {
            this.mPanelBgColor = color;
        }
        if (this.mInnerContainer != null) {
            this.mInnerContainer.setBackgroundColor(this.mPanelBgColor);
        }
        if (this.mPanelHandle != null) {
            this.mPanelHandle.setBaseColor(this.mPanelBgColor);
        }
    }

    private void toggleAnimation() {
        if (this.mIsOpen) {
            this.collapsePanelView();
        } else {
            this.expandPanelViewInternal(true);
        }
    }

    public void collapsePanelView() {
        if (KidozSDK.isInitialised() && !this.mIsAnimationRunning && this.mIsOpen && this.mContainer != null) {
            GenAnimator.closePanelView((View)this.mContainer, 200L, (View)this.mInnerContainer, this.mPanelType, new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    GenAnimator.animateHandleClose((View)AbstractPanelView.this.mPanelHandle, null);
                    AbstractPanelView.this.setShowable(false);
                    AbstractPanelView.this.onContentDataLoadStarted();
                    AbstractPanelView.this.mContentLogicLoader.loadContent(AbstractPanelView.this.getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), AbstractPanelView.this.mStyleId);
                }

                public void onAnimationEnd(Animator animation) {
                    AbstractPanelView.this.onCollapsePanelAnimationEnded();
                    EventManager.getInstance(AbstractPanelView.this.getContext()).startEventsSync(AbstractPanelView.this.getContext(), 250);
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
    }

    protected void onCollapsePanelAnimationEnded() {
        this.mPanelHandle.setPanelButtonState(PanelHandle.PANEL_HANDLE_VIEW_STATE.CLOSED);
        this.mIsOpen = false;
        this.mIsAnimationRunning = false;
        if (this.mIOnPanelViewEventListener != null) {
            this.mIOnPanelViewEventListener.onPanelViewCollapsed();
        }
    }

    public void expandPanelView() {
        if (KidozSDK.isInitialised()) {
            this.expandPanelViewInternal(true);
        }
    }

    private void expandPanelViewInternal(boolean byUserAction) {
        if (!this.mIsAnimationRunning && !this.mIsOpen) {
            this.stopThumbChangeCycle();
            if (this.mIsShowFirstItemThumb) {
                if (!this.mContentItems.isEmpty() && this.mContentItems.size() > this.mHandleThumbCurrentShownIndex) {
                    this.mContentItems.add(0, this.mContentItems.remove(this.mHandleThumbCurrentShownIndex));
                    this.setContentAndRefresh(this.mContentItems);
                }
                this.mHandleThumbCurrentShownIndex = 0;
            }
            Event event = new Event();
            if (byUserAction) {
                event.addParameterToJsonObject("Open Type", "1");
            } else {
                event.addParameterToJsonObject("Open Type", "0");
            }
            event.addParameterToJsonObject("Panel Type", this.mPanelType.ordinal());
            EventManager.getInstance(this.getContext()).logEvent(this.getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), this.mStyleId, EventManager.LOG_CRITICAL_LEVEL, event, "Sponsored Content", "Widget View", "Panel View");
            boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
            this.setParentalLocIConkState(isLockActive);
            if (this.mContainer != null) {
                GenAnimator.openPanelView((View)this.mContainer, (View)this.mInnerContainer, this.mPanelType, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                        AbstractPanelView.this.mPanelHandle.setPanelButtonState(PanelHandle.PANEL_HANDLE_VIEW_STATE.OPENED);
                        AbstractPanelView.this.setShowable(true);
                        AbstractPanelView.this.onExpandPanelAnimationStarted();
                    }

                    public void onAnimationEnd(Animator animation) {
                        AbstractPanelView.this.mIsOpen = true;
                        AbstractPanelView.this.mIsAnimationRunning = false;
                        AbstractPanelView.this.invokeViewAction(AbstractPanelView.this.mHandleThumbCurrentShownIndex);
                        if (AbstractPanelView.this.mIOnPanelViewEventListener != null) {
                            AbstractPanelView.this.mIOnPanelViewEventListener.onPanelViewExpanded();
                        }
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        }
    }

    private void startThumbChangeCycle() {
        this.mHandleThumbCurrentShownIndex = 0;
        this.mHandleThumbStaticHandler.removeCallbacksAndMessages(null);
        if (this.mIsShowFirstItemThumb) {
            this.mIsAllowThumbChange = true;
        }
        this.loadNextHandleThumbImage();
    }

    private void stopThumbChangeCycle() {
        this.mIsAllowThumbChange = false;
        this.mHandleThumbStaticHandler.removeCallbacksAndMessages(null);
    }

    protected void onExpandPanelAnimationStarted() {
        GenAnimator.animateHandleOpen((View)this.mPanelHandle, null);
    }

    public void setPanelConfiguration(PANEL_TYPE panelType, HANDLE_POSITION handlePosition) {
        if (KidozSDK.isInitialised()) {
            this.mPanelType = panelType;
            this.mHandlePosition = handlePosition;
            this.mPanelHandle.setPanelType(this.mPanelType);
            this.initPanelViewsRules();
            if (this.mHandlePosition == HANDLE_POSITION.NONE) {
                this.mPanelHandle.setVisibility(4);
            } else if (this.mBtnScaleSize != 0.0f) {
                this.mPanelHandle.setVisibility(0);
            }
        }
    }

    public void setOnPanelViewEventListener(IOnPanelViewEventListener iOnPanelViewEventListener) {
        this.mIOnPanelViewEventListener = iOnPanelViewEventListener;
    }

    public boolean getIsPanelViewExpanded() {
        return this.mIsOpen;
    }

    protected void onDetachedFromWindow() {
        this.getStaticHandler().removeCallbacksAndMessages(null);
        this.stopThumbChangeCycle();
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startThumbChangeCycle();
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (KidozSDK.isInitialised()) {
            if (visibility == 0) {
                this.startThumbChangeCycle();
            } else if (!(this.isInEditMode() || visibility != 8 && visibility != 4)) {
                EventManager.getInstance(this.getContext()).startEventsSync(this.getContext());
                this.getStaticHandler().removeCallbacksAndMessages(null);
                this.stopThumbChangeCycle();
            }
        }
        this.mAllowClickHandling = true;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        this.mAllowClickHandling = hasWindowFocus;
    }

    private void prepareHandle(final String url) {
        this.mPanelHandle.loadAssets(AssetUtil.getAssetFile(this.getContext(), this.mBtnOpenUrl), AssetUtil.getAssetFile(this.getContext(), this.mBtnCloseUrl), AssetUtil.getAssetFile(this.getContext(), this.mBtnOpenSposoredUrl), new PanelHandle.IonPanelHandlePreparedListener(){

            @Override
            public void onPanelPrepared() {
                AbstractPanelView.this.mIsPanelPrepared = true;
                GenAnimator.playGrowAnimation((View)AbstractPanelView.this.mPanelHandle, 350L, 0L, null, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                        AbstractPanelView.this.mPanelHandle.setPanelButtonState(PanelHandle.PANEL_HANDLE_VIEW_STATE.CLOSED);
                        AbstractPanelView.this.requestFocus();
                        AbstractPanelView.this.bringToFront();
                        if (AbstractPanelView.this.mIsShowFirstItemThumb && AbstractPanelView.this.mPanelHandle.getThumbLayerAsset() != null) {
                            AbstractPanelView.this.mPanelHandle.getThumbLayerAsset().loadAsset(url, null);
                        }
                    }

                    public void onAnimationEnd(Animator animation) {
                        AbstractPanelView.this.mIsOpen = false;
                        AbstractPanelView.this.mIsAnimationRunning = false;
                        if (AbstractPanelView.this.mIOnPanelViewEventListener != null) {
                            AbstractPanelView.this.mIOnPanelViewEventListener.onPanelReady();
                        }
                        AbstractPanelView.this.requestFocus();
                        AbstractPanelView.this.bringToFront();
                        if (AbstractPanelView.this.getVisibility() == 0) {
                            AbstractPanelView.this.openPanelForDefinedAmountOfTime();
                        }
                        AbstractPanelView.this.startThumbChangeCycle();
                        EventManager.getInstance(AbstractPanelView.this.getContext()).logEvent(AbstractPanelView.this.getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), AbstractPanelView.this.mStyleId, EventManager.LOG_CRITICAL_LEVEL, "SDK", "Button View", "Panel Button View");
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        });
    }

    private void preparePanel() {
        if (this.mWidgetProperties.optInt(OVERRIDE_USER_PROPERTIES, 0) == 1) {
            this.setPanelColor(this.mPanelBgColor);
        }
        this.mIsOpen = true;
        this.mIsAnimationRunning = true;
        Utils.setOnGlobalLayoutFinishListener((View)this, new Utils.OnGlobalLayoutFinishedListener(){

            @Override
            public void onLayoutFinished() {
                GenAnimator.closePanelView((View)AbstractPanelView.this.mContainer, 0L, (View)AbstractPanelView.this.mInnerContainer, AbstractPanelView.this.mPanelType, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                        GenAnimator.animateHandleClose((View)AbstractPanelView.this.mPanelHandle, null);
                        AbstractPanelView.this.requestFocus();
                        AbstractPanelView.this.bringToFront();
                    }

                    public void onAnimationEnd(Animator animation) {
                        AbstractPanelView.this.clearPanelContent();
                        AbstractPanelView.this.onContentDataLoadStarted();
                        AbstractPanelView.this.mContentLogicLoader.loadContent(AbstractPanelView.this.getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), AbstractPanelView.this.mStyleId);
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        });
    }

    private void openPanelForDefinedAmountOfTime() {
        final long lastLaunchTime = this.mSharedPreferences.getLong(FIRST_TIME_LAST_LOUNCH_KEY, -1L);
        if (this.mFirstLounchStartDelay >= 0.0f && this.getVisibility() == 0) {
            this.getStaticHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (AbstractPanelView.this.mFirstLounchOpenRepeatTimeFarme == -1.0f || lastLaunchTime == -1L || (float)lastLaunchTime + AbstractPanelView.this.mFirstLounchOpenRepeatTimeFarme * 3600000.0f > (float)System.currentTimeMillis()) {
                        AbstractPanelView.this.expandPanelViewInternal(false);
                        SharedPreferences.Editor editor = AbstractPanelView.this.mSharedPreferences.edit();
                        editor.putLong(AbstractPanelView.FIRST_TIME_LAST_LOUNCH_KEY, System.currentTimeMillis());
                        editor.apply();
                        if (AbstractPanelView.this.mFirstLounchOpenPeriod > 0.0f) {
                            AbstractPanelView.this.getStaticHandler().postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    AbstractPanelView.this.collapsePanelView();
                                }
                            }, (long)(AbstractPanelView.this.mFirstLounchOpenPeriod * 1000.0f));
                        }
                    }
                }
            }, (long)(this.mFirstLounchStartDelay * 1000.0f));
        }
    }

    private void loadNextHandleThumbImage() {
        if (this.mIsShowFirstItemThumb) {
            this.mHandleThumbStaticHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (AbstractPanelView.this.mIsAllowThumbChange) {
                        ++AbstractPanelView.this.mHandleThumbCurrentShownIndex;
                        if (AbstractPanelView.this.mContentItems != null && !AbstractPanelView.this.mContentItems.isEmpty() && AbstractPanelView.this.mHandleThumbCurrentShownIndex < AbstractPanelView.this.mContentItems.size()) {
                            String url;
                            if (AbstractPanelView.this.mHandleThumbCurrentShownIndex == AbstractPanelView.this.mContentItems.size() - 1) {
                                AbstractPanelView.this.mHandleThumbCurrentShownIndex = 0;
                            }
                            if ((url = AbstractPanelView.this.mContentItems.get(AbstractPanelView.this.mHandleThumbCurrentShownIndex).getThumb()) != null && AbstractPanelView.this.mPanelHandle.getThumbLayerAsset() != null) {
                                AbstractPanelView.this.mPanelHandle.getThumbLayerAsset().loadAsset(url, new AssetView.IOnAssetLoadedListener(){

                                    @Override
                                    public void onAssetLoaded(boolean successful) {
                                        AbstractPanelView.this.loadNextHandleThumbImage();
                                    }
                                });
                            }
                        }
                    }
                }
            }, this.mHandleThumbRefreshRateSec * 1000);
        }
    }

    protected Utils.StaticHandler getStaticHandler() {
        if (this.mStaticHandler == null) {
            this.mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper());
        }
        return this.mStaticHandler;
    }

    public void setAutoExpandOnStart(float startDelay, float showPeriod, float repeatTimeFrame) {
        if (this.mWidgetProperties != null && this.mWidgetProperties.optInt(OVERRIDE_USER_PROPERTIES, 0) == 0) {
            if (startDelay != -2.0f) {
                this.mFirstLounchStartDelay = startDelay;
            }
            if (showPeriod != -2.0f) {
                this.mFirstLounchOpenPeriod = showPeriod;
            }
            if (repeatTimeFrame != -2.0f) {
                this.mFirstLounchOpenRepeatTimeFarme = repeatTimeFrame;
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (System.currentTimeMillis() - this.mLastInterceptTS > 1000L) {
            this.mLastInterceptTS = System.currentTimeMillis();
            this.getStaticHandler().removeCallbacksAndMessages(null);
        }
        return super.onInterceptTouchEvent(ev);
    }
}

