/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.interstitial;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.kidoz.sdk.api.KidozInterstitial;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.CookieManager;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;
import com.kidoz.sdk.api.ui_views.interstitial.KidozAdActivity;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONObject;

public class IntrstWrapper {
    private final String TAG = IntrstWrapper.class.getSimpleName();
    private static IntrstWrapper mInstance = null;
    public Context mContext;
    private HtmlViewWrapper webView;
    private String mStyleId;
    private boolean mIsInitializationFinished = false;
    private boolean mIsLoaded = false;
    private boolean mIsLoadRequestedWhileNotReady;
    private JSONObject mProperties;
    private Lock mLaunchLock;
    private InnerHelperInterface mInnerHelperInterface;
    private boolean mIsLocal = false;

    public static IntrstWrapper initInstance(Context context) {
        if (mInstance == null) {
            mInstance = new IntrstWrapper(context);
            return mInstance;
        }
        mInstance.validateIfPrepared();
        return mInstance;
    }

    protected IntrstWrapper(Context context) {
        this.mContext = context;
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        this.mLaunchLock = new ReentrantLock();
        if (KidozSDK.isInitialised()) {
            this.validateLayoutAndAssets();
        }
        this.mInnerHelperInterface = new InnerHelperInterface(){

            @Override
            public void onAdOpen() {
                if (!IntrstWrapper.this.mIsLocal) {
                    EventBus.getDefault().post((Object)InterstitialEvents.OPENED);
                }
            }

            @Override
            public void onAdClose() {
                if (!IntrstWrapper.this.mIsLocal) {
                    EventBus.getDefault().post((Object)InterstitialEvents.CLOSED);
                }
                IntrstWrapper.this.mIsLoaded = false;
                CookieManager.resetStorage(IntrstWrapper.this.mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), StorageLife.WIDGET);
            }
        };
    }

    public InnerHelperInterface getHelperInterface() {
        return this.mInnerHelperInterface;
    }

    private void validateLayoutAndAssets() {
        SdkAPIManager.getSdkApiInstance(this.mContext).getStyle(this.mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getValue(), new ApiResultCallback<Boolean>(){

            @Override
            public void onServerResult(ResultData<?> result) {
                if (result != null && result.getResponseStatus() != null && result.getResponseStatus().getIsSuccessful()) {
                    if (result.getData() != null) {
                        boolean isResultReady = (Boolean)result.getData();
                        if (isResultReady) {
                            IntrstWrapper.this.mProperties = DatabaseManager.getInstance(IntrstWrapper.this.mContext).getConfigTable().loadProperties(KidozInterstitial.TAG);
                            if (IntrstWrapper.this.mProperties != null) {
                                IntrstWrapper.this.mStyleId = IntrstWrapper.this.mProperties.optString("style_id");
                            }
                            IntrstWrapper.this.prepareWebView();
                        } else {
                            this.onFailed();
                        }
                    }
                } else {
                    this.onFailed();
                }
            }

            @Override
            public void onFailed() {
                EventBus.getDefault().post((Object)InterstitialEvents.LOAD_FAILED);
            }
        });
    }

    private synchronized void prepareWebView() {
        if (this.webView == null) {
            this.webView = HtmlManager.initIntrstDefaultHtmlView(this.mContext);
            this.webView.setHtmlWebViewListener(new IOnHtmlWebViewInterface(){

                @Override
                public void onHtmlFinishedLoading() {
                    super.onHtmlFinishedLoading();
                }

                @Override
                public void onNotifyVastReady(boolean isVastReady) {
                    super.onNotifyVastReady(isVastReady);
                    if (isVastReady) {
                        IntrstWrapper.this.mIsLoaded = true;
                        if (!IntrstWrapper.this.mIsLocal) {
                            EventBus.getDefault().post((Object)InterstitialEvents.READY);
                        } else {
                            IntrstWrapper.this.show();
                        }
                    } else {
                        IntrstWrapper.this.mIsLoaded = false;
                        if (!IntrstWrapper.this.mIsLocal) {
                            EventBus.getDefault().post((Object)InterstitialEvents.LOAD_FAILED);
                        }
                    }
                    IntrstWrapper.this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                }

                @Override
                public void onViewReady() {
                    super.onViewReady();
                    IntrstWrapper.this.mIsInitializationFinished = true;
                    if (IntrstWrapper.this.mIsLoadRequestedWhileNotReady) {
                        IntrstWrapper.this.mIsLoadRequestedWhileNotReady = false;
                        IntrstWrapper.this.load();
                    }
                }

                @Override
                public void onClose() {
                    super.onClose();
                    WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL);
                    EventBus.getDefault().post((Object)eventMessage);
                }
            });
        }
        this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
        PropertiesObj appConfig = DatabaseManager.getInstance(this.mContext).getConfigTable().loadAppProperties();
        if (appConfig != null) {
            this.webView.loadHtml(appConfig.getInterstitialHtmlLink());
        }
    }

    public void load() {
        if (this.mIsInitializationFinished) {
            this.mIsLoaded = false;
            if (this.webView != null) {
                this.webView.requestVastAds();
            }
        } else {
            this.mIsLoadRequestedWhileNotReady = true;
        }
    }

    public void show() {
        if (this.mIsLoaded) {
            this.webView.startVastAd();
            this.openActivity();
        } else {
            Log.w((String)"KidozInterstitial", (String)"Interstitial Ad is not loaded! Please call loadAd() first.");
        }
    }

    public boolean isInterstitialLoaded() {
        return this.mIsLoaded;
    }

    private synchronized void openActivity() {
        if (this.mLaunchLock.tryLock()) {
            try {
                try {
                    Intent intent = new Intent(this.mContext, KidozAdActivity.class);
                    intent.putExtra("styleId", this.mStyleId);
                    intent.addFlags(0x30020000);
                    this.mContext.startActivity(intent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                this.mLaunchLock.unlock();
            }
        }
    }

    @Subscribe
    public void onHandleEvent(EventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK) {
            this.validateLayoutAndAssets();
        }
    }

    protected void validateIfPrepared() {
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        if (!this.mIsInitializationFinished) {
            this.prepareWebView();
        }
    }

    public void setIsLocalRequest(boolean local) {
        this.mIsLocal = local;
    }

    public boolean getIsLocal() {
        return this.mIsLocal;
    }

    public static interface InnerHelperInterface {
        public void onAdOpen();

        public void onAdClose();
    }

    public static enum InterstitialEvents {
        OPENED,
        CLOSED,
        READY,
        LOAD_FAILED;

    }
}

