/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.flexi_view;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.FlexiView;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.ui_views.flexi_view.CircleTransformation;
import com.kidoz.sdk.api.ui_views.flexi_view.RoundedCornerTransformation;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;
import com.squareup.imagelib.Callback;
import com.squareup.imagelib.Transformation;
import org.json.JSONObject;

public class MovableView
extends RelativeLayout {
    private static final String TAG = MovableView.class.getSimpleName();
    private static final float SHADOW_LAYER_OVAL_OFFSET = 1.235f;
    private static final float SHADOW_LAYER_RECTANGLE_OFFSET = 1.2f;
    private static final float FLEXI_DEFAULT_THUMB_RATIO = 0.25f;
    private static final float CLOSE_BTN_RATIO = 0.32f;
    private static final float PARENTAL_LOCK_RATIO = 0.32f;
    private JSONObject mPropertiesObject;
    private ImageView mMainThumbnailView;
    private ImageView mShadowLayerView;
    private AssetView mAnimateView;
    private AssetView mLockIconView;
    private AssetView mCloseIconView;
    private IMovableActionListener mActionListener;
    public Transformation mImageTransformation = null;
    private boolean mIsCircle;
    private float mBrderWidth;
    private float mCornersRadius;
    private String mBorderColor;
    private String mFillColor;
    private GradientDrawable mShadowBgDrawable;
    private final Object mSyncObject = new Object();
    public static final String STYLE_ID = "style_id";
    public static final String ANIMATION_OVERLAY = "flexiAnimOverlay";
    public static final String LOCK_CLOSE_BUTTON = "flexiLockCloseBtn";
    public static final String LOCK_OPEN_BUTTON = "flexiLockOpenBtn";
    public static final String CLOSE_BTN = "flexiCloseBtn";
    public static final String CONTENT_THUMB_RATIO = "flexiThumbRatio";
    public static final String ANIM_OVERLAY_RATIO = "flexiAnimOverlayRatio";
    public static final String BORDER_COLOR = "flexiBorderClr";
    public static final String FILL_COLOR = "flexiFillClr";
    public static final String BORDER_WIDTH = "flexiBorderWidth";
    public static final String CORNER_ROUND_RADIUS = "flexiCornerRadius";
    public static final String IS_CIRCLE = "flexiIsCircle";
    public static final String NOTICE_ME_ANIMATION_TYPE = "flexiNoticeMeAnimType";
    public static final String NOTICE_ME_ANIMATION_RATE_MILLIS = "flexiNoticeMeAnimRateMillis";
    public static final String FLEXI_POP_VIEW_SOUND = "flexiPopSound";
    public static final String CONTENT_SWAP_SOUND = "flexiContentSwapSound";
    public static final String CONTENT_REFRESH_RATE_SECONDS = "flexiContentRefreshRateSec";
    public static final String IS_FLEXI_VIEW_DRUGGABLE = "flexiIsDraggable";
    public static final String IS_FLEXI_VIEW_CLOSABLE = "flexiIsClosable";
    public static final String IS_OVERRIDE_USER_SET = "flexiIsOverrideUserSet";
    public static final String IS_SOUND_ENABLED = "flexiEnableSound";
    public static final String LOUNCH_INTERSTITIAL_ON_OPEN = "lounchInterstitialOnOpen";

    public MovableView(Context context, JSONObject jsonObject, IMovableActionListener actionListener) {
        super(context);
        this.mActionListener = actionListener;
        this.mPropertiesObject = jsonObject;
        this.setVisibility(4);
        this.initView();
    }

    private void initView() {
        if (this.mPropertiesObject != null) {
            this.mIsCircle = this.mPropertiesObject.optInt(IS_CIRCLE, 1) == 1;
            this.mBrderWidth = (float)this.mPropertiesObject.optDouble(BORDER_WIDTH, 0.0);
            this.mCornersRadius = (float)this.mPropertiesObject.optDouble(CORNER_ROUND_RADIUS, 0.0);
            this.mBorderColor = this.mPropertiesObject.optString(BORDER_COLOR, "#ffffff");
            this.mFillColor = this.mPropertiesObject.optString(FILL_COLOR, "#ffffff");
            Point point = Utils.getScreenSize(this.getContext());
            float thumbRatio = (float)this.mPropertiesObject.optDouble(CONTENT_THUMB_RATIO, 0.25);
            int mainThumbSize = (int)((float)Math.min(point.x, point.y) * thumbRatio);
            this.initMainThumbView(mainThumbSize);
            if (!this.mIsCircle) {
                this.initBottomShadowLayerView(mainThumbSize);
            } else {
                this.initBottomShadowLayerView(mainThumbSize);
            }
            int animViewSize = (int)((double)mainThumbSize * this.mPropertiesObject.optDouble(ANIM_OVERLAY_RATIO, 1.0));
            this.initAnimatedView(animViewSize);
            int offset = 0;
            int diff = (animViewSize - mainThumbSize) / 2;
            int parentalSize = (int)((float)mainThumbSize * 0.32f);
            if (diff > parentalSize / 2) {
                offset = diff - parentalSize / 2;
            }
            this.initParentalLockView(parentalSize, offset);
            int closeSize = (int)((float)mainThumbSize * 0.32f);
            if (diff > closeSize / 2) {
                offset = diff - closeSize / 2;
            }
            this.initCloseView(closeSize, offset);
            this.generateAndSetProperShadowBackground();
        }
    }

    private void generateAndSetProperShadowBackground() {
        this.mShadowBgDrawable = new GradientDrawable();
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mShadowLayerView.getLayoutParams();
        if (this.mIsCircle) {
            this.mShadowBgDrawable.setShape(1);
            params.setMargins(-Utils.dpTOpx(this.getContext(), 1.235f), 0, 0, -Utils.dpTOpx(this.getContext(), 1.235f));
        } else {
            this.mShadowBgDrawable.setShape(0);
            this.mShadowBgDrawable.setCornerRadius((float)Utils.dpTOpx(this.getContext(), this.mCornersRadius + this.mBrderWidth / 2.5f));
            params.setMargins(Utils.dpTOpx(this.getContext(), this.mBrderWidth) / 2 - Utils.dpTOpx(this.getContext(), 1.2f), Utils.dpTOpx(this.getContext(), this.mBrderWidth) / 2 + Utils.dpTOpx(this.getContext(), 2.0f), Utils.dpTOpx(this.getContext(), this.mBrderWidth) / 2 + Utils.dpTOpx(this.getContext(), 2.0f), Utils.dpTOpx(this.getContext(), this.mBrderWidth) / 2 - Utils.dpTOpx(this.getContext(), 1.2f));
        }
        this.mShadowBgDrawable.setDither(true);
        this.mShadowBgDrawable.mutate();
        this.mShadowBgDrawable.setColor(-16777216);
        this.mShadowBgDrawable.setAlpha(126);
        if (Build.VERSION.SDK_INT >= 16) {
            this.mShadowLayerView.setBackground((Drawable)this.mShadowBgDrawable);
        } else {
            this.mShadowLayerView.setBackgroundDrawable((Drawable)this.mShadowBgDrawable);
        }
    }

    private void initMainThumbView(int mainSize) {
        this.mMainThumbnailView = new ImageView(this.getContext());
        this.mMainThumbnailView.setId(Utils.generateViewId());
        this.mMainThumbnailView.setScaleType(ImageView.ScaleType.FIT_XY);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(mainSize, mainSize);
        params.addRule(13);
        this.addView((View)this.mMainThumbnailView, (ViewGroup.LayoutParams)params);
    }

    private void initBottomShadowLayerView(int mainSize) {
        this.mShadowLayerView = new ImageView(this.getContext());
        this.mShadowLayerView.setId(Utils.generateViewId());
        this.mShadowLayerView.setScaleType(ImageView.ScaleType.FIT_XY);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(mainSize, mainSize);
        params.addRule(7, this.mMainThumbnailView.getId());
        params.addRule(6, this.mMainThumbnailView.getId());
        params.addRule(8, this.mMainThumbnailView.getId());
        params.addRule(5, this.mMainThumbnailView.getId());
        this.addView((View)this.mShadowLayerView, 0, (ViewGroup.LayoutParams)params);
    }

    private void initAnimatedView(int size) {
        this.mAnimateView = new AssetView(this.getContext());
        this.mAnimateView.setScaleType(ImageView.ScaleType.FIT_XY);
        this.mAnimateView.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);
        params.addRule(13);
        this.addView((View)this.mAnimateView, (ViewGroup.LayoutParams)params);
    }

    private void initCloseView(int size, int fixOffset) {
        this.mCloseIconView = new AssetView(this.getContext());
        this.mCloseIconView.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);
        params.addRule(6, this.mAnimateView.getId());
        params.addRule(7, this.mAnimateView.getId());
        if (Build.VERSION.SDK_INT > 16) {
            params.addRule(19, this.mAnimateView.getId());
        }
        params.setMargins(0, fixOffset, fixOffset, 0);
        this.addView((View)this.mCloseIconView, (ViewGroup.LayoutParams)params);
        this.mCloseIconView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GenAnimator.clickItemAnimation(v, 95, new GenAnimator.ViewAnimationListener(){

                    @Override
                    public void onAnimationEnd() {
                        if (MovableView.this.mActionListener != null) {
                            MovableView.this.mActionListener.onCloseClick();
                        }
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });
    }

    private void initParentalLockView(int size, int fixOffset) {
        this.mLockIconView = new AssetView(this.getContext());
        this.mLockIconView.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);
        params.addRule(8, this.mAnimateView.getId());
        params.addRule(7, this.mAnimateView.getId());
        if (Build.VERSION.SDK_INT > 16) {
            params.addRule(19, this.mAnimateView.getId());
        }
        params.setMargins(0, 0, fixOffset, fixOffset);
        this.addView((View)this.mLockIconView, (ViewGroup.LayoutParams)params);
        this.mLockIconView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GenAnimator.clickItemAnimation(v, 95, new GenAnimator.ViewAnimationListener(){

                    @Override
                    public void onAnimationEnd() {
                        if (ParentalLockDialog.getIsCanShowDialog(MovableView.this.getContext())) {
                            int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(MovableView.this.getContext(), true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(MovableView.this.getContext(), false) * 0.5f)};
                            ParentalLockDialog parentalLockDialog = new ParentalLockDialog(MovableView.this.getContext(), false, popLocation);
                            parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                                public void onDismiss(DialogInterface dialog) {
                                    MovableView.this.updateLockIcon();
                                }
                            });
                            parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener(){

                                @Override
                                public void onPasswordEntered(boolean isPasswordCorrect) {
                                    MovableView.this.updateLockIcon();
                                }
                            });
                            parentalLockDialog.show();
                        }
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });
    }

    public void loadSecondaryAssets(final IMovableAssetReadyListener listener) {
        String url = null;
        boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
        url = isLockActive ? this.mPropertiesObject.optString(LOCK_CLOSE_BUTTON) : this.mPropertiesObject.optString(LOCK_OPEN_BUTTON);
        this.mLockIconView.loadAsset(AssetUtil.getAssetFile(this.getContext(), url), new AssetView.IOnAssetLoadedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAssetLoaded(boolean successful) {
                Object object = MovableView.this.mSyncObject;
                synchronized (object) {
                    if (MovableView.this.mAnimateView.getIsAssetLoaded() && MovableView.this.mLockIconView.getIsAssetLoaded() && MovableView.this.mCloseIconView.getIsAssetLoaded()) {
                        listener.onAssetsReady();
                    }
                }
            }
        });
        this.mCloseIconView.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mPropertiesObject.optString(CLOSE_BTN)), new AssetView.IOnAssetLoadedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAssetLoaded(boolean successful) {
                Object object = MovableView.this.mSyncObject;
                synchronized (object) {
                    if (MovableView.this.mAnimateView.getIsAssetLoaded() && MovableView.this.mLockIconView.getIsAssetLoaded() && MovableView.this.mCloseIconView.getIsAssetLoaded()) {
                        listener.onAssetsReady();
                    }
                }
            }
        });
        this.mAnimateView.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mPropertiesObject.optString(ANIMATION_OVERLAY)), new AssetView.IOnAssetLoadedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAssetLoaded(boolean successful) {
                Object object = MovableView.this.mSyncObject;
                synchronized (object) {
                    if (MovableView.this.mAnimateView.getIsAssetLoaded() && MovableView.this.mLockIconView.getIsAssetLoaded() && MovableView.this.mCloseIconView.getIsAssetLoaded()) {
                        listener.onAssetsReady();
                    }
                }
            }
        });
    }

    public void loadMainAsset(String url, final IMovableAssetReadyListener listener) {
        if (this.mImageTransformation == null) {
            this.mImageTransformation = this.mIsCircle ? new CircleTransformation(Utils.dpTOpx(this.getContext(), this.mBrderWidth), this.mBorderColor, this.mFillColor, this.mMainThumbnailView.getWidth()) : new RoundedCornerTransformation(Utils.dpTOpx(this.getContext(), this.mBrderWidth), this.mBorderColor, this.mFillColor, Utils.dpTOpx(this.getContext(), this.mCornersRadius), this.mMainThumbnailView.getWidth());
        }
        PicassoOk.getPicasso(this.getContext()).load(url).transform(this.mImageTransformation).into(this.mMainThumbnailView, new Callback(){

            @Override
            public void onSuccess() {
                listener.onAssetsReady();
            }

            @Override
            public void onError() {
            }
        });
    }

    private void updateLockIcon() {
        try {
            boolean isLockActive;
            boolean bl = isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
            if (isLockActive) {
                this.mLockIconView.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mPropertiesObject.optString(LOCK_CLOSE_BUTTON)), new AssetView.IOnAssetLoadedListener(){

                    @Override
                    public void onAssetLoaded(boolean successfull) {
                    }
                });
            } else {
                this.mLockIconView.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mPropertiesObject.optString(LOCK_OPEN_BUTTON)), new AssetView.IOnAssetLoadedListener(){

                    @Override
                    public void onAssetLoaded(boolean successfull) {
                    }
                });
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to load parental lock image: " + ex.getMessage());
        }
    }

    public void playOrStopTheGifAnimationIfExists(boolean isToPlay) {
        if (this.mAnimateView != null) {
            if (isToPlay) {
                this.mAnimateView.startGifAnim();
            } else {
                this.mAnimateView.pauseGifAnim();
            }
        }
    }

    public void showCloseBtn(boolean show) {
        if (this.mCloseIconView != null) {
            if (show) {
                this.mCloseIconView.setVisibility(0);
            } else {
                this.mCloseIconView.setVisibility(8);
            }
        }
    }

    public static boolean parseFlexiViewData(Context context, JSONObject jsonObject) {
        boolean result = false;
        if (jsonObject != null) {
            try {
                JSONObject oldData = DatabaseManager.getInstance(context).getConfigTable().loadProperties(FlexiView.TAG);
                result = AssetUtil.loadAsset(context, oldData, jsonObject, ANIMATION_OVERLAY);
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, LOCK_CLOSE_BUTTON);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, LOCK_OPEN_BUTTON);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, CLOSE_BTN);
                }
                AssetUtil.loadAsset(context, oldData, jsonObject, FLEXI_POP_VIEW_SOUND);
                AssetUtil.loadAsset(context, oldData, jsonObject, CONTENT_SWAP_SOUND);
                if (result) {
                    DatabaseManager.getInstance(context).getConfigTable().insertProperties(FlexiView.TAG, jsonObject);
                }
            }
            catch (Exception ex) {
                result = false;
                SDKLogger.printErrorLog(FlexiView.TAG, "Error when trying to parse kidoz flexi view properties" + ex.getMessage());
            }
        }
        return result;
    }

    public static interface IMovableAssetReadyListener {
        public void onAssetsReady();
    }

    public static interface IMovableActionListener {
        public void onCloseClick();
    }
}

