/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.animation.Animator;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.assets_handling.ImageAssetsUtils;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.ExitButton;
import com.kidoz.sdk.api.ui_views.ParentalLockButton;
import com.kidoz.sdk.api.ui_views.TitleView;
import java.io.File;
import org.json.JSONObject;

public class KidozTopBar
extends RelativeLayout {
    public static final float BACKGROUND_RATIO = 0.061458334f;
    private KidozTopBarListener mKidozTopBarListener;
    private boolean mIsParentalLockVisible;
    private boolean mIsClicksBlocked;
    private TitleView mTitleView;
    private ExitButton mExitButton;
    private ParentalLockButton mParentalLockButton;
    private JSONObject mPropertiesObject;
    private String mWidgetType = null;
    private String mStyleId = null;

    public KidozTopBar(Context context, boolean isUseBackButton, String widgetType, JSONObject propertiesObject) {
        super(context);
        this.mWidgetType = widgetType;
        this.mPropertiesObject = propertiesObject;
        if (this.mPropertiesObject != null) {
            this.mStyleId = this.mPropertiesObject.optString("style_id", null);
        }
        this.initView(isUseBackButton);
    }

    public KidozTopBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(false);
    }

    private void initView(boolean isUseBackButton) {
        this.initRootView();
        this.addBackground();
        this.initExitButton(isUseBackButton);
        this.initLockButton();
        this.initTitle();
    }

    private void initRootView() {
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return KidozTopBar.this.mIsClicksBlocked;
            }
        });
        Utils.setOnGlobalLayoutFinishListener((View)this, new Utils.OnGlobalLayoutFinishedListener(){

            @Override
            public void onLayoutFinished() {
                KidozTopBar.this.mParentalLockButton.setVisibility(4);
                if (KidozTopBar.this.mIsParentalLockVisible) {
                    KidozTopBar.this.mParentalLockButton.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            GenAnimator.playDropAnimation((View)KidozTopBar.this.mParentalLockButton, new Animator.AnimatorListener(){

                                public void onAnimationStart(Animator animation) {
                                    KidozTopBar.this.mParentalLockButton.setVisibility(0);
                                }

                                public void onAnimationEnd(Animator animation) {
                                    KidozTopBar.this.mParentalLockButton.setVisibility(0);
                                }

                                public void onAnimationCancel(Animator animation) {
                                }

                                public void onAnimationRepeat(Animator animation) {
                                }
                            });
                        }
                    }, 320L);
                }
                KidozTopBar.this.mExitButton.setVisibility(4);
                KidozTopBar.this.mExitButton.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        GenAnimator.playDropAnimation((View)KidozTopBar.this.mExitButton, new Animator.AnimatorListener(){

                            public void onAnimationStart(Animator animation) {
                                KidozTopBar.this.mExitButton.setVisibility(0);
                            }

                            public void onAnimationEnd(Animator animation) {
                                KidozTopBar.this.mExitButton.setVisibility(0);
                            }

                            public void onAnimationCancel(Animator animation) {
                            }

                            public void onAnimationRepeat(Animator animation) {
                            }
                        });
                    }
                }, 240L);
            }
        });
    }

    private void addBackground() {
        float height = 118.0f;
        float scaleFactor = ScreenUtils.getScaleFactor(this.getContext());
        String bgColor = "#04a0e1";
        if (this.mPropertiesObject != null) {
            bgColor = this.mPropertiesObject.optString("topBarBgColor");
        }
        View view = new View(this.getContext());
        view.setBackgroundColor(Color.parseColor((String)bgColor));
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, (int)(height * scaleFactor));
        this.addView(view, (ViewGroup.LayoutParams)params);
    }

    private void initTitle() {
        File imageFile = null;
        if (this.mPropertiesObject != null) {
            imageFile = AssetUtil.getAssetFile(this.getContext(), this.mPropertiesObject.optString("topBarBackground"));
        }
        this.mTitleView = new TitleView(this.getContext(), imageFile);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        this.addView((View)this.mTitleView, (ViewGroup.LayoutParams)params);
        if (this.mPropertiesObject != null) {
            String textColor = this.mPropertiesObject.optString("topBarTitleColor", "#04a0e1");
            this.mTitleView.setTitle(this.mPropertiesObject.optString("topBarTitle"));
            this.mTitleView.setTitleColor(Color.parseColor((String)textColor));
        }
    }

    private void initLockButton() {
        File activeLock = null;
        File notActiveLock = null;
        if (this.mPropertiesObject != null) {
            activeLock = AssetUtil.getAssetFile(this.getContext(), this.mPropertiesObject.optString("lockActiveButton", null));
            notActiveLock = AssetUtil.getAssetFile(this.getContext(), this.mPropertiesObject.optString("lockNotActiveButton", null));
        }
        this.mIsParentalLockVisible = true;
        this.mParentalLockButton = new ParentalLockButton(this.getContext(), activeLock, notActiveLock, new ParentalLockButton.ParentalLockButtonListener(){

            @Override
            public void onClickStarted() {
            }

            @Override
            public void onClickEnd() {
                if (!KidozTopBar.this.mIsClicksBlocked) {
                    KidozTopBar.this.mIsClicksBlocked = true;
                    int lockStatus = SharedPreferencesUtils.loadSharedPreferencesData(KidozTopBar.this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") == null ? 0 : 1;
                    EventManager.getInstance(KidozTopBar.this.getContext()).LogEventWithIntField(KidozTopBar.this.getContext(), KidozTopBar.this.mWidgetType, KidozTopBar.this.mStyleId, EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Click", "Lock Button", lockStatus);
                    if (ParentalLockDialog.getIsCanShowDialog(KidozTopBar.this.getContext())) {
                        int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(KidozTopBar.this.getContext(), true) * 0.722f), (int)((float)ScreenUtils.getScreenSize(KidozTopBar.this.getContext(), false) * 0.04f)};
                        ParentalLockDialog parentalLockDialog = new ParentalLockDialog(KidozTopBar.this.getContext(), false, popLocation);
                        parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                            public void onDismiss(DialogInterface dialog) {
                                KidozTopBar.this.mIsClicksBlocked = false;
                                boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(KidozTopBar.this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
                                KidozTopBar.this.mParentalLockButton.setIsLockActive(isLockActive);
                            }
                        });
                        parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener(){

                            @Override
                            public void onPasswordEntered(boolean isPasswordCorrect) {
                                boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(KidozTopBar.this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
                                KidozTopBar.this.mParentalLockButton.setIsLockActive(isLockActive);
                            }
                        });
                        parentalLockDialog.show();
                    } else {
                        KidozTopBar.this.mIsClicksBlocked = false;
                    }
                }
            }
        });
        this.mParentalLockButton.setId(Utils.generateViewId());
        boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
        this.mParentalLockButton.setIsLockActive(isLockActive);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(0, this.mExitButton.getId());
        params.rightMargin = (int)(5.0f * ScreenUtils.getScaleFactor(this.getContext()));
        this.addView((View)this.mParentalLockButton, (ViewGroup.LayoutParams)params);
    }

    private void initExitButton(boolean isUseBackButton) {
        File backBtnImage = ImageAssetsUtils.getAssetFile(this.getContext(), ImageAssetsUtils.APP_ASSET_TYPE.BACK_BUTTON);
        File exitBtnImage = null;
        if (this.mPropertiesObject != null) {
            exitBtnImage = AssetUtil.getAssetFile(this.getContext(), this.mPropertiesObject.optString("exitButton"));
        }
        this.mExitButton = new ExitButton(this.getContext(), backBtnImage, exitBtnImage, new ExitButton.ExitButtonListener(){

            @Override
            public void onClickStarted() {
            }

            @Override
            public void onClickEnd() {
                if (!KidozTopBar.this.mIsClicksBlocked) {
                    KidozTopBar.this.mIsClicksBlocked = true;
                    EventManager.getInstance(KidozTopBar.this.getContext()).logEvent(KidozTopBar.this.getContext(), KidozTopBar.this.mWidgetType, KidozTopBar.this.mStyleId, EventManager.LOG_NORMAL_LEVEL, null, "SDK", "Click", "Exit");
                    if (KidozTopBar.this.mKidozTopBarListener != null) {
                        KidozTopBar.this.mKidozTopBarListener.onExitClicked(null);
                    }
                    KidozTopBar.this.mIsClicksBlocked = false;
                }
            }
        }, isUseBackButton);
        this.mExitButton.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(11);
        params.rightMargin = (int)(5.0f * ScreenUtils.getScaleFactor(this.getContext()));
        this.addView((View)this.mExitButton, (ViewGroup.LayoutParams)params);
    }

    public void setKidozTopBarListener(KidozTopBarListener kidozTopBarListener) {
        this.mKidozTopBarListener = kidozTopBarListener;
    }

    public void setTitle(String title) {
        if (this.mTitleView != null) {
            this.mTitleView.setTitle(title);
            this.invalidate();
        }
    }

    public void setTopBarBackgroundColor(int color) {
    }

    public void showParentalLockIcon(boolean show) {
        this.mIsParentalLockVisible = show;
        if (this.mIsParentalLockVisible) {
            this.mParentalLockButton.setVisibility(0);
        } else {
            this.mParentalLockButton.setVisibility(4);
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation == 1) {
            this.clearAnimation();
            this.setTranslationY(0.0f);
        }
    }

    public static interface KidozTopBarListener {
        public void onExitClicked(View var1);
    }
}

