/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.picasso_related;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import com.squareup.imagelib.Transformation;

public class RoundedTransformation
implements Transformation {
    private final int radius;
    private final int margin;
    private boolean mRoundTopLeft;
    private boolean mRoundTopRight;
    private boolean mRoundBottomLeft;
    private boolean mRoundBottomRight;
    private String mTransformationTAG = "NA";

    public RoundedTransformation(int radius, int margin) {
        this.radius = radius;
        this.margin = margin;
    }

    public RoundedTransformation(int radius, int margin, boolean roundTopLeft) {
        this.radius = radius;
        this.margin = margin;
        this.mRoundTopLeft = roundTopLeft;
    }

    @Override
    public Bitmap transform(Bitmap source) {
        Bitmap result;
        if (!this.mRoundTopLeft) {
            result = this.roundAllCorners(source);
            this.mTransformationTAG = "Transformation";
        } else {
            result = this.getRoundedCornerBitmap(source, this.radius, false, true, true, true);
            this.mTransformationTAG = "Transformation2";
        }
        return result;
    }

    private Bitmap roundAllCorners(Bitmap source) {
        Paint paint = new Paint();
        paint.setShader((Shader)new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        Bitmap output = Bitmap.createBitmap((int)source.getWidth(), (int)source.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        canvas.drawRoundRect(new RectF((float)this.margin, (float)this.margin, (float)(source.getWidth() - this.margin), (float)(source.getHeight() - this.margin)), (float)this.radius, (float)this.radius, paint);
        if (source != output) {
            source.recycle();
        }
        return output;
    }

    private Bitmap getRoundedCornerBitmap(Bitmap source, int radius, boolean squareTL, boolean squareTR, boolean squareBL, boolean squareBR) {
        int w = source.getWidth();
        int h = source.getHeight();
        Bitmap output = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -12434878;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, w, h);
        RectF rectF = new RectF(rect);
        float roundPx = radius;
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        if (squareTL) {
            canvas.drawRect(0.0f, 0.0f, (float)(w / 2), (float)(h / 2), paint);
        }
        if (squareTR) {
            canvas.drawRect((float)(w / 2), 0.0f, (float)w, (float)(h / 2), paint);
        }
        if (squareBL) {
            canvas.drawRect(0.0f, (float)(h / 2), (float)(w / 2), (float)h, paint);
        }
        if (squareBR) {
            canvas.drawRect((float)(w / 2), (float)(h / 2), (float)w, (float)h, paint);
        }
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        if (source != output) {
            source.recycle();
        }
        return output;
    }

    @Override
    public String key() {
        return this.mTransformationTAG;
    }
}

