/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.animations;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;

public class GenAnimator {
    public static String ROTATE_HORIZONTAL = "rotateHorizontal";
    public static String PRESS_IN_OUT = "pressInOut";
    public static String PRESS_TOP = "pressTop";
    public static String PRESS_LEFT = "pressLeft";
    public static String PRESS_RIGHT = "pressRight";

    public static AnimatorSet clickItemAnimation(View view, int duration, final ViewAnimationListener listener) {
        AnimatorSet cilAnim = new AnimatorSet();
        AnimatorSet clickSet = new AnimatorSet();
        clickSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 0.8f}), ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 0.8f})});
        AnimatorSet unClickSet = new AnimatorSet();
        unClickSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.8f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.8f, 1.0f})});
        cilAnim.playSequentially(new Animator[]{clickSet, unClickSet});
        cilAnim.setDuration((long)duration);
        cilAnim.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        cilAnim.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                if (listener != null) {
                    listener.onAnimationStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (listener != null) {
                    listener.onAnimationEnd();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        cilAnim.start();
        return cilAnim;
    }

    public static AnimatorSet animateLongDurationClick(View view, int duration, final ViewAnimationListener listener) {
        AnimatorSet cilAnim = new AnimatorSet();
        AnimatorSet clickSet = new AnimatorSet();
        clickSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 0.95f}), ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 0.95f})});
        AnimatorSet unClickSet = new AnimatorSet();
        unClickSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.95f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.95f, 1.0f})});
        cilAnim.playSequentially(new Animator[]{clickSet, unClickSet});
        cilAnim.setDuration((long)duration);
        cilAnim.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        cilAnim.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                if (listener != null) {
                    listener.onAnimationStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (listener != null) {
                    listener.onAnimationEnd();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        cilAnim.start();
        return cilAnim;
    }

    public static AnimatorSet animateItem(View view, int duration, final ViewAnimationListener listener) {
        AnimatorSet cilAnim = new AnimatorSet();
        cilAnim.setStartDelay((long)duration);
        AnimatorSet clickSet = new AnimatorSet();
        clickSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 0.8f}), ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 0.8f})});
        AnimatorSet unClickSet = new AnimatorSet();
        unClickSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.8f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.8f, 1.0f})});
        cilAnim.playSequentially(new Animator[]{clickSet, unClickSet});
        cilAnim.setDuration((long)duration);
        cilAnim.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        cilAnim.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                if (listener != null) {
                    listener.onAnimationStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (listener != null) {
                    listener.onAnimationEnd();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        cilAnim.start();
        return cilAnim;
    }

    public static AnimatorSet animateWalking(View view, int duration, float startDistance, float distance, final ViewAnimationListener listener) {
        AnimatorSet result = new AnimatorSet();
        result.setDuration((long)duration);
        result.setInterpolator((TimeInterpolator)new LinearInterpolator());
        result.play((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{startDistance, distance}));
        result.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                if (listener != null) {
                    listener.onAnimationStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (listener != null) {
                    listener.onAnimationEnd();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        result.start();
        return result;
    }

    public static AnimatorSet recycleItemAnimation(View view, final ViewAnimationListener listener) {
        ObjectAnimator anim1 = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.52f, 1.0f});
        anim1.setDuration(250L);
        ObjectAnimator anim2 = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.52f, 1.0f});
        anim2.setDuration(250L);
        ObjectAnimator anim3 = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.2f, 1.0f});
        anim3.setDuration(250L);
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{anim1, anim2, anim3});
        set.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                if (listener != null) {
                    listener.onAnimationStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (listener != null) {
                    listener.onAnimationEnd();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        set.start();
        return set;
    }

    public static AnimatorSet hideTopBar(View view, int slideOffset, int duration, TimeInterpolator timeInterpolator, Animator.AnimatorListener animatorListener) {
        AnimatorSet set = new AnimatorSet();
        set.play((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{0.0f, slideOffset}));
        set.setDuration((long)duration);
        if (timeInterpolator != null) {
            set.setInterpolator(timeInterpolator);
        }
        if (animatorListener != null) {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet showTopBar(View view, int slideOffset, int duration, TimeInterpolator timeInterpolator, Animator.AnimatorListener animatorListener) {
        AnimatorSet set = new AnimatorSet();
        set.play((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{-slideOffset, 0.0f}));
        set.setDuration((long)duration);
        if (timeInterpolator != null) {
            set.setInterpolator(timeInterpolator);
        }
        if (animatorListener != null) {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet playSlideInLeftAnimation(View view, Animator.AnimatorListener animatorListener, int duration) {
        AnimatorSet set = new AnimatorSet();
        int distance = view.getWidth() - view.getLeft();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{-distance, 0.0f})});
        set.setDuration((long)duration);
        set.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        if (animatorListener != null) {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet playSlideInRightAnimation(View view, Animator.AnimatorListener animatorListener, int duration) {
        AnimatorSet set = new AnimatorSet();
        int distance = view.getWidth() - view.getLeft();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{distance, 0.0f})});
        set.setDuration((long)duration);
        set.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        if (animatorListener != null) {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet playSlideOutLeftAnimation(View view, Animator.AnimatorListener animatorListener, int duration) {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{1.0f, 0.0f}), ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{0.0f, -view.getWidth()})});
        set.setDuration((long)duration);
        set.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        if (animatorListener != null) {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet playSlideOutRightAnimation(View view, Animator.AnimatorListener animatorListener, int duration) {
        AnimatorSet set = new AnimatorSet();
        int distance = view.getWidth() - view.getLeft();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{0.0f, distance})});
        set.setDuration((long)duration);
        set.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        if (animatorListener != null) {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet playBounceInRightAnimation(View view, Animator.AnimatorListener animatorListener, int duration) {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{-view.getWidth(), 30.0f, -10.0f, 0.0f}), ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 1.0f, 1.0f, 1.0f})});
        set.setDuration((long)duration);
        set.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        if (animatorListener != null) {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet playBounceInLeftAnimation(View view, Animator.AnimatorListener animatorListener, int duration) {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{view.getWidth(), -30.0f, 10.0f, 0.0f}), ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 1.0f, 1.0f, 1.0f})});
        set.setDuration((long)duration);
        if (animatorListener != null) {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet playStandUpAnimation(View target, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        float x = (target.getWidth() - target.getPaddingLeft() - target.getPaddingRight()) / 2 + target.getPaddingLeft();
        float y = target.getPaddingBottom();
        result.setInterpolator((TimeInterpolator)new LinearInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{x}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{y, y}), ObjectAnimator.ofFloat((Object)target, (String)"rotationX", (float[])new float[]{-15.0f, -30.0f, -15.0f, 0.0f, 15.0f, 0.0f, -15.0f, 0.0f, 10.0f, 0.0f, -10.0f, 0.0f, 5.0f, 0.0f, -5.0f, 0.0f})});
        result.setDuration(750L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playStandUpAnimationBottom(View target, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        float x = (target.getWidth() - target.getPaddingLeft() - target.getPaddingRight()) / 2 + target.getPaddingLeft();
        float y = target.getHeight();
        result.setInterpolator((TimeInterpolator)new LinearInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{x}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{y, y}), ObjectAnimator.ofFloat((Object)target, (String)"rotationX", (float[])new float[]{15.0f, 30.0f, 15.0f, 0.0f, -15.0f, 0.0f, 15.0f, 0.0f})});
        result.setDuration(550L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPressTopAnimation(View target, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        float x = (target.getWidth() - target.getPaddingLeft() - target.getPaddingRight()) / 2 + target.getPaddingLeft();
        float y = target.getHeight();
        result.setInterpolator((TimeInterpolator)new LinearInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{x}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{y}), ObjectAnimator.ofFloat((Object)target, (String)"rotationX", (float[])new float[]{15.0f, 30.0f, 15.0f, 0.0f})});
        result.setDuration(250L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPressLeftAnimation(View target, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        float x = target.getWidth();
        float y = target.getHeight() / 2;
        result.setInterpolator((TimeInterpolator)new LinearInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{x}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{y}), ObjectAnimator.ofFloat((Object)target, (String)"rotationY", (float[])new float[]{-5.0f, -10.0f, -5.0f, 0.0f})});
        result.setDuration(250L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPressRightAnimation(View target, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        float x = 0.0f;
        float y = target.getHeight() / 2;
        result.setInterpolator((TimeInterpolator)new LinearInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{x}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{y}), ObjectAnimator.ofFloat((Object)target, (String)"rotationY", (float[])new float[]{5.0f, 10.0f, 5.0f, 0.0f})});
        result.setDuration(250L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playDropAnimation(View target, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new BounceInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{-target.getHeight(), 0.0f})});
        result.setDuration(800L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playOnBoardingCloudDropAnimation(View target, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new LinearInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{-target.getHeight(), 0.0f})});
        result.setDuration(800L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopOutAnimation(View target, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{0.0f, -target.getHeight()})});
        result.setDuration(450L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopInFromRightBottom(View target, int[] pivot, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        int pivotX = target.getWidth() - pivot[0];
        int pivotY = target.getHeight() - pivot[1];
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{pivotX, pivotX}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{pivotY, pivotY}), ObjectAnimator.ofFloat((Object)target, (String)"scaleX", (float[])new float[]{0.0f, 1.0f}), ObjectAnimator.ofFloat((Object)target, (String)"scaleY", (float[])new float[]{0.0f, 1.0f})});
        result.setDuration(270L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopInFromRightTop(View target, int[] pivot, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        int pivotX = -target.getLeft() + pivot[0];
        int pivotY = -target.getTop() + pivot[1];
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{pivotX, pivotX}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{pivotY, pivotY}), ObjectAnimator.ofFloat((Object)target, (String)"scaleX", (float[])new float[]{0.0f, 1.0f}), ObjectAnimator.ofFloat((Object)target, (String)"scaleY", (float[])new float[]{0.0f, 1.0f})});
        result.setDuration(270L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopOutToRightBottom(View target, int[] pivot, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        int pivotX = target.getWidth() - pivot[0];
        int pivotY = target.getHeight() - pivot[1];
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{pivotX, pivotX}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{pivotY, pivotY}), ObjectAnimator.ofFloat((Object)target, (String)"scaleX", (float[])new float[]{1.0f, 0.0f}), ObjectAnimator.ofFloat((Object)target, (String)"scaleY", (float[])new float[]{1.0f, 0.0f})});
        result.setDuration(320L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopOutToRightTop(View target, int[] pivot, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        int pivotX = -target.getLeft() + pivot[0];
        int pivotY = -target.getTop() + pivot[1];
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{pivotX, pivotX}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{pivotY, pivotY}), ObjectAnimator.ofFloat((Object)target, (String)"scaleX", (float[])new float[]{1.0f, 0.0f}), ObjectAnimator.ofFloat((Object)target, (String)"scaleY", (float[])new float[]{1.0f, 0.0f})});
        result.setDuration(320L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static void closePanelView(View target, long duration, View anchorView, PANEL_TYPE panelType, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        switch (panelType) {
            case LEFT: {
                float distance = anchorView.getWidth();
                result.play((Animator)ObjectAnimator.ofFloat((Object)target, (String)"translationX", (float[])new float[]{0.0f, -distance}));
                break;
            }
            case TOP: {
                float distance = anchorView.getHeight();
                result.play((Animator)ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{0.0f, -distance}));
                break;
            }
            case RIGHT: {
                float distance = anchorView.getWidth();
                result.play((Animator)ObjectAnimator.ofFloat((Object)target, (String)"translationX", (float[])new float[]{0.0f, distance}));
                break;
            }
            case BOTTOM: {
                float distance = anchorView.getHeight();
                result.play((Animator)ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{0.0f, distance}));
                break;
            }
        }
        result.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        result.setDuration(duration);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
    }

    public static void openPanelView(View target, View anchorView, PANEL_TYPE panelType, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        switch (panelType) {
            case LEFT: {
                float distance = -anchorView.getWidth();
                result.play((Animator)ObjectAnimator.ofFloat((Object)target, (String)"translationX", (float[])new float[]{distance, 0.0f}));
                break;
            }
            case TOP: {
                float distance = -anchorView.getHeight();
                result.play((Animator)ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{distance, 0.0f}));
                break;
            }
            case RIGHT: {
                float distance = anchorView.getWidth();
                result.play((Animator)ObjectAnimator.ofFloat((Object)target, (String)"translationX", (float[])new float[]{distance, 0.0f}));
                break;
            }
            case BOTTOM: {
                float distance = anchorView.getHeight();
                result.play((Animator)ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{distance, 0.0f}));
                break;
            }
        }
        result.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        result.setDuration(200L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
    }

    public static AnimatorSet playClickAnimation(View target, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        AnimatorSet clickStart = new AnimatorSet();
        clickStart.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        clickStart.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"scaleX", (float[])new float[]{1.0f, 0.8f}), ObjectAnimator.ofFloat((Object)target, (String)"scaleY", (float[])new float[]{1.0f, 0.8f})});
        clickStart.setDuration(90L);
        AnimatorSet clickEnd = new AnimatorSet();
        clickEnd.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        clickEnd.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"scaleX", (float[])new float[]{0.8f, 1.0f}), ObjectAnimator.ofFloat((Object)target, (String)"scaleY", (float[])new float[]{0.8f, 1.0f})});
        clickEnd.setDuration(90L);
        result.playSequentially(new Animator[]{clickStart, clickEnd});
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPanelButtonClickAnimation(View target, PANEL_TYPE panelType, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        switch (panelType) {
            case LEFT: {
                float pivotX = 0.0f;
                float pivotY = target.getHeight() / 2;
                result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{pivotX, pivotX, pivotX, pivotX}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{pivotY, pivotY, pivotY, pivotY}), ObjectAnimator.ofFloat((Object)target, (String)"rotationY", (float[])new float[]{15.0f, 30.0f, 15.0f, 0.0f})});
                break;
            }
            case TOP: {
                float pivotX = target.getWidth() / 2;
                float pivotY = 0.0f;
                result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{pivotX, pivotX, pivotX, pivotX}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{pivotY, pivotY, pivotY, pivotY}), ObjectAnimator.ofFloat((Object)target, (String)"rotationX", (float[])new float[]{-15.0f, -30.0f, -15.0f, 0.0f})});
                break;
            }
            case RIGHT: {
                float pivotX = target.getWidth();
                float pivotY = target.getHeight() / 2;
                result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{pivotX, pivotX, pivotX, pivotX}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{pivotY, pivotY, pivotY, pivotY}), ObjectAnimator.ofFloat((Object)target, (String)"rotationY", (float[])new float[]{-15.0f, -30.0f, -15.0f, 0.0f})});
                break;
            }
            case BOTTOM: {
                float pivotX = target.getWidth() / 2;
                float pivotY = target.getHeight();
                result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{pivotX, pivotX, pivotX, pivotX}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{pivotY, pivotY, pivotY, pivotY}), ObjectAnimator.ofFloat((Object)target, (String)"rotationX", (float[])new float[]{15.0f, 30.0f, 15.0f, 0.0f})});
                break;
            }
        }
        result.setDuration(200L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playGrowAnimation(View target, long duration, long startDelay, Interpolator interpolator, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"scaleX", (float[])new float[]{0.0f, 1.0f}), ObjectAnimator.ofFloat((Object)target, (String)"scaleY", (float[])new float[]{0.0f, 1.0f})});
        result.setDuration(duration);
        result.setStartDelay(startDelay);
        if (interpolator != null) {
            result.setInterpolator((TimeInterpolator)interpolator);
        }
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playShrinkAnimation(View target, long duration, TimeInterpolator interpolator, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        if (interpolator != null) {
            result.setInterpolator(interpolator);
        }
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"scaleX", (float[])new float[]{1.0f, 0.0f}), ObjectAnimator.ofFloat((Object)target, (String)"scaleY", (float[])new float[]{1.0f, 0.0f})});
        result.setDuration(duration);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet animateHandleClose(View target, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        float pivotX = target.getWidth() / 2;
        float pivotY = target.getHeight() / 2;
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{pivotX}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{pivotY}), ObjectAnimator.ofFloat((Object)target, (String)"rotation", (float[])new float[]{0.0f, 0.0f})});
        result.setDuration(300L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet animateHandleOpen(View target, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        float pivotX = target.getWidth() / 2;
        float pivotY = target.getHeight() / 2;
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{pivotX}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{pivotY}), ObjectAnimator.ofFloat((Object)target, (String)"rotation", (float[])new float[]{0.0f, 0.0f})});
        result.setDuration(300L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet getBanner(View view, int slideOffset, int duration, TimeInterpolator timeInterpolator, Animator.AnimatorListener animatorListener) {
        final AnimatorSet fullAnimSet = new AnimatorSet();
        AnimatorSet side1Set = new AnimatorSet();
        side1Set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 0.5f, 0.5f, 0.5f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 0.5f, 0.5f, 0.5f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"rotation", (float[])new float[]{360.0f, 0.0f}), ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{0.0f, -slideOffset})});
        AnimatorSet side2Set = new AnimatorSet();
        side2Set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 0.5f, 0.5f, 0.5f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 0.5f, 0.5f, 0.5f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"rotation", (float[])new float[]{0.0f, 360.0f}), ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{-slideOffset, 0.0f})});
        side2Set.setStartDelay((long)(duration / 2));
        fullAnimSet.playSequentially(new Animator[]{side1Set, side2Set});
        fullAnimSet.setDuration((long)duration);
        fullAnimSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        fullAnimSet.setStartDelay(1500L);
        if (timeInterpolator != null) {
            fullAnimSet.setInterpolator(timeInterpolator);
        }
        if (animatorListener != null) {
            fullAnimSet.addListener(animatorListener);
        } else {
            fullAnimSet.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animator) {
                }

                public void onAnimationEnd(Animator animator) {
                    fullAnimSet.start();
                }

                public void onAnimationCancel(Animator animator) {
                }

                public void onAnimationRepeat(Animator animator) {
                }
            });
        }
        return fullAnimSet;
    }

    public static void playWormAnimation(final View view) {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 1.1f, 0.2f, 0.6f, 0.5f, 0.5f, 0.5f, 0.5f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 1.1f, 0.2f, 0.6f, 0.5f, 0.5f, 0.5f, 0.5f, 1.0f})});
        set.setDuration(1000L);
        set.setStartDelay(1000L);
        set.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                GenAnimator.playWormAnimation(view);
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        set.start();
    }

    public static AnimatorSet fade(boolean isFadeIn, View view, int duration, Animator.AnimatorListener animatorListener) {
        AnimatorSet set = new AnimatorSet();
        float alphaStart = isFadeIn ? 0.0f : 1.0f;
        float alphaEnd = isFadeIn ? 1.0f : 0.0f;
        set.play((Animator)ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{alphaStart, alphaEnd}));
        set.setDuration((long)duration);
        set.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        if (animatorListener != null) {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet flexiPulseAnimation(View view, int duration, TimeInterpolator timeInterpolator) {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 1.1f, 1.0f, 1.1f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 1.1f, 1.0f, 1.1f, 1.0f})});
        set.setDuration((long)duration);
        if (timeInterpolator != null) {
            set.setInterpolator(timeInterpolator);
        }
        return set;
    }

    public static AnimatorSet flexiSwingAnimation(View view, int duration, TimeInterpolator timeInterpolator) {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"rotation", (float[])new float[]{0.0f, 10.0f, -10.0f, 6.0f, -6.0f, 3.0f, -3.0f, 0.0f})});
        set.setDuration((long)duration);
        if (timeInterpolator != null) {
            set.setInterpolator(timeInterpolator);
        }
        return set;
    }

    public static AnimatorSet flexiBounceAnimation(View view, int duration, TimeInterpolator timeInterpolator) {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{view.getTranslationY(), view.getTranslationY(), view.getTranslationY() - 30.0f, view.getTranslationY(), view.getTranslationY() - 15.0f, view.getTranslationY(), view.getTranslationY()})});
        set.setDuration((long)duration);
        if (timeInterpolator != null) {
            set.setInterpolator(timeInterpolator);
        }
        return set;
    }

    public static AnimatorSet flexiFlashAnimation(View view, int duration, TimeInterpolator timeInterpolator) {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{1.0f, 0.0f, 1.0f, 0.0f, 1.0f})});
        set.setDuration((long)duration);
        if (timeInterpolator != null) {
            set.setInterpolator(timeInterpolator);
        }
        return set;
    }

    public static AnimatorSet flexiTadaAnimation(View view, int duration, TimeInterpolator timeInterpolator) {
        AnimatorSet set = new AnimatorSet();
        ObjectAnimator bounce1 = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{view.getTranslationY(), view.getTranslationY(), view.getTranslationY() - 30.0f, view.getTranslationY(), view.getTranslationY() - 15.0f, view.getTranslationY(), view.getTranslationY()});
        bounce1.setStartDelay(300L);
        ObjectAnimator bounce2 = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{view.getTranslationY(), view.getTranslationY(), view.getTranslationY() - 30.0f, view.getTranslationY(), view.getTranslationY() - 15.0f, view.getTranslationY(), view.getTranslationY()});
        bounce2.setStartDelay(300L);
        AnimatorSet tada = new AnimatorSet();
        tada.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 0.9f, 0.9f, 1.1f, 1.1f, 1.1f, 1.1f, 1.1f, 1.1f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 0.9f, 0.9f, 1.1f, 1.1f, 1.1f, 1.1f, 1.1f, 1.1f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"rotation", (float[])new float[]{0.0f, -3.0f, -3.0f, 3.0f, -3.0f, 3.0f, -3.0f, 3.0f, -3.0f, 0.0f})});
        set.playSequentially(new Animator[]{bounce1, bounce2, tada});
        set.setDuration((long)duration);
        if (timeInterpolator != null) {
            set.setInterpolator(timeInterpolator);
        }
        return set;
    }

    public static interface ViewAnimationListener {
        public void onAnimationEnd();

        public void onAnimationStart();
    }
}

