/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.dialogs;

import android.animation.Animator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.dialogs.ParentalLockLayoutGenerator;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.ImageAssetsUtils;
import com.kidoz.sdk.api.general.assets_handling.StringAssetsUtils;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.general.utils.SdkToast;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.LockIconData;
import com.kidoz.sdk.api.ui_views.parental_lock.LockIconsAdapter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;

public class ParentalLockDialog
extends BaseDialog {
    private static final int DIALOG_BACKGROUND = Color.parseColor((String)"#0fcaf7");
    private static final int DIALOG_BACKGROUND_CORNER_RADIUS = 4;
    private final String TAG = ParentalLockDialog.class.getSimpleName();
    public static final String PARENTAL_LOCK_ACTIVE_KEY = "PARENTAL_LOCK_ACTIVE_KEY";
    public static final float PIVOT_X_FACTOR = 0.722f;
    public static final float PIVOT_Y_FACTOR = 0.04f;
    private final int NUMBER_OF_COLUMNS = 4;
    private int[] mPopLocation;
    private View mRootView;
    private LockIconsAdapter mAdapter;
    private TextView mDialogMessage;
    private TextView mDialogTitleTextView;
    private ArrayList<LockIconData> mContent;
    private int[] mLockCombination;
    private boolean mIsFirstLockIconCorrect;
    private boolean mIsLockActive;
    private ParentLockDialogListener mParentLockDialogListener;
    private boolean mIsGateToGooglePlay;
    private boolean mIsLockChangeSuccessfully;
    private RelativeLayout mInnerViewContainer;
    private TextView mFeedbackMessage;
    private TextView mFeedbackMessageAction;
    private View mFeedbackMessageContainer;
    private View mAnimatableView;
    private int mCounter;
    private RecyclerView mCustomRecyclerView;
    private Handler mHandler;

    public ParentalLockDialog(Context context, boolean isGateToGooglePlay, int[] popLocation) {
        super(context, 0x1030011);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.requestWindowFeature(1);
        this.mPopLocation = popLocation;
        this.mIsGateToGooglePlay = isGateToGooglePlay;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mRootView = ParentalLockLayoutGenerator.generateParentalLockView(this.getContext());
        this.setContentView(this.mRootView);
        this.initDialog();
    }

    private void initDialog() {
        this.mHandler = new Handler();
        this.initDialogBackgroundView();
        this.initParameters();
        this.initTitle();
        this.initDialogWidth();
        this.initExitButton();
        this.initRecyclerView();
        this.initMessageTextView();
        this.initFeedbackMessageView();
        this.prepareDialog();
        this.mCounter = 0;
    }

    private void initDialogBackgroundView() {
        KidozCardView kidozCardView = (KidozCardView)this.mRootView.findViewById(ParentalLockLayoutGenerator.PARENTAL_CARDVIEW_ID);
        kidozCardView.setRadius(Utils.dpTOpx(this.getContext(), 4.0f));
        kidozCardView.setCardBackgroundColor(DIALOG_BACKGROUND);
    }

    private void initFeedbackMessageView() {
        this.mFeedbackMessageContainer = this.mRootView.findViewById(ParentalLockLayoutGenerator.FEEDBACK_MESSAGE_CONTAINER_ID);
        this.mFeedbackMessageContainer.setSoundEffectsEnabled(false);
        this.mFeedbackMessageContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ParentalLockDialog.this.prepareDialog();
                if (ParentalLockDialog.this.mIsLockChangeSuccessfully) {
                    ParentalLockDialog.this.mIsLockChangeSuccessfully = false;
                }
                ParentalLockDialog.this.animateFeedBackMessageBack();
            }
        });
        this.mFeedbackMessage = (TextView)this.mRootView.findViewById(ParentalLockLayoutGenerator.FEEDBACK_MESSAGE_TEXT_VIEW_ID);
        this.mFeedbackMessageAction = (TextView)this.mRootView.findViewById(ParentalLockLayoutGenerator.FEEDBACK_ACTION_TEXT_VIEW_ID);
        int availableSpace = Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false));
        if (ScreenUtils.getIsTablet(this.getContext())) {
            availableSpace = (int)(0.8f * (float)availableSpace);
        }
        int itemSize = availableSpace / 4;
        this.mInnerViewContainer = (RelativeLayout)this.mRootView.findViewById(ParentalLockLayoutGenerator.INNER_VIEW_CONTAINER_ID);
        this.mInnerViewContainer.getLayoutParams().width = availableSpace;
        this.mInnerViewContainer.getLayoutParams().height = (int)((float)itemSize * 1.7f);
    }

    private void initTitle() {
        this.mDialogTitleTextView = (TextView)this.mRootView.findViewById(ParentalLockLayoutGenerator.PARENTAL_DIALOG_TITLE_ID);
    }

    private void initDialogWidth() {
        this.mAnimatableView = this.mRootView.findViewById(ParentalLockLayoutGenerator.ANIMATABLE_VIEW);
        this.mAnimatableView.getLayoutParams().width = !ScreenUtils.getIsTablet(this.getContext()) ? Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false)) : (int)(0.8f * (float)Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false)));
    }

    private void initParameters() {
        this.mContent = new ArrayList();
        JSONArray jSONArray = ImageAssetsUtils.loadParentalLockConfigurationFile(this.getContext());
        if (jSONArray != null && jSONArray.length() > 0) {
            for (int lockIconIndex = 0; lockIconIndex < jSONArray.length(); ++lockIconIndex) {
                try {
                    JSONObject nextJSONObject = jSONArray.getJSONObject(lockIconIndex);
                    LockIconData nextLockIconData = new LockIconData(this.getContext(), nextJSONObject);
                    this.mContent.add(nextLockIconData);
                    continue;
                }
                catch (Exception ex) {
                    if (ex == null) continue;
                    SDKLogger.printErrorLog(this.TAG, "Error when trying to parse configuration JSON:" + ex.getMessage());
                }
            }
        }
    }

    private void prepareDialog() {
        try {
            if (this.mContent != null && !this.mContent.isEmpty()) {
                this.mIsLockActive = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), PARENTAL_LOCK_ACTIVE_KEY) != null;
                this.mIsFirstLockIconCorrect = false;
                this.mLockCombination = new int[2];
                Random random = new Random();
                while (this.mLockCombination[0] == this.mLockCombination[1]) {
                    this.mLockCombination[0] = random.nextInt(this.mContent.size());
                    if (this.mLockCombination[0] == this.mContent.size()) {
                        this.mLockCombination[0] = this.mLockCombination[0] - 1;
                    }
                    this.mLockCombination[1] = random.nextInt(this.mContent.size());
                    if (this.mLockCombination[1] != this.mContent.size()) continue;
                    this.mLockCombination[1] = this.mLockCombination[1] - 1;
                }
                if (this.mIsGateToGooglePlay) {
                    this.mDialogTitleTextView.setText((CharSequence)StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogTitleForGooglePlay"));
                } else if (this.mIsLockActive) {
                    this.mDialogTitleTextView.setText((CharSequence)StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogTitleDeActivate"));
                } else {
                    this.mDialogTitleTextView.setText((CharSequence)StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogTitleActivate"));
                }
                String name_1 = this.mContent.get(this.mLockCombination[0]).getName().toUpperCase();
                String name_2 = this.mContent.get(this.mLockCombination[1]).getName().toUpperCase();
                if (this.mIsGateToGooglePlay) {
                    this.mDialogMessage.setText((CharSequence)String.format(Locale.getDefault(), StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogMessageGooglePlayGate"), name_1, name_2));
                } else if (this.mIsLockActive) {
                    this.mDialogMessage.setText((CharSequence)String.format(Locale.getDefault(), StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogMessageParentalLockDeactivation"), name_1, name_2));
                } else {
                    this.mDialogMessage.setText((CharSequence)String.format(Locale.getDefault(), StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogMessageParentalLockActivation"), name_1, name_2));
                }
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to prepareDialog: " + ex.getMessage());
        }
    }

    private void initMessageTextView() {
        this.mDialogMessage = (TextView)this.mRootView.findViewById(ParentalLockLayoutGenerator.PARENTAL_LOCK_DIALOG_MESSAGE_TEXTVIEW_ID);
    }

    private void initExitButton() {
        this.mRootView.findViewById(ParentalLockLayoutGenerator.EXIT_BUTTON_ID).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SdkAnimationsUtils.animateClick(view, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        ParentalLockDialog.this.closeParentalDialog();
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        });
    }

    private void initRecyclerView() {
        int availableSpace = Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false));
        if (ScreenUtils.getIsTablet(this.getContext())) {
            availableSpace = (int)(0.8f * (float)availableSpace);
        }
        int itemSize = availableSpace / 4;
        int padding = Utils.dpTOpx(this.getContext(), 25.0f);
        this.mAdapter = new LockIconsAdapter();
        this.mAdapter.setLockIconAdapterListener(new LockIconsAdapter.LockIconAdapterListener(){

            @Override
            public void onLockIconClick(int index) {
                try {
                    if (!ParentalLockDialog.this.mIsFirstLockIconCorrect) {
                        if (index == ParentalLockDialog.this.mLockCombination[0]) {
                            ParentalLockDialog.this.mIsFirstLockIconCorrect = true;
                        } else {
                            ParentalLockDialog.this.animateFeedBackMessageError();
                        }
                    } else if (index == ParentalLockDialog.this.mLockCombination[1]) {
                        ParentalLockDialog.this.mIsLockChangeSuccessfully = true;
                        if (ParentalLockDialog.this.mIsGateToGooglePlay) {
                            ParentalLockDialog.this.closeParentalDialog();
                        } else {
                            if (ParentalLockDialog.this.mIsLockActive) {
                                SharedPreferencesUtils.removeSharedPreferencesData(ParentalLockDialog.this.getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY);
                            } else {
                                SharedPreferencesUtils.saveSharedPreferencesData(ParentalLockDialog.this.getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY, ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY);
                            }
                            ParentalLockDialog.this.animateFeedBackMessageSuccess(ParentalLockDialog.this.mIsLockActive);
                            if (ParentalLockDialog.this.mParentLockDialogListener != null) {
                                ParentalLockDialog.this.mParentLockDialogListener.onPasswordEntered(true);
                                EventManager.getInstance(ParentalLockDialog.this.getContext()).LogEventWithIntField(ParentalLockDialog.this.getContext(), null, null, EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Correct Password", null, ParentalLockDialog.this.mCounter);
                            }
                        }
                        if (ParentalLockDialog.this.mParentLockDialogListener != null) {
                            ParentalLockDialog.this.mParentLockDialogListener.onPasswordEntered(true);
                            ParentalLockDialog.this.mCounter = ParentalLockDialog.this.mCounter + 1;
                            EventManager.getInstance(ParentalLockDialog.this.getContext()).LogEventWithIntField(ParentalLockDialog.this.getContext(), null, null, EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Correct Password", null, ParentalLockDialog.this.mCounter);
                        }
                    } else {
                        ParentalLockDialog.this.animateFeedBackMessageError();
                    }
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(ParentalLockDialog.this.TAG, "Error when trying to handle lock icon click: " + ex.getMessage());
                }
            }
        });
        this.mCustomRecyclerView = (RecyclerView)this.mRootView.findViewById(ParentalLockLayoutGenerator.RECYCLER_VIEW_ID);
        GridLayoutManager layoutManager = new GridLayoutManager(this.getContext(), 4);
        this.mCustomRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mCustomRecyclerView.setPadding(padding, 0, padding, 0);
        this.mCustomRecyclerView.setHasFixedSize(true);
        this.mCustomRecyclerView.getLayoutParams().width = availableSpace;
        this.mCustomRecyclerView.getLayoutParams().height = itemSize * 2;
        this.mCustomRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
    }

    protected void onStart() {
        super.onStart();
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                ParentalLockDialog.this.mAdapter.setContent(ParentalLockDialog.this.mContent);
            }
        }, 300L);
    }

    @Override
    public void show() {
        super.openDialog();
        EventManager.getInstance(this.getContext()).LogEventWithIntField(this.getContext(), null, null, EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Dialog Show", null, this.mCounter);
        this.mAnimatableView.setVisibility(4);
        Utils.setOnGlobalLayoutFinishListener(this.mAnimatableView, new Utils.OnGlobalLayoutFinishedListener(){

            @Override
            public void onLayoutFinished() {
                if (ParentalLockDialog.this.mPopLocation != null) {
                    GenAnimator.playPopInFromRightTop(ParentalLockDialog.this.mAnimatableView, ParentalLockDialog.this.mPopLocation, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                            ParentalLockDialog.this.mAnimatableView.setVisibility(0);
                        }

                        public void onAnimationEnd(Animator animation) {
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                } else {
                    ParentalLockDialog.this.mAnimatableView.setVisibility(0);
                }
            }
        });
    }

    public void closeParentalDialog() {
        this.mHandler.removeCallbacksAndMessages(null);
        if (this.mPopLocation != null) {
            GenAnimator.playPopOutToRightTop(this.mAnimatableView, this.mPopLocation, new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (ParentalLockDialog.this.mParentLockDialogListener != null) {
                        ParentalLockDialog.this.mParentLockDialogListener.onPasswordEntered(false);
                    }
                    EventManager.getInstance((Context)ParentalLockDialog.this.mCallingActivity).LogEventWithIntField((Context)ParentalLockDialog.this.mCallingActivity, null, null, EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Dialog Dismiss", null, ParentalLockDialog.this.mCounter);
                    ParentalLockDialog.this.closeDialog();
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        } else {
            if (this.mParentLockDialogListener != null) {
                this.mParentLockDialogListener.onPasswordEntered(false);
            }
            EventManager.getInstance((Context)this.mCallingActivity).LogEventWithIntField((Context)this.mCallingActivity, null, null, EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Dialog Dismiss", null, this.mCounter);
            this.closeDialog();
        }
    }

    @Override
    public void closeDialog() {
        try {
            Intent intent = new Intent();
            intent.setAction("PARENTAL_DIALOG_CLOSE");
            LocalBroadcastManager.getInstance((Context)this.getContext()).sendBroadcast(intent);
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to send parental dialog close message: " + ex.getMessage());
        }
        super.closeDialog();
    }

    public void setParentLockDialogListener(ParentLockDialogListener parentLockDialogListener) {
        this.mParentLockDialogListener = parentLockDialogListener;
    }

    private void animateFeedBackMessageError() {
        ++this.mCounter;
        EventManager.getInstance(this.getContext()).LogEventWithIntField(this.getContext(), null, null, EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Incorrect Password", null, this.mCounter);
        String tryAgain = StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogWrongSelectionTryAgain");
        String wrongSelection = StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogWrongSelection");
        SpannableString messageTextError = new SpannableString((CharSequence)wrongSelection);
        SpannableString messageActionTryAgain = new SpannableString((CharSequence)tryAgain);
        messageActionTryAgain.setSpan((Object)new StyleSpan(1), 0, messageActionTryAgain.length(), 0);
        this.mFeedbackMessage.setText((CharSequence)messageTextError);
        this.mFeedbackMessageAction.setText((CharSequence)messageActionTryAgain);
        this.mFeedbackMessageContainer.setVisibility(0);
        this.mCustomRecyclerView.setVisibility(4);
    }

    private void animateFeedBackMessageSuccess(boolean mIsLockActive) {
        if (mIsLockActive) {
            this.closeParentalDialog();
            SdkToast.getSdkInstance(this.getContext()).showToast(StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogLockDeactivatedTitle"), 1);
        } else {
            this.closeParentalDialog();
            SdkToast.getSdkInstance(this.getContext()).showToast(StringAssetsUtils.getLangString(this.getContext(), "parentalLockDialogLockActivatedTitle"), 1);
        }
        this.mFeedbackMessageContainer.setVisibility(0);
        this.mCustomRecyclerView.setVisibility(4);
    }

    private void animateFeedBackMessageBack() {
        this.mFeedbackMessageContainer.setVisibility(4);
        this.mCustomRecyclerView.setVisibility(0);
    }

    public static boolean getIsCanShowDialog(Context context) {
        boolean result = false;
        JSONArray jSONArray = ImageAssetsUtils.loadParentalLockConfigurationFile(context);
        if (jSONArray != null && jSONArray.length() > 0) {
            result = true;
        }
        return result;
    }

    public static interface ParentLockDialogListener {
        public void onPasswordEntered(boolean var1);
    }
}

