/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.util.Log;
import android.widget.Toast;
import com.kidoz.events.DeviceUtils;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.CookieManager;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.video_player.VideoManager;
import com.kidoz.sdk.api.receivers.SdkReceiver;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import com.kidoz.sdk.api.server_connect.StreamToStringConverter;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;
import com.kidoz.sdk.api.ui_views.interstitial.IntrstWrapper;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONObject;

public final class KidozSDK {
    private static final String TAG = KidozSDK.class.getSimpleName();
    private static boolean isInitialized = false;
    private static String mPublisherId = null;
    private static String mSecurityKey = null;
    private static boolean isDeveloperLoggingON = false;

    public static void initialize(final Context context, String publisher_id, String token) {
        if (publisher_id == null || token == null) {
            throw new RuntimeException("Missing valid Publisher Id or security token!");
        }
        try {
            Long.parseLong(publisher_id);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid publisher id! Please check you publisher id..");
        }
        if (token.length() > 48) {
            throw new RuntimeException("Invalid Security Token! Please recheck you security token..");
        }
        if (publisher_id != null && (publisher_id.equals("5") || publisher_id.equals("7") || publisher_id.equals("8")) && context != null) {
            if (context instanceof Activity) {
                ((Activity)context).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)context, (CharSequence)("Notice ! You are using Demo PUBLISHER ID ! " + context.getPackageName()), (int)1).show();
                    }
                });
            } else {
                Log.e((String)"[KIDOZ SDK]", (String)("Notice ! You are using Demo PUBLISHER ID ! , Package Name :" + context.getPackageName()));
            }
        }
        if (ConstantDef.SDK_EXTENSION_TYPE == ConstantDef.EXTENSION_TYPE_ANDROID || ConstantDef.SDK_EXTENSION_TYPE == ConstantDef.EXTENSION_TYPE_ECLIPSE || ConstantDef.SDK_EXTENSION_TYPE == ConstantDef.EXTENSION_TYPE_COCOS_DX) {
            KidozSDK.checkManifestDeclarations(context);
        }
        try {
            DeviceUtils.getGoogleAdvertisingID(context);
            Utils.preInitiate(context);
            SharedPreferences eventsPref = context.getSharedPreferences("events_shared_preferences", 0);
            long sessionID = eventsPref.getLong("last_session_id", 0L);
            SharedPreferences.Editor editor = eventsPref.edit();
            editor.putLong("last_session_id", ++sessionID);
            editor.apply();
            JSONObject eventParams = new JSONObject();
            eventParams.put("DeveloperID", (Object)publisher_id);
            eventParams.put("log_level", EventManager.LOG_NORMAL_LEVEL);
            eventParams.put("SessionID", sessionID);
            EventManager.getInstance(context).init(context, eventParams);
            EventManager.getInstance(context).logEvent(context, null, null, EventManager.LOG_CRITICAL_LEVEL, "Session", "Session Start", publisher_id);
            CookieManager.resetStorage(context, null, StorageLife.SESSION);
            if (isInitialized) {
                EventManager.getInstance(context).logEvent(context, null, null, EventManager.LOG_CRITICAL_LEVEL, "SDK", "SDK Already Initiated", publisher_id);
            }
            SharedPreferencesUtils.saveSharedPreferencesData(context, "PUBLISHER_ID", publisher_id);
            mPublisherId = publisher_id;
            mSecurityKey = token;
            SdkAPIManager.init(context, publisher_id, token, isDeveloperLoggingON);
            KidozSDK.validateSDKConfiguration(context, publisher_id);
            EventManager.getInstance(context).startEventsSync(context);
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error initiating " + ex.getMessage());
        }
    }

    private static SdkAPIManager getApiManager(Context context) {
        SdkAPIManager.init(context, mPublisherId, mSecurityKey, isDeveloperLoggingON);
        return SdkAPIManager.getSdkApiInstance(context);
    }

    public static boolean isInitialised() {
        return isInitialized;
    }

    private static void validateSDKConfiguration(final Context context, final String publicher_id) {
        SDKLogger.printDebbugLog(TAG, ">>>> initSdk");
        if (context != null) {
            PropertiesObj appConfig = DatabaseManager.getInstance(context).getConfigTable().loadAppProperties();
            if (appConfig != null) {
                EventManager.SDK_STYLE_VERSION_NUM = appConfig.getSdkStyleVersion();
            }
            KidozSDK.getApiManager(context).initSdk(context, new ApiResultCallback<PropertiesObj>(){

                @Override
                public void onServerResult(ResultData<?> result) {
                    if (result != null && result.getResponseStatus() != null && result.getResponseStatus().getIsSuccessful() && result.getData() != null && result.getData() instanceof PropertiesObj) {
                        PropertiesObj serverConfig = (PropertiesObj)result.getData();
                        PropertiesObj appConfig = DatabaseManager.getInstance(context).getConfigTable().loadAppProperties();
                        boolean clearHtmlCache = true;
                        if (appConfig == null) {
                            PropertiesObj prop = new PropertiesObj(serverConfig.getData());
                            prop.setConfigVersion(-1);
                            DatabaseManager.getInstance(context).getConfigTable().insertAppProperties(prop);
                        } else {
                            if (appConfig.getHtmlLoaderDefaultLink() != null && appConfig.getHtmlLoaderDefaultLink().equals(serverConfig.getHtmlLoaderDefaultLink())) {
                                clearHtmlCache = false;
                            }
                            appConfig.updateConfigFromData(serverConfig);
                            DatabaseManager.getInstance(context).getConfigTable().insertAppProperties(appConfig);
                        }
                        if (serverConfig != null) {
                            EventManager.SDK_STYLE_VERSION_NUM = serverConfig.getSdkStyleVersion();
                        }
                        if (appConfig == null || appConfig.getConfigVersion() < serverConfig.getConfigVersion()) {
                            KidozSDK.getApiManager(context).getSDKResources(context, new ApiResultCallback<Boolean>(){

                                @Override
                                public void onServerResult(ResultData<?> result) {
                                    if (result != null && result.getResponseStatus() != null && result.getResponseStatus().getIsSuccessful() && result.getData() != null && result.getData() instanceof Boolean && ((Boolean)result.getData()).booleanValue()) {
                                        SharedPreferencesUtils.removeSharedPreferencesData(context, "IMAGE_ASSETS_SYNCED_FLAG");
                                        SharedPreferencesUtils.removeSharedPreferencesData(context, "PARENTAL_LOCK_ASSETS_SYNCED_FLAG");
                                        SharedPreferencesUtils.removeSharedPreferencesData(context, "SOUND_ASSETS_SYNCED_FLAG");
                                    }
                                }

                                @Override
                                public void onFailed() {
                                }
                            });
                        }
                        VideoManager.getInstance(context);
                        HtmlViewWrapper viewWrapper = HtmlManager.initDefaultHtmlView(context, clearHtmlCache);
                        viewWrapper.setHtmlWebViewListener(new IOnHtmlWebViewInterface(){

                            @Override
                            public void onHtmlFinishedLoading() {
                                super.onHtmlFinishedLoading();
                                isInitialized = true;
                                IntrstWrapper.initInstance(context);
                                EventManager.getInstance(context).logEvent(context, null, null, EventManager.LOG_CRITICAL_LEVEL, "SDK", "SDK Init", publicher_id);
                                EventMessage eventMessage = new EventMessage(EventMessage.MessageType.INIT_SDK);
                                EventBus.getDefault().post((Object)eventMessage);
                            }
                        });
                        viewWrapper.loadHtml(serverConfig.getHtmlLoaderDefaultLink());
                        if (isDeveloperLoggingON) {
                            Log.d((String)"[KIDOZ SDK]", (String)"Kidoz SDK has been successfully Initialized !");
                        }
                    }
                }

                @Override
                public void onFailed() {
                }
            });
        }
    }

    private static void checkManifestDeclarations(Context context) {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        List resolveInfo = packageManager.queryBroadcastReceivers(intent = new Intent(context, SdkReceiver.class), 131072);
        if (resolveInfo == null || resolveInfo.size() == 0) {
            throw new RuntimeException("Missing Android Manifest declaration ! \nPlease add the following lines to your Manifest.xml file..\n...\n<receiver android:name=\"com.kidoz.sdk.api.receivers.SdkReceiver\">\n    <intent-filter>\n         <action android:name=\"android.intent.action.PACKAGE_ADDED\" />\n         <data android:scheme=\"package\" />\n    </intent-filter>\n</receiver> \n...\n");
        }
    }

    public static void setLoggingEnabled(boolean enabled) {
        isDeveloperLoggingON = enabled;
    }

    public static String getPublisherID() {
        return mPublisherId;
    }

    public static String getAuthToken() {
        return mSecurityKey;
    }

    public static String getSDKVersion() {
        return "0.6.0";
    }

    static {
        try {
            InputStream is = KidozSDK.class.getClassLoader().getResourceAsStream("build_properties.txt");
            if (is != null) {
                String value = StreamToStringConverter.readStream(new BufferedInputStream(is), null, false);
                ConstantDef.SDK_EXTENSION_TYPE = Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            ConstantDef.SDK_EXTENSION_TYPE = ConstantDef.EXTENSION_TYPE_ANDROID;
        }
    }
}

