package com.kidoz.sdk.api.ui_views.video_unit;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Looper;
import android.support.v4.content.LocalBroadcastManager;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.kidoz.events.DeviceUtils;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.fullscreen_video_layer.FullScreenVideoEnabledWebChromeClient;
import com.kidoz.sdk.api.fullscreen_video_layer.FullScreenVideoEnabledWebView;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

import java.util.Locale;

/**
 * Created by RonyBrosh on 8/24/2016.
 */
public class VideoUnit
{
    public static final String TAG = VideoUnit.class.getSimpleName();

    private Context mContext;
    public static FullScreenVideoEnabledWebView mWebView;
    private Utils.StaticHandler mExecutionHandler = new Utils.StaticHandler(Looper.getMainLooper());

    public static VideoUnitListener sVideoUnitListener;
    private String mStyleID = "";
    private String mWidgetType = WidgetType.WIDGET_TYPE_VIDEO_UNIT.getStringValue();
    private boolean mIsCanShow = false;

    public VideoUnit(Context context)
    {
        SDKLogger.printDebbugLog(TAG, "VideoUnit");
        mContext = context;
        load();
    }

    public void setVideoUnitListener(VideoUnitListener videoUnitListener)
    {
        sVideoUnitListener = videoUnitListener;
    }

    public boolean getIsReady()
    {
        boolean isKidozInitialised = KidozSDK.isInitialised();
        SDKLogger.printDebbugLog(TAG, "getIsReady: isKidozInitialised = " + Boolean.toString(isKidozInitialised));
        SDKLogger.printDebbugLog(TAG, "getIsReady: mIsCanShow = " + Boolean.toString(mIsCanShow));
        return mIsCanShow && isKidozInitialised;
    }

    public void load()
    {
        SDKLogger.printDebbugLog(TAG, "load");
        if (KidozSDK.isInitialised() == true)
        {
            initVideoUnit();
        }
        else
        {
            if (EventBus.getDefault().isRegistered(this) == false)
            {
                EventBus.getDefault().register(this);
            }
        }
    }

    public void show()
    {
        SDKLogger.printDebbugLog(TAG, "show");
        Intent intent = new Intent(mContext, VideoUnitActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT | Intent.FLAG_ACTIVITY_SINGLE_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);
        mContext.startActivity(intent);
    }

    private void initVideoUnit()
    {
        SDKLogger.printDebbugLog(TAG, "initVideoUnit");
        if (EventBus.getDefault().isRegistered(this))
        {
            EventBus.getDefault().unregister(this);
        }

        initWebView();
    }

    private void initWebView()
    {
        SDKLogger.printDebbugLog(TAG, "initWebView");

        mWebView = new FullScreenVideoEnabledWebView(mContext);
        mWebView.initWebViewSettings();
        mWebView.addJavascriptInterface(new VideoUnitJavascriptInterface(), "VideoUnit");

        StringBuilder stringBuilder = new StringBuilder();
        PropertiesObj propertiesObj = DatabaseManager.getInstance(mContext).getConfigTable().loadAppProperties();
        if (propertiesObj != null)
        {

            String videoUnitURL = propertiesObj.getVideoUnitURL();
            //                        String videoUnitURL = "http://s3.amazonaws.com/kidoz.test.bucket/ronybrosh/VIDEO_UNIT/VideoUnit.html";

            if (videoUnitURL.contains("?") == false)
            {
                videoUnitURL += "?";
            }
            stringBuilder.append(videoUnitURL);
        }

        String appVersionCode = "";
        String appVersionName = "";
        try
        {
            PackageManager packageManager = mContext.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(mContext.getPackageName(), 0);
            appVersionCode = String.valueOf(packageInfo.versionCode);
            appVersionName = packageInfo.versionName;
        }
        catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to get app version name and code: " + ex.getMessage());
        }


        stringBuilder.append("app_version_code=" + appVersionCode);
        stringBuilder.append("&app_version_name=" + appVersionName);
        stringBuilder.append("&publisher_id=" + KidozSDK.getPublisherID());
        stringBuilder.append("&device_lang=" + Locale.getDefault().getLanguage());
        stringBuilder.append("&style_id=" + mStyleID);
        stringBuilder.append("&actual_sdk_version=" + String.valueOf(ConstantDef.ACTUAL_SDK_VERSION));
        stringBuilder.append("&extension_type=" + String.valueOf(ConstantDef.SDK_EXTENSION_TYPE));
        stringBuilder.append("&package_id=" + mContext.getPackageName());
        stringBuilder.append("&sdk_version=" + ConstantDef.SDK_VERSION);
        stringBuilder.append("&os_version=" + Build.VERSION.SDK_INT);
        stringBuilder.append("&os_type=" + "android");
        if (Utils.getIsDeviceTablet(mContext))
        {
            stringBuilder.append("&device_type=" + "2");
        }
        else
        {
            stringBuilder.append("&device_type=" + "1");
        }
        String webviewVersion = "w";
        String useragent = Utils.getDefaultUserAgent();
        if (useragent != null && useragent.contains("Chrome"))
        {
            int index = useragent.indexOf("Chrome");
            String sub = useragent.substring(index, useragent.length());
            String[] res = sub.split(" ");
            if (res != null && res.length > 0)
            {
                String[] tempVal = res[0].split("/");
                if (tempVal != null && tempVal.length > 1)
                {
                    webviewVersion = "c_" + tempVal[1];
                }
            }
        }

        stringBuilder.append("&webview_version=" + webviewVersion);
        stringBuilder.append("&device_hash=" + Utils.generateUniqeDeviceID(mContext.getPackageName(), KidozSDK.getPublisherID()));
        stringBuilder.append("&widget_type=" + mWidgetType);
        stringBuilder.append("&auth_token=" + KidozSDK.getAuthToken());
        stringBuilder.append("&gid=" + DeviceUtils.getGoogleAdvertisingID(mContext));

        SharedPreferences sharedPreferences = mContext.getSharedPreferences(EventManager.EVENTS_SHARED_PREFERENCES_KEY, 0);
        long appSessionID = sharedPreferences.getLong(EventManager.EVENTS_LAST_SESSION_ID_KEY, 0);
        stringBuilder.append("&appSessionID=" + appSessionID);

        mWebView.setWebViewClient(new WebViewClient()
        {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url)
            {
                SDKLogger.printDebbugLog(TAG, "shouldOverrideUrlLoading: URL = " + url);
                return true;
            }
        });

        FullScreenVideoEnabledWebChromeClient webChromeClient = new FullScreenVideoEnabledWebChromeClient(null, null, null, mWebView)
        {

        };
        webChromeClient.setOnToggledFullscreen(new FullScreenVideoEnabledWebChromeClient.ToggledFullscreenCallback()
        {
            @Override
            public void toggledFullscreen(boolean fullscreen)
            {

            }
        });
        mWebView.setWebChromeClient(webChromeClient);

        mWebView.loadUrl(stringBuilder.toString());
        SDKLogger.printDebbugLog(TAG, "initWebView URL = " + stringBuilder.toString());
    }

    public class VideoUnitJavascriptInterface
    {
        @android.webkit.JavascriptInterface
        public void onVideoUnitReady()
        {
            SDKLogger.printDebbugLog(TAG, "onVideoUnitReady");
            mIsCanShow = true;
            if (sVideoUnitListener != null)
            {
                mExecutionHandler.post(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        sVideoUnitListener.onReady();
                    }
                });
            }
        }

        @android.webkit.JavascriptInterface
        public void onCloseVideoUnit()
        {
            Intent intent = new Intent();
            intent.setAction("CloseVideoUnit");
            LocalBroadcastManager.getInstance(mContext).sendBroadcast(intent);
        }

        @android.webkit.JavascriptInterface
        public void forwardToGooglePlay(final String advertiserID, final String appID, final String googlePlayLink, final String widgetType, final String styleID, final String itemIndex)
        {
            mExecutionHandler.post(new Runnable()
            {
                @Override
                public void run()
                {
                    if (VideoUnitActivity.sVideoUnitActivityListener != null)
                    {
                        VideoUnitActivity.sVideoUnitActivityListener.forwardToGooglePlay(advertiserID, appID, googlePlayLink, widgetType, styleID, itemIndex);
                    }
                }
            });
        }
    }

    @Subscribe
    public void onHandleEvent(EventMessage event)
    {
        SDKLogger.printDebbugLog(TAG, "onHandleEvent");
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK)
        {
            if (EventBus.getDefault().isRegistered(this))
            {
                EventBus.getDefault().unregister(this);
            }
            initVideoUnit();
        }
    }

    public interface VideoUnitListener
    {
        void onReady();

        void onOpen();

        void onClose();
    }
}
