package com.kidoz.sdk.api.ui_views.panel_view;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.PanelView;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.custom_drawables.ShadowView;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.one_item_view.OneItemFamilyView;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;

import org.json.JSONObject;

import java.util.ArrayList;

public class FamilyPanelView extends AbstractPanelView
{
    public static final float ITEM_WIDTH = 660f;
    public static final float ITEM_HEIGHT = 420f;

    public static final String TAG = FamilyPanelView.class.getSimpleName();
    private static final int DEFAULT_CORNER_RADIUS = 4;
    protected int mBtnAnimType = 1;

    protected AssetView mNextButton;
    protected AssetView mGifView;

    protected int mViewPagerWidth;
    protected int mViewPagerHeight;

    public FamilyPanelView(Context context, JSONObject jsonObject)
    {
        super(context, jsonObject);

        float SCALE_FACTOR = ScreenUtils.getScaleFactor(getContext());
        mViewPagerWidth = (int) (ITEM_WIDTH * SCALE_FACTOR);
        mViewPagerHeight = (int) (ITEM_HEIGHT * SCALE_FACTOR);
    }

    @Override
    protected void prepareProperties()
    {
        super.prepareProperties();
        mBtnAnimType = mWidgetProperties.optInt(NEXT_BTN_ANIMATION_TYPE, 1);
    }

    @Override
    protected void initInnerPanelView()
    {
        mOneItemFamilyView = new OneItemFamilyView(getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), mStyleId, mWidgetProperties, new OneItemFamilyView.IOnOneItemActionListener()
        {
            @Override
            public void onAction(OneItemFamilyView.OneItemAction action)
            {
                switch (action)
                {
                    case STOP_ANY_ANIMATION:
                    {
                        mGifView.stopGifAnim();
                        break;
                    }

                    case RESTART_ANY_ANIMATION:
                    {
                        mGifView.startGifAnim();
                        break;
                    }

                    case ON_RESET_AUTO_LAUNCH:
                    {
                        getStaticHandler().removeCallbacksAndMessages(null);
                        break;
                    }
                }
            }
        });
        mOneItemFamilyView.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        params.setMargins(0, Utils.dpTOpx(getContext(), 2), 0, Utils.dpTOpx(getContext(), -2));
        mInnerContainer.addView(mOneItemFamilyView, params);

        mOneItemFamilyView.setViewPagerItemClickListener(new ItemViewPagerAdapter.ViewPagerItemClickListener()
        {
            @Override
            public void onClickEnd(ContentItem contentItem, int position)
            {
                if (mAllowClickHandling)
                {
                    mAllowClickHandling = false;
                    ContentExecutionHandler.handleContentItemClick(getContext(), contentItem, WidgetType.WIDGET_TYPE_PANEL.getStringValue(), mStyleId, position, true, new ContentExecutionHandler.IOnHandleClickListener()
                    {
                        @Override
                        public void onRestoreClick()
                        {
                            mAllowClickHandling = true;
                        }
                    });
                }
            }
        });

        // User to force redraw of the panel container and prevent of seeing webview flickering artifacts
        mOneItemFamilyView.setOnRefreshDrawRequestListener(new OneItemFamilyView.IOnRefreshListener()
        {
            @Override
            public void onRefreshDrawRequest()
            {
                mPanelHandle.bringToFront();
                mPanelHandle.requestFocus();
            }
        });

        initNextButton();
        initAnimationView();
    }

    private void initNextButton()
    {
        mNextButton = new AssetView(getContext());
        mNextButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        mNextButton.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        mInnerContainer.addView(mNextButton, params);
        mNextButton.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                mNextButton.setClickable(false);
                GenAnimator.clickItemAnimation(v, 80, new GenAnimator.ViewAnimationListener()
                {
                    @Override
                    public void onAnimationEnd()
                    {
                        mNextButton.setClickable(true);
                        mOneItemFamilyView.nextPagerItem();
                    }

                    @Override
                    public void onAnimationStart()
                    {

                    }
                });
            }
        });
        mNextButton.loadAsset(AssetUtil.getAssetFile(getContext(), mWidgetProperties.optString(FamilyPanelView.NEXT_BTN_URL, null)), null);
    }

    private void initAnimationView()
    {
        mGifView = new AssetView(getContext());
        mGifView.setId(Utils.generateViewId());
        mGifView.setScaleType(ImageView.ScaleType.FIT_END);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        params.setMargins(0, 0, 0, Utils.dpTOpx(getContext(), 4));
        mInnerContainer.addView(mGifView, params);

        mGifView.setOnTouchListener(new View.OnTouchListener()
        {
            @Override
            public boolean onTouch(View v, MotionEvent event)
            {
                return true;
            }
        });
        loadAnimation();
    }

    @Override
    protected void initPanelViewsRules()
    {
        int button = Utils.dpTOpx(getContext(), 30);
        int overallWidth = (int) ((mViewPagerWidth * 1.5) + button);

        RelativeLayout.LayoutParams panelInnerContainerParamas = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        panelInnerContainerParamas.width = overallWidth;
        int margin = Utils.dpTOpx(getContext(), 4);
        mInnerContainer.setPadding(0, margin, 0, margin);
        mInnerContainer.setLayoutParams(panelInnerContainerParamas);

        RelativeLayout.LayoutParams oneItemParams = (LayoutParams) mOneItemFamilyView.getLayoutParams();
        oneItemParams.width = mViewPagerWidth;
        oneItemParams.height = mViewPagerHeight;

        ((RelativeLayout.LayoutParams) mOneItemFamilyView.getLayoutParams()).addRule(RelativeLayout.LEFT_OF, mNextButton.getId());

        //2.1 Fix gif animations params
        RelativeLayout.LayoutParams animationParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        animationParams.addRule(RelativeLayout.LEFT_OF, mOneItemFamilyView.getId());
        animationParams.addRule(RelativeLayout.ALIGN_TOP, mOneItemFamilyView.getId());
        animationParams.addRule(RelativeLayout.ALIGN_BOTTOM, mOneItemFamilyView.getId());
        //animationParams.rightMargin = -2 * Utils.dpTOpx(getContext(), 4);
        mGifView.setLayoutParams(animationParams);

        //Next button params fix
        RelativeLayout.LayoutParams nextButtonParams = new RelativeLayout.LayoutParams(Utils.dpTOpx(getContext(), 30), ViewGroup.LayoutParams.MATCH_PARENT);
        mNextButton.setLayoutParams(nextButtonParams);
        nextButtonParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        nextButtonParams.addRule(RelativeLayout.ALIGN_TOP, mOneItemFamilyView.getId());
        nextButtonParams.addRule(RelativeLayout.ALIGN_BOTTOM, mOneItemFamilyView.getId());

        // 3. Set bottom container params and.
        LayoutParams bottomBarParams = (LayoutParams) mBottomBarContainer.getLayoutParams();
        bottomBarParams.width = overallWidth;
        bottomBarParams.addRule(RelativeLayout.BELOW, mOneItemFamilyView.getId());

        // 5. Set shadow view params.
        RelativeLayout.LayoutParams shadowParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        mShadowView.setLayoutParams(shadowParams);
        shadowParams.addRule(RelativeLayout.ALIGN_LEFT, mInnerContainer.getId());
        shadowParams.addRule(RelativeLayout.ALIGN_RIGHT, mInnerContainer.getId());
        shadowParams.addRule(RelativeLayout.ALIGN_TOP, mInnerContainer.getId());
        shadowParams.addRule(RelativeLayout.ALIGN_BOTTOM, mInnerContainer.getId());

        // 6. Set handle params.
        LayoutParams handleParams = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        mPanelHandle.setLayoutParams(handleParams);

        // 7. Set init visibility of shadow and KIDOZ label.
        mPoweredByTextView.setVisibility(View.VISIBLE);
        mShadowView.setVisibility(View.INVISIBLE);

        int shadowMargin = Utils.dpTOpx(getContext(), 10);

        // 8. Fix rules.
        switch (mPanelType)
        {
            case TOP:
            {
                panelInnerContainerParamas.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                handleParams.addRule(RelativeLayout.BELOW, mInnerContainer.getId());
                shadowParams.bottomMargin = -shadowMargin;
                break;
            }
            case BOTTOM:
            {
                panelInnerContainerParamas.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                handleParams.addRule(RelativeLayout.ABOVE, mInnerContainer.getId());
                shadowParams.topMargin = -shadowMargin;
                break;
            }
        }

        margin = Utils.dpTOpx(getContext(), 6);
        switch (mHandlePosition)
        {
            case CENTER:
            {
                handleParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                panelInnerContainerParamas.addRule(RelativeLayout.CENTER_HORIZONTAL);
                shadowParams.leftMargin = -shadowMargin;
                shadowParams.rightMargin = -shadowMargin;
                break;
            }
            case END:
            {
                handleParams.addRule(RelativeLayout.ALIGN_RIGHT, mInnerContainer.getId());
                handleParams.rightMargin = margin;
                panelInnerContainerParamas.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                shadowParams.leftMargin = -shadowMargin;
                break;
            }
            default:
            {
                handleParams.addRule(RelativeLayout.ALIGN_LEFT, mInnerContainer.getId());
                handleParams.leftMargin = margin;
                panelInnerContainerParamas.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                shadowParams.rightMargin = -shadowMargin;
                break;
            }
        }

        mShadowView.setConfiguration(mPanelType, mHandlePosition);
    }

    @Override
    protected void setContentAndRefresh(final ArrayList<ContentItem> content)
    {
        if (content != null && content.isEmpty() == false)
        {
            mOneItemFamilyView.setContent(content);
        }
    }

    @Override
    protected void onContentDataLoadStarted()
    {
        //mOneItemFamilyView.showLoadingProgressView(true);
    }

    @Override
    protected void onContentDataLoadEnded()
    {
        //mOneItemFamilyView.showLoadingProgressView(false);
    }

    @Override
    protected void onContentDataLoadFailed()
    {
       // mOneItemFamilyView.showLoadingProgressView(false);
    }

    @Override
    protected void clearPanelContent()
    {
        mOneItemFamilyView.clearContent();
    }

    @Override
    protected void setShowable(boolean showable)
    {
        mOneItemFamilyView.setIsAllowShowable(showable);
    }

    @Override
    protected void invokeViewAction(int itemIndex)
    {
        mOneItemFamilyView.invokeViewAction(itemIndex);
    }

    @Override
    protected void onExpandPanelAnimationStarted()
    {
        super.onExpandPanelAnimationStarted();
        mOneItemFamilyView.invokeWidgetOpen();

        mShadowView.setVisibility(View.VISIBLE);
        mOneItemFamilyView.setVisibility(View.VISIBLE);

        startHandlers();
    }

    @Override
    protected void onCollapsePanelAnimationEnded()
    {
        super.onCollapsePanelAnimationEnded();
        mShadowView.setVisibility(View.INVISIBLE);
        mOneItemFamilyView.setVisibility(View.INVISIBLE);

        mOneItemFamilyView.stopAnyPlaybackAction(true);
        mOneItemFamilyView.invokeWidgetClose();

        stopHandlers();
    }

    @Override
    protected void initShadowView()
    {
        mShadowView = new ShadowView(getContext());
        LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
        mContainer.addView(mShadowView, params);
    }

    @Override
    protected void initBottomBar()
    {
        super.initBottomBar();
    }

    @Override
    public void setPanelColor(int color)
    {
        super.setPanelColor(color);

        if (mInnerContainer != null)
        {
            setFamilyColorAndShape(mPanelType, mHandlePosition, mPanelBgColor);
        }
    }

    private void setFamilyColorAndShape(PANEL_TYPE panelType, HANDLE_POSITION handlePosition, int color)
    {
        GradientDrawable shape = new GradientDrawable();
        shape.setColor(color);

        float cornerRadius = Utils.dpTOpx(getContext(), DEFAULT_CORNER_RADIUS);
        switch (panelType)
        {
            case TOP:
            {
                switch (handlePosition)
                {
                    case CENTER:
                    {
                        shape.setCornerRadii(new float[]{0, 0, 0, 0, cornerRadius, cornerRadius, cornerRadius, cornerRadius});
                        break;
                    }
                    case END:
                    {
                        shape.setCornerRadii(new float[]{0, 0, 0, 0, 0, 0, cornerRadius, cornerRadius});
                        break;
                    }
                    default:
                    {
                        shape.setCornerRadii(new float[]{0, 0, 0, 0, cornerRadius, cornerRadius, 0, 0});
                        break;
                    }
                }
                break;
            }
            default:
            {
                switch (handlePosition)
                {
                    case CENTER:
                    {
                        shape.setCornerRadii(new float[]{cornerRadius, cornerRadius, cornerRadius, cornerRadius, 0, 0, 0, 0});
                        break;
                    }
                    case END:
                    {
                        shape.setCornerRadii(new float[]{cornerRadius, cornerRadius, 0, 0, 0, 0, 0, 0});
                        break;
                    }
                    default:
                    {
                        shape.setCornerRadii(new float[]{0, 0, cornerRadius, cornerRadius, 0, 0, 0, 0});
                        break;
                    }
                }
                break;
            }
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN)
        {
            mInnerContainer.setBackground(shape);
        } else
        {
            mInnerContainer.setBackgroundDrawable(shape);
        }
    }

    private void loadAnimation()
    {
        if (mGifView != null)
        {
            mGifView.loadAsset(AssetUtil.getAssetFile(getContext(), mWidgetProperties.optString(FamilyPanelView.MAIN_ANIMATION_URL_NEW, null)), new AssetView.IOnAssetLoadedListener()
            {
                @Override
                public void onAssetLoaded(boolean successful)
                {
                    if (successful == false)
                    {
                        mGifView.loadAsset(AssetUtil.getAssetFile(getContext(), mWidgetProperties.optString(FamilyPanelView.MAIN_ANIMATION_URL, null)), null);
                    }
                }
            });
        }
    }

    public static final String MAIN_ANIMATION_URL = "animUrl";
    public static final String MAIN_ANIMATION_URL_NEW = "animUrlNew";
    public static final String NEXT_BTN_URL = "nextBtnUrl";
    public static final String NEXT_BTN_RATIO = "nextBtnRatio";
    public static final String NEXT_BTN_ANIMATION_TYPE = "nextBtnAnimType";
    public static final String HTML_MAXIMIZE_BTN = "htmlMaximizeBtn";
    public static final String SWAP_CONTENT_REFRESH_RATE_SECONDS = "swapContentRefreshRateSec";

    /**
     * Compare new JSON to old JSON, save the updated JSON to database, delete old assets if needed and download new assets.
     *
     * @param context
     * @param jsonObject
     */
    public static boolean parseFamilyPanelData(Context context, JSONObject jsonObject)
    {

        boolean result = false;
        if (jsonObject != null)
        {
            try
            {
                jsonObject.put(PanelView.TAG, FamilyPanelView.TAG);
                JSONObject oldData = DatabaseManager.getInstance(context).getConfigTable().loadProperties(PanelView.TAG);

                AssetUtil.loadAsset(context, oldData, jsonObject, DEFAULT_OPEN_BTN_SPOSORED_URL);
                AssetUtil.loadAsset(context, oldData, jsonObject, BTN_OPEN_URL);
                AssetUtil.loadAsset(context, oldData, jsonObject, BTN_CLOSE_URL);
                AssetUtil.loadAsset(context, oldData, jsonObject, CIH_BTN_OPEN_HANDLE_OVERLAY_URL);

                AssetUtil.loadAsset(context, oldData, jsonObject, MAIN_ANIMATION_URL_NEW);
                AssetUtil.loadAsset(context, oldData, jsonObject, MAIN_ANIMATION_URL);

                result = AssetUtil.loadAsset(context, oldData, jsonObject, NEXT_BTN_URL);
                if (result)
                {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, HTML_MAXIMIZE_BTN);
                }
                if (result)
                {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, BTN_LOCK_OPEN);
                }
                if (result)
                {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, BTN_LOCK_CLOSED);
                }
                if (result)
                {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, KIDOZ_LOGO_ICON);
                }

                if (result == true)
                {
                    DatabaseManager.getInstance(context).getConfigTable().insertProperties(PanelView.TAG, jsonObject);
                }
            } catch (Exception ex)
            {
                result = false;
                SDKLogger.printErrorLog(PanelView.TAG, "Error when trying to parse kidoz FamilyPanelView properties" + ex.getMessage());
            }
        }
        return result;
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus)
    {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus == true)
        {
            startHandlers();
        } else
        {
            stopHandlers();
        }
    }

    @Override
    protected void onVisibilityChanged(View changedView, int visibility)
    {
        super.onVisibilityChanged(changedView, visibility);

        if (mOneItemFamilyView != null && mOneItemFamilyView.isEmpty() == false)
        {
            if (visibility == View.VISIBLE)
            {
                startHandlers();
            } else
            {
                stopHandlers();
            }
        }
    }

    @Override
    protected void onDetachedFromWindow()
    {
        super.onDetachedFromWindow();

        pauseAction(true);
    }

    private void stopHandlers()
    {
        mOneItemFamilyView.stopAutoScroll();
    }

    private void startHandlers()
    {
        stopHandlers();
        if (getIsPanelViewExpanded())
        {
            mOneItemFamilyView.startAutoScroll();
        }
    }

    /**
     * Used for resuming any action or playback happened before pause
     */
    public void resumeAction(boolean resume)
    {
        if (mOneItemFamilyView != null)
        {
            if (resume)
            {
                mOneItemFamilyView.resumePlaybackAction();
            }
        }
        // if (mGifView != null) mGifView.startGifAnim();
    }

    /**
     * Used for pausing/stoping any action or playback
     */
    public void pauseAction(boolean withFocusOff)
    {
        if (mOneItemFamilyView != null)
        {
            mOneItemFamilyView.stopAnyPlaybackAction(withFocusOff);
        }

        if (mGifView != null) mGifView.stopGifAnim();
    }
}
