package com.kidoz.sdk.api.ui_views;

 


/**
 * Endless scroll listener to notify when we reached to the bottom of the list/grid view and need to load some more data
 */
public abstract class RecycleEndlessScrollListener   
{
	// The minimum amount of items to have below your current scroll position
	// before loading more.
	private int visibleThreshold = 5;
	// The current offset index of data you have loaded
	private int currentPage = 0;
	// The total number of items in the data set after the last load
	private int previousTotalItemCount = 0;
	// True if we are still waiting for the last set of data to load.
	private boolean loading = true;
	// Sets the starting page index
	private int startingPageIndex = 0;


	public RecycleEndlessScrollListener() {
		
	}
	
	public RecycleEndlessScrollListener(int visibleThreshold)
	{
		this.visibleThreshold = visibleThreshold;
	}

	public RecycleEndlessScrollListener(int visibleThreshold, int startPage)
	{
		this.visibleThreshold = visibleThreshold;
		this.startingPageIndex = startPage;
		this.currentPage = startPage;
	}

	// This happens many times a second during a scroll, so be wary of the code you place here.
	// We are given a few useful parameters to help us work out if we need to load some more data,
	// but first we check if we are waiting for the previous load to finish.
	 
	public void onScroll(int firstVisibleItem, int visibleItemCount, int totalItemCount)
	{
		// If the total item count is zero and the previous isn't, assume the
		// list is invalidated and should be reset back to initial state
		if (totalItemCount < previousTotalItemCount)
		{
			this.currentPage = this.startingPageIndex;
			this.previousTotalItemCount = totalItemCount;
			if (totalItemCount == 0)
			{
				this.loading = true;
			}
		} 

		// If it's still loading, we check to see if the dataset count has
		// changed, if so we conclude it has finished loading and update the current page
		// number and total item count.
		if (loading && (totalItemCount > previousTotalItemCount))
		{
			loading = false;
			previousTotalItemCount = totalItemCount;
			currentPage++;
		}

		// If it isn't currently loading, we check to see if we have breached
		// the visibleThreshold and need to reload more data.
		// If we do need to reload some more data, we execute onLoadMore to fetch the data.
		
		//AppLogger.printWarningLog("(COUNT - VISIBLE COUNT)  : " + (totalItemCount - visibleItemCount) +    "         FIRST + VISIBLE_THRESHOLD : " + (firstVisibleItem + visibleThreshold));
		if (!loading && (totalItemCount - visibleItemCount) <= (firstVisibleItem + visibleThreshold))
		{
			onLoadMore(currentPage, totalItemCount);
			loading = true;
		}
	}

	// Defines the process for actually loading more data based on page
	public abstract void onLoadMore(int page, int totalItemsCount);
	
	public int getCurrentPage() {
		return currentPage;
	}
	
	public void setCurrentPageAndCount(int pageNum,int totlaItemsCount) {
		currentPage = pageNum;
		startingPageIndex = pageNum;
	}
}
