package com.kidoz.sdk.api.platforms;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.Toast;

import com.kidoz.sdk.api.FeedButton;
import com.kidoz.sdk.api.FeedView;
import com.kidoz.sdk.api.FlexiView;
import com.kidoz.sdk.api.KidozBanner;
import com.kidoz.sdk.api.KidozInterstitial;
import com.kidoz.sdk.api.PanelView;
import com.kidoz.sdk.api.interfaces.FlexiViewListener;
import com.kidoz.sdk.api.interfaces.IOnFeedViewEventListener;
import com.kidoz.sdk.api.interfaces.IOnPanelViewEventListener;
import com.kidoz.sdk.api.interfaces.KidozPlayerListener;
import com.kidoz.sdk.api.ui_views.flexi_view.FLEXI_POSITION;
import com.kidoz.sdk.api.ui_views.interstitial.BaseInterstitial;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBannerListener;
import com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;

/**
 * Created by Eugine on 1/27/2016.
 */
public abstract class BasePlatformsBridge
{

    // Panel handle Type
    public static final int HANDLE_POSITION_START = 0;
    public static final int HANDLE_POSITION_CENTER = 1;
    public static final int HANDLE_POSITION_END = 2;
    public static final int HANDLE_POSITION_NONE = 3;

    // Panel Type
    public static final int PANEL_TYPE_BOTTOM = 0;
    public static final int PANEL_TYPE_TOP = 1;
    public static final int PANEL_TYPE_LEFT = 2;
    public static final int PANEL_TYPE_RIGHT = 3;

    // Banner position type
    public static final int BANNER_POSITION_TOP = 0;
    public static final int BANNER_POSITION_BOTTOM = 1;
    public static final int BANNER_POSITION_TOP_LEFT = 2;
    public static final int BANNER_POSITION_TOP_RIGHT = 3;
    public static final int BANNER_POSITION_BOTTOM_LEFT = 4;
    public static final int BANNER_POSITION_BOTTOM_RIGHT = 5;

    // Flexi View position type
    public static final int FLEXI_VIEW_POSITION_TOP_START = 0;
    public static final int FLEXI_VIEW_POSITION_TOP_CENTER = 1;
    public static final int FLEXI_VIEW_POSITION_TOP_END = 2;
    public static final int FLEXI_VIEW_POSITION_MID_START = 3;
    public static final int FLEXI_VIEW_POSITION_MID_CENTER = 4;
    public static final int FLEXI_VIEW_POSITION_MID_END = 5;
    public static final int FLEXI_VIEW_POSITION_BOTTOM_START = 6;
    public static final int FLEXI_VIEW_POSITION_BOTTOM_CENTER = 7;
    public static final int FLEXI_VIEW_POSITION_BOTTOM_END = 8;

    protected Context mContext;
    private FeedView mFeedView;
    private PanelView mPanelView;
    private FeedButton mFeedButton;
    private KidozBanner mKidozBanner;
    private FlexiView mFlexiView;
    private KidozInterstitial mInterstitial;

    private FrameLayout mContainer;
    private boolean isContainerAdded = false;
    private RelativeLayout mBannerContainer;

    // Feed callbacks
    public abstract void onClbkFeedDismissView();

    public abstract void onClbkFeedReadyToShow();

    public abstract void onClbkFeedViewReady();

    // Panel callbacks
    public abstract void onClbkPanelViewCollapsed();

    public abstract void onClbkPanelViewReady();

    public abstract void onClbkPanelViewExpanded();

    // Banner callbacks
    public abstract void onClbkBannerViewReady();

    public abstract void onClbkBannerViewShow();

    public abstract void onClbkBannerViewHide();

    public abstract void onClbkBannerContentLoaded();

    public abstract void onClbkBannerContentLoadFailed();

    // FlexiView callbacks
    public abstract void onClbkFlexiViewReady();

    public abstract void onClbkFlexiViewHidden();

    public abstract void onClbkFlexiViewVisible();

    // General Players callbacks
    public abstract void onClbkPlayerOpened();

    public abstract void onClbkPlayerClosed();

    // Interstitial view callbacks
    public abstract void onClbkInterstitialOpened();

    public abstract void onClbkInterstitialClosed();

    public abstract void onClbkInterstitialReady();

    public abstract void onClbkInterstitialLoadFailed();

    public BasePlatformsBridge(Context context)
    {
        mContext = context;
        mContainer = new FrameLayout(mContext);

        initInterstitial(context);
    }

    private void initInterstitial(Context context)
    {
        if (mInterstitial == null)
        {
            mInterstitial = new KidozInterstitial(context);
        }
    }

    /**
     * Check if main container has this view as a child
     */
    private boolean isChildViewExistsInContainer(View view)
    {
        boolean exists = false;
        if (mContainer != null && mContainer.getChildCount() > 0)
        {
            for (int i = 0; i < mContainer.getChildCount(); i++)
            {
                if (mContainer.getChildAt(i) == view)
                {
                    exists = true;
                    break;
                }
            }
        }
        return exists;
    }

    /**
     * Adds views holder container to a main activity view
     */
    private void addContainerIfNeeded()
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (isContainerAdded == false)
                    {
                        ((Activity) mContext).addContentView(
                                mContainer,
                                new ViewGroup.LayoutParams(
                                        ViewGroup.LayoutParams.MATCH_PARENT,
                                        ViewGroup.LayoutParams.MATCH_PARENT));
                        isContainerAdded = true;
                        mContainer.bringToFront();
                    }
                }
            });
        }
    }

    /**
     * Add Feed Button to view
     *
     * @param x the x coordinate of the button
     * @param y the y coordinate of the button
     */
    public void addFeedButton(final int x, final int y)
    {
        addFeedButton(x, y, -1);
    }

    /**
     * Add Feed Button to view
     *
     * @param x    the x coordinate of the button
     * @param y    the y coordinate of the button
     * @param size button size
     */
    public void addFeedButton(final int x, final int y, final int size)
    {
        addFeedButton(x, y, size, true);
    }

    /**
     * Add Feed Button to view
     *
     * @param x    the x coordinate of the button
     * @param y    the y coordinate of the button
     * @param size button size
     */
    public void addFeedButton(final int x, final int y, final int size, final boolean autoShow)
    {
        addContainerIfNeeded();

        if (mFeedButton == null)
        {
            if (mContext instanceof Activity)
            {
                ((Activity) mContext).runOnUiThread(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        if (size == -1)
                        {
                            mFeedButton = new FeedButton(mContext);
                        } else
                        {
                            mFeedButton = new FeedButton(mContext, size);
                        }

                        mFeedButton.getFeedView().setOnFeedViewEventListener(
                                new IOnFeedViewEventListener()
                                {
                                    @Override
                                    public void onDismissView()
                                    {
                                        onClbkFeedDismissView();
                                    }

                                    @Override
                                    public void onReadyToShow()
                                    {
                                        onClbkFeedReadyToShow();
                                    }

                                    @Override
                                    public void onViewReady()
                                    {
                                        onClbkFeedViewReady();
                                    }
                                });

                        mFeedButton.getFeedView().setKidozPlayerListener(new KidozPlayerListener()
                        {
                            @Override
                            public void onPlayerOpen()
                            {
                                super.onPlayerOpen();
                                onClbkPlayerOpened();
                            }

                            @Override
                            public void onPlayerClose()
                            {
                                super.onPlayerClose();
                                onClbkPlayerClosed();
                            }
                        });

                        if (isChildViewExistsInContainer(mFeedButton) == false)
                        {
                            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(
                                    FrameLayout.LayoutParams.WRAP_CONTENT,
                                    FrameLayout.LayoutParams.WRAP_CONTENT);
                            params.setMargins(x, y, 0, 0);
                            mContainer.addView(mFeedButton, params);

                            mContainer.bringToFront();
                            mFeedButton.bringToFront();

                            if (autoShow == false)
                            {
                                mFeedButton.setVisibility(View.INVISIBLE);
                            }
                        }
                    }
                });
            }
        }
    }

    /**
     * Change feed button visibility state
     *
     * @param visible
     */
    public void changeFeedButtonVisibility(final boolean visible)
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mFeedButton != null)
                    {
                        if (visible)
                        {
                            mFeedButton.setVisibility(View.VISIBLE);
                        } else
                        {
                            mFeedButton.setVisibility(View.INVISIBLE);
                        }
                        mFeedButton.bringToFront();
                    }
                }
            });
        }
    }

    /**
     * Get current Feed button size
     *
     * @return button size
     */
    public int getFeedButtonSize()
    {
        if (mFeedButton != null)
        {
            return mFeedButton.getButtonSize();
        } else
        {
            return 0;
        }
    }

    /**
     * Show feed view
     */
    public void showFeedView()
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mFeedView == null)
                    {
                        mFeedView = new FeedView.Builder(mContext).build();
                        mFeedView.setOnFeedViewEventListener(new IOnFeedViewEventListener()
                        {
                            @Override
                            public void onDismissView()
                            {
                                onClbkFeedDismissView();
                            }

                            @Override
                            public void onReadyToShow()
                            {
                                onClbkFeedReadyToShow();
                            }

                            @Override
                            public void onViewReady()
                            {
                                onClbkFeedViewReady();
                            }
                        });

                        mFeedView.setKidozPlayerListener(new KidozPlayerListener()
                        {
                            @Override
                            public void onPlayerOpen()
                            {
                                super.onPlayerOpen();
                                onClbkPlayerOpened();
                            }

                            @Override
                            public void onPlayerClose()
                            {
                                super.onPlayerClose();
                                onClbkPlayerClosed();
                            }
                        });
                    }

                    if (mFeedView != null)
                    {
                        mFeedView.showView();
                    }
                }
            });
        }
    }

    /**
     * Dismiss feed view
     */
    public void dismissFeedView()
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mFeedView != null)
                    {
                        mFeedView.dismissView();
                    }
                }
            });
        }
    }

    /**
     * Add PanelView to view
     *
     * @param panel_type      panel view type
     * @param handle_position panel handle position
     */
    public void addPanelToView(final int panel_type, final int handle_position)
    {
        addPanelToView(panel_type, handle_position, true);
    }

    /**
     * Add PanelView to view
     *
     * @param panel_type      panel view type
     * @param handle_position panel handle position
     * @param autoShow        auto show panel on prepared and ready
     */
    public void addPanelToView(final int panel_type, final int handle_position, final boolean autoShow)
    {
        addPanelToView(panel_type, handle_position, autoShow, -1, -1);
    }

    /**
     * Add PanelView to view
     *
     * @param panel_type      panel view type
     * @param handle_position panel handle position
     * @param startDelay      delay in seconds before automatic invocation of panel expand , pass -1 to  disable
     * @param showPeriod      period in seconds to show the panel before closing it, pass -1 to  disable
     */
    public void addPanelToView(final int panel_type, final int handle_position, final float startDelay, final float showPeriod)
    {
        addPanelToView(panel_type, handle_position, true, startDelay, showPeriod);
    }

    /**
     * Add PanelView to view
     *
     * @param panel_type      panel view type
     * @param handle_position panel handle position
     * @param autoShow        make panel visible on prepared and ready
     * @param startDelay      delay in seconds before automatic invocation of panel expand , pass -1 to  disable
     * @param showPeriod      period in seconds to show the panel before closing it, pass -1 to  disable
     */
    public void addPanelToView(final int panel_type, final int handle_position, final boolean autoShow, final float startDelay, final float showPeriod)
    {
        addContainerIfNeeded();

        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {

                    if (mPanelView == null)
                    {
                        PANEL_TYPE mPanelType = PANEL_TYPE.BOTTOM;
                        HANDLE_POSITION mHandlePos = HANDLE_POSITION.START;

                        switch (panel_type)
                        {
                            case PANEL_TYPE_BOTTOM:
                            {
                                mPanelType = PANEL_TYPE.BOTTOM;
                                break;
                            }
                            case PANEL_TYPE_LEFT:
                            {
                                mPanelType = PANEL_TYPE.LEFT;
                                break;
                            }
                            case PANEL_TYPE_RIGHT:
                            {
                                mPanelType = PANEL_TYPE.RIGHT;
                                break;
                            }
                            case PANEL_TYPE_TOP:
                            {
                                mPanelType = PANEL_TYPE.TOP;
                                break;
                            }
                        }

                        switch (handle_position)
                        {
                            case HANDLE_POSITION_START:
                            {
                                mHandlePos = HANDLE_POSITION.START;
                                break;
                            }
                            case HANDLE_POSITION_CENTER:
                            {
                                mHandlePos = HANDLE_POSITION.CENTER;
                                break;
                            }
                            case HANDLE_POSITION_END:
                            {
                                mHandlePos = HANDLE_POSITION.END;
                                break;
                            }
                            case HANDLE_POSITION_NONE:
                            {
                                mHandlePos = HANDLE_POSITION.NONE;
                                break;
                            }
                        }

                        mPanelView = new PanelView(mContext);
                        mPanelView.setPanelAutoExpand(startDelay, showPeriod);
                        mPanelView.setPanelConfiguration(mPanelType, mHandlePos);
                        mPanelView.setOnPanelViewEventListener(new IOnPanelViewEventListener()
                        {
                            @Override
                            public void onPanelViewCollapsed()
                            {
                                onClbkPanelViewCollapsed();
                            }

                            @Override
                            public void onPanelViewExpanded()
                            {
                                onClbkPanelViewExpanded();
                            }

                            @Override
                            public void onPanelReady()
                            {
                                onClbkPanelViewReady();
                            }
                        });

                        mPanelView.setKidozPlayerListener(new KidozPlayerListener()
                        {
                            @Override
                            public void onPlayerOpen()
                            {
                                super.onPlayerOpen();
                                onClbkPlayerOpened();
                            }

                            @Override
                            public void onPlayerClose()
                            {
                                super.onPlayerClose();
                                onClbkPlayerClosed();
                            }
                        });

                        if (isChildViewExistsInContainer(mPanelView) == false)
                        {
                            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(
                                    FrameLayout.LayoutParams.MATCH_PARENT,
                                    FrameLayout.LayoutParams.MATCH_PARENT);
                            mContainer.addView(mPanelView, params);
                            mPanelView.bringToFront();
                        }

                        if (autoShow == false)
                        {
                            mPanelView.setVisibility(View.INVISIBLE);
                        }
                    }
                }
            });
        }
    }

    /**
     * Change feed button visibility state
     *
     * @param visible
     */
    public void changePanelVisibility(final boolean visible)
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mPanelView != null)
                    {
                        if (visible)
                        {
                            mPanelView.setVisibility(View.VISIBLE);
                        } else
                        {
                            mPanelView.setVisibility(View.INVISIBLE);
                        }
                        mContainer.bringToFront();
                        mPanelView.bringToFront();
                    }
                }
            });
        }
    }

    /**
     * Expand panel view
     */
    public void expandPanelView()
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mPanelView != null && !mPanelView.getIsPanelViewExpanded())
                    {
                        mPanelView.expandPanelView();
                    }
                }
            });
        }
    }

    /**
     * Collapse panel view
     */
    public void collapsePanelView()
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mPanelView != null && mPanelView.getIsPanelViewExpanded())
                    {
                        mPanelView.collapsePanelView();
                    }
                }
            });
        }
    }

    /**
     * Set panel view color
     */
    public void setPanelViewColor(final String colorHexa)
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mPanelView != null)
                    {
                        try
                        {
                            mPanelView.setPanelColor(Color.parseColor(colorHexa));
                        } catch (Exception e)
                        {
                        }
                    }
                }
            });
        }
    }

    /**
     * Set Automatically show panel on being added to view
     *
     * @param startDelay time in seconds,delay before automatic invocation of panel expand
     * @param showPeriod time in seconds,the period to show the panel before closing it
     */
    /*public void setPanelAutoExpand(final float startDelay, final float showPeriod)
    {
        ((Activity) mContext).runOnUiThread(new Runnable()
        {
            @Override
            public void run()
            {
                if (mPanelView != null)
                {
                    mPanelView.setPanelAutoExpand(startDelay, showPeriod);
                }
            }
        });
    }*/

    /**
     * Get is panel expanded
     */
    public boolean getIsPanelExpanded()
    {
        if (mPanelView != null)
        {
            return mPanelView.getIsPanelViewExpanded();
        } else
        {
            return false;
        }
    }

    /**
     * Add Kidoz Banner to view
     *
     * @param bannerPosition banner view position
     */
    public void addBannerToView(final int bannerPosition)
    {
        addBannerToView(bannerPosition, true);
    }

    /**
     * Add Kidoz Banner to view
     *
     * @param bannerPosition banner view position
     * @param autoShow       is auto show on ready
     */
    public void addBannerToView(final int bannerPosition, final boolean autoShow)
    {
        addContainerIfNeeded();

        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mKidozBanner == null)
                    {
                        mKidozBanner = new KidozBanner(mContext);
                        mKidozBanner.setKidozBannerListener(new KidozBannerListener()
                        {
                            @Override
                            public void onBannerReady()
                            {
                                super.onBannerReady();
                                onClbkBannerViewReady();

                                if (autoShow == true)
                                {
                                    mKidozBanner.showBanner();
                                }
                            }

                            @Override
                            public void onBannerShow()
                            {
                                super.onBannerShow();
                                onClbkBannerViewShow();
                            }

                            @Override
                            public void onBannerHide()
                            {
                                super.onBannerHide();
                                onClbkBannerViewHide();
                            }

                            @Override
                            public void onBannerContentLoaded()
                            {
                                super.onBannerContentLoaded();
                                onClbkBannerContentLoaded();
                            }

                            @Override
                            public void onBannerContentLoadFailed()
                            {
                                super.onBannerContentLoadFailed();
                                onClbkBannerContentLoadFailed();
                            }
                        });

                        mKidozBanner.setKidozPlayerListener(new KidozPlayerListener()
                        {
                            @Override
                            public void onPlayerOpen()
                            {
                                super.onPlayerOpen();
                                onClbkPlayerOpened();
                            }

                            @Override
                            public void onPlayerClose()
                            {
                                super.onPlayerClose();
                                onClbkPlayerClosed();
                            }
                        });

                        if (mBannerContainer == null)
                        {
                            mBannerContainer = new RelativeLayout(mContext);

                            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(
                                    FrameLayout.LayoutParams.MATCH_PARENT,
                                    FrameLayout.LayoutParams.MATCH_PARENT);
                            mContainer.addView(mBannerContainer, params);

                            RelativeLayout.LayoutParams bannerPosParams = new RelativeLayout.LayoutParams(
                                    FrameLayout.LayoutParams.WRAP_CONTENT,
                                    FrameLayout.LayoutParams.WRAP_CONTENT);

                            switch (bannerPosition)
                            {
                                case BANNER_POSITION_TOP:
                                {
                                    bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                                    bannerPosParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                                    break;
                                }

                                case BANNER_POSITION_BOTTOM:
                                {
                                    bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                                    bannerPosParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                                    break;
                                }

                                case BANNER_POSITION_TOP_LEFT:
                                {
                                    bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                                    bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                                    break;
                                }

                                case BANNER_POSITION_TOP_RIGHT:
                                {
                                    bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                                    bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                                    break;
                                }

                                case BANNER_POSITION_BOTTOM_LEFT:
                                {
                                    bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                                    bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                                    break;
                                }
                                case BANNER_POSITION_BOTTOM_RIGHT:
                                {
                                    bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                                    bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                                    break;
                                }
                            }

                            if (isChildViewExistsInContainer(mKidozBanner) == false)
                            {
                                mBannerContainer.addView(mKidozBanner, bannerPosParams);
                                mContainer.bringToFront();
                                mKidozBanner.bringToFront();
                            }
                        }
                    }
                }
            });
        }
    }

    /**
     * Change banner position on screen
     *
     * @param bannerPosition banner view position
     */
    public void changeBannerPosition(final int bannerPosition)
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mKidozBanner != null)
                    {
                        RelativeLayout.LayoutParams bannerPosParams = new RelativeLayout.LayoutParams(
                                RelativeLayout.LayoutParams.WRAP_CONTENT,
                                RelativeLayout.LayoutParams.WRAP_CONTENT);

                        switch (bannerPosition)
                        {
                            case BANNER_POSITION_TOP:
                            {
                                bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                                bannerPosParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                                break;
                            }

                            case BANNER_POSITION_BOTTOM:
                            {
                                bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                                bannerPosParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                                break;
                            }

                            case BANNER_POSITION_TOP_LEFT:
                            {
                                bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                                bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                                break;
                            }

                            case BANNER_POSITION_TOP_RIGHT:
                            {
                                bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                                bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                                break;
                            }

                            case BANNER_POSITION_BOTTOM_LEFT:
                            {
                                bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                                bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                                break;
                            }
                            case BANNER_POSITION_BOTTOM_RIGHT:
                            {
                                bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                                bannerPosParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                                break;
                            }
                        }
                        mKidozBanner.setLayoutParams(bannerPosParams);
                    }
                }
            });
        }
    }

    /**
     * Show banner view
     */
    public void showBanner()
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mKidozBanner != null)
                    {
                        mKidozBanner.showBanner();
                    }
                }
            });
        }
    }

    /**
     * Hide banner view
     */
    public void hideBanner()
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mKidozBanner != null)
                    {
                        mKidozBanner.hideBanner();
                    }
                }
            });
        }
    }

    /**
     * Add Flexi Point View to screen
     *
     * @param isAutoShow      is to show flexi view automatically when its ready
     * @param initialPosition initial gravity position of the view
     */
    public void addFlexiView(final boolean isAutoShow, final int initialPosition)
    {
        addContainerIfNeeded();

        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mFlexiView == null)
                    {
                        mFlexiView = new FlexiView(mContext);
                        mFlexiView.setAutoShow(isAutoShow);
                        mFlexiView.setOnFlexiViewEventListener(new FlexiViewListener()
                        {
                            @Override
                            public void onViewHidden()
                            {
                                super.onViewHidden();
                                onClbkFlexiViewHidden();
                            }

                            @Override
                            public void onViewReady()
                            {
                                super.onViewReady();
                                onClbkFlexiViewReady();
                            }

                            @Override
                            public void onViewVisible()
                            {
                                super.onViewVisible();
                                onClbkFlexiViewVisible();
                            }
                        });

                        mFlexiView.setKidozPlayerListener(new KidozPlayerListener()
                        {
                            @Override
                            public void onPlayerOpen()
                            {
                                super.onPlayerOpen();
                                onClbkPlayerOpened();
                            }

                            @Override
                            public void onPlayerClose()
                            {
                                super.onPlayerClose();
                                onClbkPlayerClosed();
                            }
                        });

                        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(
                                FrameLayout.LayoutParams.MATCH_PARENT,
                                FrameLayout.LayoutParams.MATCH_PARENT);

                        switch (initialPosition)
                        {
                            case FLEXI_VIEW_POSITION_TOP_START:
                            {
                                mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.TOP_START);
                                break;
                            }

                            case FLEXI_VIEW_POSITION_TOP_CENTER:
                            {
                                mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.TOP_CENTER);
                                break;
                            }

                            case FLEXI_VIEW_POSITION_TOP_END:
                            {
                                mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.TOP_END);
                                break;
                            }

                            case FLEXI_VIEW_POSITION_MID_START:
                            {
                                mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.MIDDLE_START);
                                break;
                            }

                            case FLEXI_VIEW_POSITION_MID_CENTER:
                            {
                                mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.MIDDLE_CENTER);
                                break;
                            }
                            case FLEXI_VIEW_POSITION_MID_END:
                            {
                                mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.MIDDLE_END);
                                break;
                            }

                            case FLEXI_VIEW_POSITION_BOTTOM_START:
                            {
                                mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.BOTTOM_START);
                                break;
                            }

                            case FLEXI_VIEW_POSITION_BOTTOM_CENTER:
                            {
                                mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.BOTTOM_CENTER);
                                break;
                            }
                            case FLEXI_VIEW_POSITION_BOTTOM_END:
                            {
                                mFlexiView.setFlexiViewInitialPosition(FLEXI_POSITION.BOTTOM_END);
                                break;
                            }
                        }

                        mContainer.addView(mFlexiView, params);
                        mContainer.bringToFront();
                        mFlexiView.bringToFront();
                    }
                }
            });
        }
    }

    /**
     * Show FlexiView view
     */
    public void showFlexiView()
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mFlexiView != null)
                    {
                        mFlexiView.showFlexiView();
                    }
                }
            });
        }
    }

    /**
     * Hide flexi View
     */
    public void hideFlexiView()
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mFlexiView != null)
                    {
                        mFlexiView.hideFlexiView();
                    }
                }
            });
        }
    }

    /**
     * Get is flexi view visible
     *
     * @return is visible
     */
    public boolean getIsFlexiViewVisible()
    {
        if (mFlexiView != null)
        {
            return mFlexiView.getIsFlexiViewVisible();
        } else
        {
            return false;
        }
    }

    /**
     * Set flexi view draggable
     *
     * @param draggable
     */
    public void setFlexiViewDraggable(final boolean draggable)
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mFlexiView != null)
                    {
                        mFlexiView.setDraggable(draggable);
                    }
                }
            });
        }
    }

    /**
     * Set flexi view closable
     *
     * @param closable
     */
    public void setFlexiViewClosable(final boolean closable)
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mFlexiView != null)
                    {
                        mFlexiView.setClosable(closable);
                    }
                }
            });
        }
    }

    /**
     * Load new interstitial ad
     */
    public void loadInterstitialAd(final boolean autoShowOnLoad)
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    initInterstitial(mContext);
                    mInterstitial.setOnInterstitialEventListener(new BaseInterstitial.IOnInterstitialEventListener()
                    {
                        @Override
                        public void onClosed()
                        {
                            onClbkInterstitialClosed();
                        }

                        @Override
                        public void onOpened()
                        {
                            onClbkInterstitialOpened();
                        }

                        @Override
                        public void onReady()
                        {
                            onClbkInterstitialReady();
                            if (autoShowOnLoad)
                            {
                                showInterstitial();
                            }
                        }

                        @Override
                        public void onLoadFailed()
                        {
                            onClbkInterstitialLoadFailed();
                        }
                    });
                    mInterstitial.loadAd();
                }
            });
        }
    }

    /**
     * Show Interstitial view
     */
    public void showInterstitial()
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mInterstitial != null)
                    {
                        mInterstitial.show();
                    }
                }
            });
        }
    }

    /**
     * Get is interstitial loaded
     *
     * @return loaded state
     */
    public boolean getIsInterstitialLoaded()
    {
        if (mInterstitial != null)
        {
            return mInterstitial.isLoaded();
        } else
        {
            return false;
        }
    }

    /**
     * Print toast log
     *
     * @param log text
     */
    public void printToastLog(final String log)
    {
        if (mContext instanceof Activity)
        {
            ((Activity) mContext).runOnUiThread(new Runnable()
            {
                @Override
                public void run()
                {
                    Toast.makeText(mContext, log, Toast.LENGTH_SHORT).show();
                }
            });
        }
    }
}

