package com.kidoz.sdk.api.general.utils;

import android.content.Context;
import android.content.SharedPreferences;

/**
 * Created by roni on 8/9/2015.
 */
public class SharedPreferencesUtils
{
    private static final String SDK_SHARED_PREFERENCES_FILE_NAME = "SDK_SHARED_PREFERENCES_FILE_NAME";
    public static void saveSharedPreferencesData(Context context, String key, String value, int mode)
    {
        if (context != null)
        {
            SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, mode);
            if (key != null)
            {
                SharedPreferences.Editor editor = settings.edit();
                editor.putString(key, value);
                editor.apply();
            }
        }
    }

    public static String loadSharedPreferencesData(Context context, String key, int mode)
    {
        String result = null;
        if (context != null)
        {
            if (key != null)
            {
                SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, mode);
                result = settings.getString(key, null);
            }
        }
        return result;
    }

    public static String loadSharedPreferencesData(Context context, String key, String defaultVal, int mode)
    {
        String result = null;
        if (context != null)
        {
            if (key != null)
            {
                SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, mode);
                result = settings.getString(key, defaultVal);
            }
        }
        return result;
    }

    public static void removeSharedPreferencesData(Context context, String key, int mode)
    {
        if (context != null)
        {
            if (key != null)
            {
                SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, mode);
                SharedPreferences.Editor editor = settings.edit();
                editor.remove(key);
                editor.apply();
            }
        }
    }

    public static void saveSharedPreferencesData(Context context, String key, String value)
    {
        if (context != null)
        {
            saveSharedPreferencesData(context, key, value, Context.MODE_PRIVATE);
        }
    }

    public static String loadSharedPreferencesData(Context context, String key)
    {
        String result = null;
        if (context != null)
        {
            result = loadSharedPreferencesData(context, key, Context.MODE_PRIVATE);
        }
        return result;
    }

    public static String loadSharedPreferencesData(Context context, String key, String defaultVal)
    {
        String result = null;
        if (context != null)
        {
            result = loadSharedPreferencesData(context, key, Context.MODE_PRIVATE);
        }
        return result;
    }

    public static void removeSharedPreferencesData(Context context, String key)
    {
        if (context != null)
        {
            removeSharedPreferencesData(context, key, Context.MODE_PRIVATE);
        }
    }
}
